/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.alignment.CachedIntArray;
import java.util.Arrays;

public final class AlignmentCache {
    private static final ThreadLocal<CachedArrayProvider> local;
    private static boolean enabled;
    private static int limit;

    private AlignmentCache() {
    }

    public static void enable() {
        enabled = true;
    }

    public static CachedIntArray get() {
        if (enabled) {
            return local.get().get();
        }
        return new CachedIntArray();
    }

    public static void release() {
        if (enabled) {
            local.get().release();
        }
    }

    static {
        if (System.getProperty("enableAlignmentCache") != null) {
            AlignmentCache.enable();
        }
        local = new ThreadLocal<CachedArrayProvider>(){

            @Override
            protected CachedArrayProvider initialValue() {
                return new CachedArrayProvider();
            }
        };
        enabled = false;
        limit = 20;
    }

    private static final class CachedArrayProvider {
        int pointer = 0;
        CachedIntArray[] arrays = new CachedIntArray[3];

        private CachedArrayProvider() {
        }

        public CachedIntArray get() {
            CachedIntArray cia;
            if (this.arrays.length == this.pointer) {
                if (limit < this.pointer) {
                    throw new RuntimeException("Too many caches.");
                }
                this.arrays = Arrays.copyOf(this.arrays, this.pointer + 2);
            }
            if ((cia = this.arrays[this.pointer]) == null) {
                cia = this.arrays[this.pointer] = new CachedIntArray();
            }
            ++this.pointer;
            return cia;
        }

        public void release() {
            if (--this.pointer < 0) {
                throw new IllegalStateException("All caches already released.");
            }
        }
    }
}

