/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.util.BitArray;
import com.milaboratory.util.StringUtil;
import java.io.Serializable;
import java.util.Arrays;

public final class AlignmentHelper
implements Serializable {
    protected final String seq1String;
    protected final String seq2String;
    protected final String markup;
    protected final int[] seq1Position;
    protected final int[] seq2Position;
    protected final BitArray match;
    protected final int offset;

    public AlignmentHelper(String seq1String, String seq2String, int[] seq1Position, int[] seq2Position, BitArray match) {
        this(seq1String, seq2String, seq1Position, seq2Position, match, 0);
    }

    public AlignmentHelper(String seq1String, String seq2String, int[] seq1Position, int[] seq2Position, BitArray match, int offset) {
        if (seq1Position.length == 0) {
            seq1Position = new int[1];
        }
        if (seq2Position.length == 0) {
            seq2Position = new int[1];
        }
        this.seq1String = seq1String;
        this.seq2String = seq2String;
        this.seq1Position = seq1Position;
        this.seq2Position = seq2Position;
        this.match = match;
        this.offset = Math.max(Math.max(("" + AlignmentHelper.aL(seq2Position[0])).length(), ("" + AlignmentHelper.aL(seq1Position[0])).length()), offset);
        char[] chars = new char[match.size()];
        Arrays.fill(chars, ' ');
        for (int n : match.getBits()) {
            chars[n] = 124;
        }
        this.markup = new String(chars);
    }

    public AlignmentHelper getRange(int from, int to) {
        return this.getRange(from, to, 0);
    }

    public AlignmentHelper getRange(int from, int to, int offset) {
        return new AlignmentHelper(this.seq1String.substring(from, to), this.seq2String.substring(from, to), Arrays.copyOfRange(this.seq1Position, from, to), Arrays.copyOfRange(this.seq2Position, from, to), this.match.getRange(from, to), offset);
    }

    public AlignmentHelper[] split(int length) {
        return this.split(length, 0);
    }

    public AlignmentHelper[] split(int length, int offset) {
        AlignmentHelper[] ret = new AlignmentHelper[(this.size() + length - 1) / length];
        for (int i = 0; i < ret.length; ++i) {
            int pointer = i * length;
            int l = Math.min(length, this.size() - pointer);
            ret[i] = this.getRange(pointer, pointer + l, offset);
        }
        return ret;
    }

    public double identity() {
        return (double)this.match.bitCount() * 1.0 / (double)this.match.size();
    }

    public int size() {
        return this.match.size();
    }

    public int getSequence1PositionAt(int i) {
        return this.seq1Position[i];
    }

    public int getSequence2PositionAt(int i) {
        return this.seq2Position[i];
    }

    public String getSeq1String() {
        return this.seq1String;
    }

    public String getSeq2String() {
        return this.seq2String;
    }

    public String getMarkup() {
        return this.markup;
    }

    public String getLine1() {
        String startPosition = String.valueOf(AlignmentHelper.aL(this.seq1Position[0]));
        int spaces = this.offset - startPosition.length();
        return StringUtil.spaces(spaces) + startPosition + " " + this.seq1String + " " + AlignmentHelper.aR(this.seq1Position[this.seq1Position.length - 1]);
    }

    public String getLine1Compact() {
        String startPosition = String.valueOf(AlignmentHelper.aL(this.seq1Position[0]));
        int spaces = this.offset - startPosition.length();
        return StringUtil.spaces(spaces) + startPosition + " " + this.toCompact(this.seq1String) + " " + AlignmentHelper.aR(this.seq1Position[this.seq1Position.length - 1]);
    }

    public String getLine2() {
        return StringUtil.spaces(this.offset + 1) + this.markup;
    }

    public String getLine3() {
        String startPosition = String.valueOf(AlignmentHelper.aL(this.seq2Position[0]));
        int spaces = this.offset - startPosition.length();
        return StringUtil.spaces(spaces) + startPosition + " " + this.seq2String + " " + AlignmentHelper.aR(this.seq2Position[this.seq2Position.length - 1]);
    }

    public String toStringWithSeq2Quality(SequenceQuality quality) {
        char[] chars = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            chars[i] = (char)(this.seq2Position[i] < 0 ? 32 : (char)(33 + quality.value(this.seq2Position[i])));
        }
        return this.getLine1() + "\n" + this.getLine2() + "\n" + this.getLine3() + "\n" + StringUtil.spaces(this.offset + 1) + new String(chars);
    }

    public String getLine3Compact() {
        String startPosition = String.valueOf(AlignmentHelper.aL(this.seq2Position[0]));
        int spaces = this.offset - startPosition.length();
        return StringUtil.spaces(spaces) + startPosition + " " + this.toCompact(this.seq2String) + " " + AlignmentHelper.aR(this.seq2Position[this.seq2Position.length - 1]);
    }

    private String toCompact(String seqString) {
        char[] chars = seqString.toCharArray();
        for (int i = 0; i < this.match.size(); ++i) {
            if (!this.match.get(i)) continue;
            chars[i] = Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    public String toString() {
        return this.getLine1() + "\n" + this.getLine2() + "\n" + this.getLine3();
    }

    public String toCompactString() {
        return this.getLine1Compact() + "\n" + this.getLine3Compact();
    }

    private static int aL(int f) {
        return f < 0 ? ~f : f;
    }

    private static int aR(int f) {
        return f < 0 ? ~f - 1 : f;
    }
}

