/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AlignmentIterator;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.sequence.Sequence;

public final class AlignmentIteratorForward<S extends Sequence<S>>
implements AlignmentIterator<S> {
    private final Mutations<S> mutations;
    private final int seq1To;
    private int seq1Position;
    private int seq2Position;
    private int mutationsPointer = 0;
    private int currentMutation;

    public AlignmentIteratorForward(Mutations<S> mutations, Range seq1Range) {
        this(mutations, seq1Range, 0);
    }

    public AlignmentIteratorForward(Mutations<S> mutations, Range seq1Range, int seq2Position) {
        if (mutations.size() > 0 && (mutations.getPositionByIndex(0) < seq1Range.getFrom() || mutations.getPositionByIndex(mutations.size() - 1) > seq1Range.getTo())) {
            throw new IllegalArgumentException("Mutations outside target range.");
        }
        this.mutations = mutations;
        this.seq1To = seq1Range.getTo();
        this.seq1Position = seq1Range.getFrom();
        this.currentMutation = 1;
        this.seq2Position = seq2Position;
    }

    @Override
    public boolean advance() {
        if (this.currentMutation != 1) {
            if (this.currentMutation != 0) {
                switch (Mutation.getRawTypeCode(this.currentMutation)) {
                    case 32: {
                        ++this.seq1Position;
                        ++this.seq2Position;
                        break;
                    }
                    case 64: {
                        ++this.seq1Position;
                        break;
                    }
                    case 96: {
                        ++this.seq2Position;
                    }
                }
                ++this.mutationsPointer;
            } else {
                ++this.seq1Position;
                ++this.seq2Position;
            }
        }
        this.currentMutation = this.mutationsPointer < this.mutations.size() && this.mutations.getPositionByIndex(this.mutationsPointer) == this.seq1Position ? this.mutations.getMutation(this.mutationsPointer) : 0;
        return this.seq1Position < this.seq1To || this.currentMutation != 0;
    }

    @Override
    public int getSeq1Position() {
        return this.seq1Position;
    }

    @Override
    public int getSeq2Position() {
        return this.seq2Position;
    }

    @Override
    public int getMutationsPointer() {
        return this.mutationsPointer;
    }

    @Override
    public int getCurrentMutation() {
        return this.currentMutation;
    }
}

