/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AlignmentIterator;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.sequence.Sequence;

public class AlignmentIteratorReverse<S extends Sequence<S>>
implements AlignmentIterator<S> {
    private final Mutations<S> mutations;
    private final int seq1From;
    private int seq1Position;
    private int seq2Position;
    private int mutationsPointer;
    private int currentMutation;

    public AlignmentIteratorReverse(Mutations<S> mutations, Range seq1Range) {
        this(mutations, seq1Range, 0);
    }

    public AlignmentIteratorReverse(Mutations<S> mutations, Range seq1Range, int seq2Position) {
        this.mutations = mutations;
        this.seq1From = seq1Range.getFrom();
        this.mutationsPointer = mutations.size() - 1;
        this.seq1Position = seq1Range.getTo();
        this.seq2Position = seq2Position;
    }

    @Override
    public boolean advance() {
        int mut;
        int n = mut = this.mutationsPointer >= 0 ? this.mutations.getMutation(this.mutationsPointer) : 0;
        if (Mutation.getRawTypeCode(mut) == 96) {
            mut = Mutation.getPosition(mut) != this.seq1Position ? 0 : mut;
        } else if (Mutation.getPosition(mut) != this.seq1Position - 1) {
            mut = 0;
        }
        if (mut != 0) {
            switch (Mutation.getRawTypeCode(mut)) {
                case 32: {
                    --this.seq1Position;
                    --this.seq2Position;
                    break;
                }
                case 64: {
                    --this.seq1Position;
                    break;
                }
                case 96: {
                    --this.seq2Position;
                }
            }
            --this.mutationsPointer;
        } else {
            --this.seq1Position;
            --this.seq2Position;
        }
        this.currentMutation = mut;
        return this.seq1Position >= this.seq1From;
    }

    @Override
    public int getSeq1Position() {
        return this.seq1Position;
    }

    @Override
    public int getSeq2Position() {
        return this.seq2Position;
    }

    @Override
    public int getMutationsPointer() {
        return this.mutationsPointer + 1;
    }

    @Override
    public int getCurrentMutation() {
        return this.currentMutation;
    }
}

