/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.AlignmentIteratorForward;
import com.milaboratory.core.alignment.AlignmentIteratorReverse;
import com.milaboratory.core.alignment.AlignmentScoring;
import com.milaboratory.core.alignment.LinearGapAlignmentScoring;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.sequence.Sequence;

public class AlignmentTrimmer {
    public static <S extends Sequence<S>> Alignment<S> leftTrimAlignment(Alignment<S> alignment, AlignmentScoring<S> scoring) {
        if (scoring instanceof LinearGapAlignmentScoring) {
            return AlignmentTrimmer.leftTrimAlignment(alignment, (LinearGapAlignmentScoring)scoring);
        }
        if (scoring instanceof AffineGapAlignmentScoring) {
            return AlignmentTrimmer.leftTrimAlignment(alignment, (AffineGapAlignmentScoring)scoring);
        }
        throw new IllegalArgumentException("Unknown scoring type");
    }

    public static <S extends Sequence<S>> Alignment<S> leftTrimAlignment(Alignment<S> alignment, LinearGapAlignmentScoring<S> scoring) {
        S seq1 = alignment.getSequence1();
        AlignmentIteratorForward<S> iterator = alignment.forwardIterator();
        int score = 0;
        int minScore = 1;
        int minSeq1Position = 0;
        int minSeq2Position = 0;
        int minMutPointer = 0;
        while (iterator.advance()) {
            int mut = iterator.getCurrentMutation();
            switch (Mutation.getRawTypeCode(mut)) {
                case 32: {
                    score += scoring.getScore(Mutation.getFrom(mut), Mutation.getTo(mut));
                    break;
                }
                case 64: 
                case 96: {
                    score += scoring.getGapPenalty();
                    break;
                }
                default: {
                    byte c = ((Sequence)seq1).codeAt(iterator.getSeq1Position());
                    score += scoring.getScore(c, c);
                }
            }
            if (score > 0 || score > minScore) continue;
            minScore = score;
            minSeq1Position = Mutation.isInsertion(mut) ? iterator.getSeq1Position() : iterator.getSeq1Position() + 1;
            minSeq2Position = Mutation.isDeletion(mut) ? iterator.getSeq2Position() : iterator.getSeq2Position() + 1;
            minMutPointer = iterator.getMutationsPointer();
        }
        if (minScore == 1) {
            return alignment;
        }
        Mutations<S> mutations = alignment.getAbsoluteMutations();
        return new Alignment<S>(seq1, mutations.getRange(minMutPointer + 1, mutations.size()), new Range(minSeq1Position, alignment.getSequence1Range().getTo()), new Range(minSeq2Position, alignment.getSequence2Range().getTo()), score - minScore);
    }

    public static <S extends Sequence<S>> Alignment<S> leftTrimAlignment(Alignment<S> alignment, AffineGapAlignmentScoring<S> scoring) {
        S seq1 = alignment.getSequence1();
        AlignmentIteratorForward<S> iterator = alignment.forwardIterator();
        int score = 0;
        int minScore = 1;
        int minSeq1Position = 0;
        int minSeq2Position = 0;
        int minMutPointer = 0;
        int prevMut = 0;
        while (iterator.advance()) {
            int mut = iterator.getCurrentMutation();
            switch (Mutation.getRawTypeCode(mut)) {
                case 32: {
                    score += scoring.getScore(Mutation.getFrom(mut), Mutation.getTo(mut));
                    break;
                }
                case 64: {
                    if (Mutation.isDeletion(prevMut) && Mutation.getPosition(prevMut) == iterator.getSeq1Position() - 1) {
                        score += scoring.getGapExtensionPenalty();
                        break;
                    }
                    score += scoring.getGapOpenPenalty();
                    break;
                }
                case 96: {
                    if (Mutation.isInsertion(prevMut) && Mutation.getPosition(prevMut) == iterator.getSeq1Position()) {
                        score += scoring.getGapExtensionPenalty();
                        break;
                    }
                    score += scoring.getGapOpenPenalty();
                    break;
                }
                default: {
                    byte c = ((Sequence)seq1).codeAt(iterator.getSeq1Position());
                    score += scoring.getScore(c, c);
                }
            }
            prevMut = mut;
            if (score > 0 || score > minScore) continue;
            minScore = score;
            minSeq1Position = Mutation.isInsertion(mut) ? iterator.getSeq1Position() : iterator.getSeq1Position() + 1;
            minSeq2Position = Mutation.isDeletion(mut) ? iterator.getSeq2Position() : iterator.getSeq2Position() + 1;
            minMutPointer = iterator.getMutationsPointer();
        }
        if (minScore == 1) {
            return alignment;
        }
        Mutations<S> mutations = alignment.getAbsoluteMutations();
        return new Alignment<S>(seq1, mutations.getRange(minMutPointer + 1, mutations.size()), new Range(minSeq1Position, alignment.getSequence1Range().getTo()), new Range(minSeq2Position, alignment.getSequence2Range().getTo()), score - minScore);
    }

    public static <S extends Sequence<S>> Alignment<S> rightTrimAlignment(Alignment<S> alignment, AlignmentScoring<S> scoring) {
        if (scoring instanceof LinearGapAlignmentScoring) {
            return AlignmentTrimmer.rightTrimAlignment(alignment, (LinearGapAlignmentScoring)scoring);
        }
        if (scoring instanceof AffineGapAlignmentScoring) {
            return AlignmentTrimmer.rightTrimAlignment(alignment, (AffineGapAlignmentScoring)scoring);
        }
        throw new IllegalArgumentException("Unknown scoring type");
    }

    public static <S extends Sequence<S>> Alignment<S> rightTrimAlignment(Alignment<S> alignment, LinearGapAlignmentScoring<S> scoring) {
        S seq1 = alignment.getSequence1();
        AlignmentIteratorReverse<S> iterator = alignment.reverseIterator();
        int score = 0;
        int minScore = 1;
        int minSeq1Position = 0;
        int minSeq2Position = 0;
        int minMutPointer = 0;
        while (iterator.advance()) {
            int mut = iterator.getCurrentMutation();
            switch (Mutation.getRawTypeCode(mut)) {
                case 32: {
                    score += scoring.getScore(Mutation.getFrom(mut), Mutation.getTo(mut));
                    break;
                }
                case 64: 
                case 96: {
                    score += scoring.getGapPenalty();
                    break;
                }
                default: {
                    byte c = ((Sequence)seq1).codeAt(iterator.getSeq1Position());
                    score += scoring.getScore(c, c);
                }
            }
            if (score > 0 || score > minScore) continue;
            minScore = score;
            minSeq1Position = iterator.getSeq1Position();
            minSeq2Position = iterator.getSeq2Position();
            minMutPointer = iterator.getMutationsPointer();
        }
        if (minScore == 1) {
            return alignment;
        }
        Mutations<S> mutations = alignment.getAbsoluteMutations();
        return new Alignment<S>(seq1, mutations.getRange(0, minMutPointer), new Range(alignment.getSequence1Range().getFrom(), minSeq1Position), new Range(alignment.getSequence2Range().getFrom(), minSeq2Position), score - minScore);
    }

    public static <S extends Sequence<S>> Alignment<S> rightTrimAlignment(Alignment<S> alignment, AffineGapAlignmentScoring<S> scoring) {
        S seq1 = alignment.getSequence1();
        AlignmentIteratorReverse<S> iterator = alignment.reverseIterator();
        int score = 0;
        int minScore = 1;
        int minSeq1Position = 0;
        int minSeq2Position = 0;
        int minMutPointer = 0;
        int prevMut = 0;
        while (iterator.advance()) {
            int mut = iterator.getCurrentMutation();
            switch (Mutation.getRawTypeCode(mut)) {
                case 32: {
                    score += scoring.getScore(Mutation.getFrom(mut), Mutation.getTo(mut));
                    break;
                }
                case 64: {
                    if (Mutation.isDeletion(prevMut) && Mutation.getPosition(prevMut) == iterator.getSeq1Position() + 1) {
                        score += scoring.getGapExtensionPenalty();
                        break;
                    }
                    score += scoring.getGapOpenPenalty();
                    break;
                }
                case 96: {
                    if (Mutation.isInsertion(prevMut) && Mutation.getPosition(prevMut) == iterator.getSeq1Position()) {
                        score += scoring.getGapExtensionPenalty();
                        break;
                    }
                    score += scoring.getGapOpenPenalty();
                    break;
                }
                default: {
                    byte c = ((Sequence)seq1).codeAt(iterator.getSeq1Position());
                    score += scoring.getScore(c, c);
                }
            }
            prevMut = mut;
            if (score > 0 || score > minScore) continue;
            minScore = score;
            minSeq1Position = iterator.getSeq1Position();
            minSeq2Position = iterator.getSeq2Position();
            minMutPointer = iterator.getMutationsPointer();
        }
        if (minScore == 1) {
            return alignment;
        }
        Mutations<S> mutations = alignment.getAbsoluteMutations();
        return new Alignment<S>(seq1, mutations.getRange(0, minMutPointer), new Range(alignment.getSequence1Range().getFrom(), minSeq1Position), new Range(alignment.getSequence2Range().getFrom(), minSeq2Position), score - minScore);
    }
}

