/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.AlignmentIteratorForward;
import com.milaboratory.core.alignment.AlignmentScoring;
import com.milaboratory.core.alignment.LinearGapAlignmentScoring;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsUtil;
import com.milaboratory.core.sequence.AbstractSeq;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;

public final class AlignmentUtils {
    private AlignmentUtils() {
    }

    public static <S extends Sequence<S>> int calculateScore(S seq1, Mutations<S> mutations, AlignmentScoring<S> scoring) {
        return AlignmentUtils.calculateScore(seq1, new Range(0, seq1.size()), mutations, scoring);
    }

    public static <S extends Sequence<S>> int calculateScore(S seq1, Range seq1Range, Mutations<S> mutations, AlignmentScoring<S> scoring) {
        if (scoring instanceof LinearGapAlignmentScoring) {
            return AlignmentUtils.calculateScore(seq1, seq1Range, mutations, (LinearGapAlignmentScoring)scoring);
        }
        if (scoring instanceof AffineGapAlignmentScoring) {
            return AlignmentUtils.calculateScore(seq1, seq1Range, mutations, (AffineGapAlignmentScoring)scoring);
        }
        throw new IllegalArgumentException("Unknown scoring type");
    }

    public static <S extends Sequence<S>> int calculateScore(S seq1, Range seq1Range, Mutations<S> mutations, LinearGapAlignmentScoring<S> scoring) {
        if (!mutations.isEmpty() && mutations.getPositionByIndex(0) < seq1Range.getFrom() - 1) {
            throw new IllegalArgumentException();
        }
        AlignmentIteratorForward<S> iterator = new AlignmentIteratorForward<S>(mutations, seq1Range);
        int score = 0;
        block4: while (iterator.advance()) {
            int mut = iterator.getCurrentMutation();
            switch (Mutation.getRawTypeCode(mut)) {
                case 32: {
                    score += scoring.getScore(Mutation.getFrom(mut), Mutation.getTo(mut));
                    continue block4;
                }
                case 64: 
                case 96: {
                    score += scoring.getGapPenalty();
                    continue block4;
                }
            }
            byte c = seq1.codeAt(iterator.getSeq1Position());
            score += scoring.getScore(c, c);
        }
        return score;
    }

    public static <S extends Sequence<S>> int calculateScore(S seq1, Range seq1Range, Mutations<S> mutations, AffineGapAlignmentScoring<S> scoring) {
        if (!mutations.isEmpty() && mutations.getPositionByIndex(0) < seq1Range.getFrom() - 1) {
            throw new IllegalArgumentException();
        }
        AlignmentIteratorForward<S> iterator = new AlignmentIteratorForward<S>(mutations, seq1Range);
        int score = 0;
        int prevMut = 0;
        while (iterator.advance()) {
            int mut = iterator.getCurrentMutation();
            switch (Mutation.getRawTypeCode(mut)) {
                case 32: {
                    score += scoring.getScore(Mutation.getFrom(mut), Mutation.getTo(mut));
                    break;
                }
                case 64: {
                    if (Mutation.isDeletion(prevMut) && Mutation.getPosition(prevMut) == iterator.getSeq1Position() - 1) {
                        score += scoring.getGapExtensionPenalty();
                        break;
                    }
                    score += scoring.getGapOpenPenalty();
                    break;
                }
                case 96: {
                    if (Mutation.isInsertion(prevMut) && Mutation.getPosition(prevMut) == iterator.getSeq1Position()) {
                        score += scoring.getGapExtensionPenalty();
                        break;
                    }
                    score += scoring.getGapOpenPenalty();
                    break;
                }
                default: {
                    byte c = seq1.codeAt(iterator.getSeq1Position());
                    score += scoring.getScore(c, c);
                }
            }
            prevMut = mut;
        }
        return score;
    }

    public static <S extends Sequence<S>> Alignment<S> shiftIndelsAtHomopolymers(Alignment<S> alignment) {
        return new Alignment(alignment.sequence1, MutationsUtil.shiftIndelsAtHomopolymers(alignment.sequence1, alignment.sequence1Range.getFrom(), alignment.mutations), alignment.sequence1Range, alignment.sequence2Range, alignment.score);
    }

    public static <S extends Sequence<S>> String toStringSimple(S initialSequence, Mutations<S> mutations) {
        int pointer = 0;
        int mutPointer = 0;
        Alphabet<S> alphabet = initialSequence.getAlphabet();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        while (pointer < initialSequence.size() || mutPointer < mutations.size()) {
            int mut;
            if (mutPointer < mutations.size() && (mut = mutations.getMutation(mutPointer)) >>> 12 <= pointer) {
                switch (mut & 0x60) {
                    case 32: {
                        if ((mut >> 7 & 0x1F) != initialSequence.codeAt(pointer)) {
                            throw new IllegalArgumentException("Mutation = " + Mutation.toString(initialSequence.getAlphabet(), mut) + " but seq[" + pointer + "]=" + initialSequence.symbolAt(pointer));
                        }
                        sb1.append(Character.toLowerCase(initialSequence.symbolAt(pointer++)));
                        sb2.append(Character.toLowerCase(alphabet.codeToSymbol((byte)(mut & 0x1F))));
                        ++mutPointer;
                        break;
                    }
                    case 64: {
                        if ((mut >> 7 & 0x1F) != initialSequence.codeAt(pointer)) {
                            throw new IllegalArgumentException("Mutation = " + Mutation.toString(initialSequence.getAlphabet(), mut) + " but seq[" + pointer + "]=" + initialSequence.symbolAt(pointer));
                        }
                        sb1.append(initialSequence.symbolAt(pointer++));
                        sb2.append("-");
                        ++mutPointer;
                        break;
                    }
                    case 96: {
                        sb1.append("-");
                        sb2.append(alphabet.codeToSymbol((byte)(mut & 0x1F)));
                        ++mutPointer;
                    }
                }
                continue;
            }
            sb1.append(initialSequence.symbolAt(pointer));
            sb2.append(initialSequence.symbolAt(pointer++));
        }
        return sb1.toString() + "\n" + sb2.toString() + '\n';
    }

    public static <S extends Sequence<S>> S getAlignedSequence2Part(Alignment<S> alignment) {
        return (S)alignment.getRelativeMutations().mutate((Sequence)((AbstractSeq)alignment.getSequence1()).getRange(alignment.getSequence1Range()));
    }
}

