/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.alignment.ScoringMatrixIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public enum BLASTMatrix implements Serializable
{
    BLOSUM45,
    BLOSUM50,
    BLOSUM62,
    BLOSUM80,
    BLOSUM90,
    PAM30,
    PAM70,
    PAM250;

    private volatile int[] iMatrix = null;
    private volatile int[] matrix = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMatrix() {
        if (this.matrix == null) {
            BLASTMatrix bLASTMatrix = this;
            synchronized (bLASTMatrix) {
                if (this.matrix == null) {
                    try (InputStream stream = BLASTMatrix.class.getClassLoader().getResourceAsStream("matrices/" + this.name());){
                        this.matrix = ScoringMatrixIO.readAABlastMatrix(stream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.matrix;
    }
}

