/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.BandedMatrix;
import com.milaboratory.core.alignment.BandedSemiLocalResult;
import com.milaboratory.core.alignment.CachedIntArray;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.sequence.NucleotideSequence;

public class BandedAffineAligner {
    private BandedAffineAligner() {
    }

    public static int align0(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width, MutationsBuilder<NucleotideSequence> mutations, MatrixCache cache) {
        int j;
        int to;
        int i;
        if (length1 == 0 && length2 == 0) {
            return 0;
        }
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        cache.prepareMatrices(size1, size2, width, scoring);
        BandedMatrix main = cache.main;
        BandedMatrix gapIn1 = cache.gapIn1;
        BandedMatrix gapIn2 = cache.gapIn2;
        int gapExtensionPenalty = scoring.getGapExtensionPenalty();
        for (i = 0; i < length1; ++i) {
            to = Math.min(i + main.getRowFactor() - main.getColumnDelta() + 1, length2);
            for (j = Math.max(0, i - main.getColumnDelta()); j < to; ++j) {
                int match = main.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + i), seq2.codeAt(offset2 + j));
                int gap1 = Math.max(main.get(i + 1, j) + scoring.getGapOpenPenalty(), gapIn1.get(i + 1, j) + gapExtensionPenalty);
                int gap2 = Math.max(main.get(i, j + 1) + scoring.getGapOpenPenalty(), gapIn2.get(i, j + 1) + gapExtensionPenalty);
                gapIn1.set(i + 1, j + 1, gap1);
                gapIn2.set(i + 1, j + 1, gap2);
                main.set(i + 1, j + 1, Math.max(match, Math.max(gap1, gap2)));
            }
        }
        to = mutations.size();
        i = length1 - 1;
        j = length2 - 1;
        int pScore = main.get(i + 1, j + 1);
        while (i >= 0 || j >= 0) {
            if (i >= 0 && pScore == gapIn2.get(i + 1, j + 1)) {
                pScore = pScore == gapIn2.get(i, j + 1) + gapExtensionPenalty ? gapIn2.get(i, j + 1) : main.get(i, j + 1);
                mutations.appendDeletion(offset1 + i, seq1.codeAt(offset1 + i));
                --i;
                continue;
            }
            if (j >= 0 && pScore == gapIn1.get(i + 1, j + 1)) {
                pScore = pScore == gapIn1.get(i + 1, j) + gapExtensionPenalty ? gapIn1.get(i + 1, j) : main.get(i + 1, j);
                mutations.appendInsertion(offset1 + i + 1, (NucleotideSequence)seq2.codeAt(offset2 + j));
                --j;
                continue;
            }
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + i);
                byte c2 = seq2.codeAt(offset2 + j);
                if (pScore == main.get(i, j) + scoring.getScore(c1, c2)) {
                    pScore = main.get(i, j);
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            throw new RuntimeException();
        }
        mutations.reverseRange(to, mutations.size());
        return main.get(length1, length2);
    }

    public static BandedSemiLocalResult semiLocalRight0(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width, MutationsBuilder<NucleotideSequence> mutations, MatrixCache cache) {
        int j;
        int to;
        int i;
        if (length1 == 0 || length2 == 0) {
            return new BandedSemiLocalResult(offset1 - 1, offset2 - 1, 0);
        }
        int minLength = Math.min(length1, length2) + width;
        length1 = Math.min(length1, minLength);
        length2 = Math.min(length2, minLength);
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        cache.prepareMatrices(size1, size2, width, scoring);
        BandedMatrix main = cache.main;
        BandedMatrix gapIn1 = cache.gapIn1;
        BandedMatrix gapIn2 = cache.gapIn2;
        int maxI = -1;
        int maxJ = -1;
        int maxScore = 0;
        int gapExtensionPenalty = scoring.getGapExtensionPenalty();
        for (i = 0; i < length1; ++i) {
            to = Math.min(i + main.getRowFactor() - main.getColumnDelta() + 1, length2);
            for (j = Math.max(0, i - main.getColumnDelta()); j < to; ++j) {
                int match = main.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + i), seq2.codeAt(offset2 + j));
                int gap1 = Math.max(main.get(i + 1, j) + scoring.getGapOpenPenalty(), gapIn1.get(i + 1, j) + gapExtensionPenalty);
                int gap2 = Math.max(main.get(i, j + 1) + scoring.getGapOpenPenalty(), gapIn2.get(i, j + 1) + gapExtensionPenalty);
                gapIn1.set(i + 1, j + 1, gap1);
                gapIn2.set(i + 1, j + 1, gap2);
                int score = Math.max(match, Math.max(gap1, gap2));
                main.set(i + 1, j + 1, score);
                if (score <= maxScore) continue;
                maxScore = score;
                maxI = i;
                maxJ = j;
            }
        }
        to = mutations.size();
        i = maxI;
        j = maxJ;
        int pScore = main.get(i + 1, j + 1);
        while (i >= 0 || j >= 0) {
            if (i >= 0 && pScore == gapIn2.get(i + 1, j + 1)) {
                pScore = pScore == gapIn2.get(i, j + 1) + gapExtensionPenalty ? gapIn2.get(i, j + 1) : main.get(i, j + 1);
                mutations.appendDeletion(offset1 + i, seq1.codeAt(offset1 + i));
                --i;
                continue;
            }
            if (j >= 0 && pScore == gapIn1.get(i + 1, j + 1)) {
                pScore = pScore == gapIn1.get(i + 1, j) + gapExtensionPenalty ? gapIn1.get(i + 1, j) : main.get(i + 1, j);
                mutations.appendInsertion(offset1 + i + 1, (NucleotideSequence)seq2.codeAt(offset2 + j));
                --j;
                continue;
            }
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + i);
                byte c2 = seq2.codeAt(offset2 + j);
                if (pScore == main.get(i, j) + scoring.getScore(c1, c2)) {
                    pScore = main.get(i, j);
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            throw new RuntimeException();
        }
        mutations.reverseRange(to, mutations.size());
        return new BandedSemiLocalResult(offset1 + maxI, offset2 + maxJ, maxScore);
    }

    public static BandedSemiLocalResult semiLocalLeft0(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width, MutationsBuilder<NucleotideSequence> mutations, MatrixCache cache) {
        int j;
        int i;
        if (length1 == 0 || length2 == 0) {
            return new BandedSemiLocalResult(offset1 + length1, offset2 + length2, 0);
        }
        offset1 += length1;
        offset2 += length2;
        int minLength = Math.min(length1, length2) + width;
        length1 = Math.min(length1, minLength);
        length2 = Math.min(length2, minLength);
        offset1 -= length1;
        offset2 -= length2;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        cache.prepareMatrices(size1, size2, width, scoring);
        BandedMatrix main = cache.main;
        BandedMatrix gapIn1 = cache.gapIn1;
        BandedMatrix gapIn2 = cache.gapIn2;
        int maxI = -1;
        int maxJ = -1;
        int maxScore = 0;
        int gapExtensionPenalty = scoring.getGapExtensionPenalty();
        for (i = 0; i < length1; ++i) {
            int to = Math.min(i + main.getRowFactor() - main.getColumnDelta() + 1, length2);
            for (j = Math.max(0, i - main.getColumnDelta()); j < to; ++j) {
                int match = main.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + length1 - 1 - i), seq2.codeAt(offset2 + length2 - 1 - j));
                int gap1 = Math.max(main.get(i + 1, j) + scoring.getGapOpenPenalty(), gapIn1.get(i + 1, j) + gapExtensionPenalty);
                int gap2 = Math.max(main.get(i, j + 1) + scoring.getGapOpenPenalty(), gapIn2.get(i, j + 1) + gapExtensionPenalty);
                gapIn1.set(i + 1, j + 1, gap1);
                gapIn2.set(i + 1, j + 1, gap2);
                int score = Math.max(match, Math.max(gap1, gap2));
                main.set(i + 1, j + 1, score);
                if (score <= maxScore) continue;
                maxScore = score;
                maxI = i;
                maxJ = j;
            }
        }
        i = maxI;
        j = maxJ;
        int pScore = main.get(i + 1, j + 1);
        while (i >= 0 || j >= 0) {
            if (i >= 0 && pScore == gapIn2.get(i + 1, j + 1)) {
                pScore = pScore == gapIn2.get(i, j + 1) + gapExtensionPenalty ? gapIn2.get(i, j + 1) : main.get(i, j + 1);
                mutations.appendDeletion(offset1 + length1 - 1 - i, seq1.codeAt(offset1 + length1 - 1 - i));
                --i;
                continue;
            }
            if (j >= 0 && pScore == gapIn1.get(i + 1, j + 1)) {
                pScore = pScore == gapIn1.get(i + 1, j) + gapExtensionPenalty ? gapIn1.get(i + 1, j) : main.get(i + 1, j);
                mutations.appendInsertion(offset1 + length1 - 1 - i, (NucleotideSequence)seq2.codeAt(offset2 + length2 - 1 - j));
                --j;
                continue;
            }
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + length1 - 1 - i);
                byte c2 = seq2.codeAt(offset2 + length2 - 1 - j);
                if (pScore == main.get(i, j) + scoring.getScore(c1, c2)) {
                    pScore = main.get(i, j);
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + length1 - 1 - i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            throw new RuntimeException();
        }
        return new BandedSemiLocalResult(offset1 + length1 - 1 - maxI, offset2 + length2 - 1 - maxJ, maxScore);
    }

    public static BandedSemiLocalResult semiGlobalRight0(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int addedNucleotides1, int offset2, int length2, int addedNucleotides2, int width, MutationsBuilder<NucleotideSequence> mutations, MatrixCache cache) {
        int j;
        int to;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        cache.prepareMatrices(size1, size2, width, scoring);
        BandedMatrix main = cache.main;
        BandedMatrix gapIn1 = cache.gapIn1;
        BandedMatrix gapIn2 = cache.gapIn2;
        int gapExtensionPenalty = scoring.getGapExtensionPenalty();
        for (i = 0; i < length1; ++i) {
            to = Math.min(i + main.getRowFactor() - main.getColumnDelta() + 1, length2);
            for (j = Math.max(0, i - main.getColumnDelta()); j < to; ++j) {
                int match = main.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + i), seq2.codeAt(offset2 + j));
                int gap1 = Math.max(main.get(i + 1, j) + scoring.getGapOpenPenalty(), gapIn1.get(i + 1, j) + gapExtensionPenalty);
                int gap2 = Math.max(main.get(i, j + 1) + scoring.getGapOpenPenalty(), gapIn2.get(i, j + 1) + gapExtensionPenalty);
                gapIn1.set(i + 1, j + 1, gap1);
                gapIn2.set(i + 1, j + 1, gap2);
                main.set(i + 1, j + 1, Math.max(match, Math.max(gap1, gap2)));
            }
        }
        int maxI = 0;
        int maxJ = 0;
        int maxScore = Integer.MIN_VALUE;
        j = length2;
        for (i = length1 - addedNucleotides1; i < size1; ++i) {
            if (maxScore >= main.get(i, j)) continue;
            maxScore = main.get(i, j);
            maxI = i - 1;
            maxJ = j - 1;
        }
        i = length1;
        for (j = length2 - addedNucleotides2; j < size2; ++j) {
            if (maxScore >= main.get(i, j)) continue;
            maxScore = main.get(i, j);
            maxI = i - 1;
            maxJ = j - 1;
        }
        to = mutations.size();
        i = maxI;
        j = maxJ;
        int pScore = main.get(i + 1, j + 1);
        while (i >= 0 || j >= 0) {
            if (i >= 0 && pScore == gapIn2.get(i + 1, j + 1)) {
                pScore = pScore == gapIn2.get(i, j + 1) + gapExtensionPenalty ? gapIn2.get(i, j + 1) : main.get(i, j + 1);
                mutations.appendDeletion(offset1 + i, seq1.codeAt(offset1 + i));
                --i;
                continue;
            }
            if (j >= 0 && pScore == gapIn1.get(i + 1, j + 1)) {
                pScore = pScore == gapIn1.get(i + 1, j) + gapExtensionPenalty ? gapIn1.get(i + 1, j) : main.get(i + 1, j);
                mutations.appendInsertion(offset1 + i + 1, (NucleotideSequence)seq2.codeAt(offset2 + j));
                --j;
                continue;
            }
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + i);
                byte c2 = seq2.codeAt(offset2 + j);
                if (pScore == main.get(i, j) + scoring.getScore(c1, c2)) {
                    pScore = main.get(i, j);
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            throw new RuntimeException();
        }
        mutations.reverseRange(to, mutations.size());
        return new BandedSemiLocalResult(offset1 + maxI, offset2 + maxJ, maxScore);
    }

    public static BandedSemiLocalResult semiGlobalLeft0(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int addedNucleotides1, int offset2, int length2, int addedNucleotides2, int width, MutationsBuilder<NucleotideSequence> mutations, MatrixCache cache) {
        int j;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        cache.prepareMatrices(size1, size2, width, scoring);
        BandedMatrix main = cache.main;
        BandedMatrix gapIn1 = cache.gapIn1;
        BandedMatrix gapIn2 = cache.gapIn2;
        int gapExtensionPenalty = scoring.getGapExtensionPenalty();
        for (i = 0; i < length1; ++i) {
            int to = Math.min(i + main.getRowFactor() - main.getColumnDelta() + 1, length2);
            for (j = Math.max(0, i - main.getColumnDelta()); j < to; ++j) {
                int match = main.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + length1 - 1 - i), seq2.codeAt(offset2 + length2 - 1 - j));
                int gap1 = Math.max(main.get(i + 1, j) + scoring.getGapOpenPenalty(), gapIn1.get(i + 1, j) + gapExtensionPenalty);
                int gap2 = Math.max(main.get(i, j + 1) + scoring.getGapOpenPenalty(), gapIn2.get(i, j + 1) + gapExtensionPenalty);
                gapIn1.set(i + 1, j + 1, gap1);
                gapIn2.set(i + 1, j + 1, gap2);
                main.set(i + 1, j + 1, Math.max(match, Math.max(gap1, gap2)));
            }
        }
        int maxI = 0;
        int maxJ = 0;
        int maxScore = Integer.MIN_VALUE;
        j = length2;
        for (i = length1 - addedNucleotides1; i < size1; ++i) {
            if (maxScore >= main.get(i, j)) continue;
            maxScore = main.get(i, j);
            maxI = i - 1;
            maxJ = j - 1;
        }
        i = length1;
        for (j = length2 - addedNucleotides2; j < size2; ++j) {
            if (maxScore >= main.get(i, j)) continue;
            maxScore = main.get(i, j);
            maxI = i - 1;
            maxJ = j - 1;
        }
        i = maxI;
        j = maxJ;
        int pScore = main.get(i + 1, j + 1);
        while (i >= 0 || j >= 0) {
            if (i >= 0 && pScore == gapIn2.get(i + 1, j + 1)) {
                pScore = pScore == gapIn2.get(i, j + 1) + gapExtensionPenalty ? gapIn2.get(i, j + 1) : main.get(i, j + 1);
                mutations.appendDeletion(offset1 + length1 - 1 - i, seq1.codeAt(offset1 + length1 - 1 - i));
                --i;
                continue;
            }
            if (j >= 0 && pScore == gapIn1.get(i + 1, j + 1)) {
                pScore = pScore == gapIn1.get(i + 1, j) + gapExtensionPenalty ? gapIn1.get(i + 1, j) : main.get(i + 1, j);
                mutations.appendInsertion(offset1 + length1 - 1 - i, (NucleotideSequence)seq2.codeAt(offset2 + length2 - 1 - j));
                --j;
                continue;
            }
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + length1 - 1 - i);
                byte c2 = seq2.codeAt(offset2 + length2 - 1 - j);
                if (pScore == main.get(i, j) + scoring.getScore(c1, c2)) {
                    pScore = main.get(i, j);
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + length1 - 1 - i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            throw new RuntimeException();
        }
        return new BandedSemiLocalResult(offset1 + length1 - 1 - maxI, offset2 + length2 - 1 - maxJ, maxScore);
    }

    public static Alignment<NucleotideSequence> align(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width) {
        MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
        int score = BandedAffineAligner.align0(scoring, seq1, seq2, offset1, length1, offset2, length2, width, mutations, new MatrixCache());
        return new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(offset1, offset1 + length1), new Range(offset2, offset2 + length2), score);
    }

    public static Alignment<NucleotideSequence> align(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int width) {
        return BandedAffineAligner.align(scoring, seq1, seq2, 0, seq1.size(), 0, seq2.size(), width);
    }

    public static Alignment<NucleotideSequence> semiLocalRight(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width) {
        MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
        BandedSemiLocalResult res = BandedAffineAligner.semiLocalRight0(scoring, seq1, seq2, offset1, length1, offset2, length2, width, mutations, new MatrixCache());
        return new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(offset1, res.sequence1Stop + 1), new Range(offset2, res.sequence2Stop + 1), res.score);
    }

    public static Alignment<NucleotideSequence> semiLocalRight(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int width) {
        return BandedAffineAligner.semiLocalRight(scoring, seq1, seq2, 0, seq1.size(), 0, seq2.size(), width);
    }

    public static Alignment<NucleotideSequence> semiLocalLeft(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width) {
        MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
        BandedSemiLocalResult res = BandedAffineAligner.semiLocalLeft0(scoring, seq1, seq2, offset1, length1, offset2, length2, width, mutations, new MatrixCache());
        return new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(res.sequence1Stop, offset1 + length1), new Range(res.sequence2Stop, offset2 + length2), res.score);
    }

    public static Alignment<NucleotideSequence> semiLocalLeft(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int width) {
        return BandedAffineAligner.semiLocalLeft(scoring, seq1, seq2, 0, seq1.size(), 0, seq2.size(), width);
    }

    public static Alignment<NucleotideSequence> semiGlobalRight(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int addedNucleotides1, int offset2, int length2, int addedNucleotides2, int width) {
        MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
        BandedSemiLocalResult res = BandedAffineAligner.semiGlobalRight0(scoring, seq1, seq2, offset1, length1, addedNucleotides1, offset2, length2, addedNucleotides2, width, mutations, new MatrixCache());
        return new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(offset1, res.sequence1Stop + 1), new Range(offset2, res.sequence2Stop + 1), res.score);
    }

    public static Alignment<NucleotideSequence> semiGlobalLeft(AffineGapAlignmentScoring<NucleotideSequence> scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int addedNucleotides1, int offset2, int length2, int addedNucleotides2, int width) {
        MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
        BandedSemiLocalResult res = BandedAffineAligner.semiGlobalLeft0(scoring, seq1, seq2, offset1, length1, addedNucleotides1, offset2, length2, addedNucleotides2, width, mutations, new MatrixCache());
        return new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(res.sequence1Stop, offset1 + length1), new Range(res.sequence2Stop, offset2 + length2), res.score);
    }

    public static final class MatrixCache {
        private final CachedIntArray mainCache = new CachedIntArray();
        private final CachedIntArray gapIn1Cache = new CachedIntArray();
        private final CachedIntArray gapIn2Cache = new CachedIntArray();
        private BandedMatrix main;
        private BandedMatrix gapIn1;
        private BandedMatrix gapIn2;

        private void prepareMatrices(int size1, int size2, int width, AffineGapAlignmentScoring<NucleotideSequence> scoring) {
            int v;
            int i;
            BandedMatrix main = this.main = new BandedMatrix(this.mainCache, size1, size2, width);
            BandedMatrix gapIn1 = this.gapIn1 = new BandedMatrix(this.gapIn1Cache, size1, size2, width);
            BandedMatrix gapIn2 = this.gapIn2 = new BandedMatrix(this.gapIn2Cache, size1, size2, width);
            for (i = main.getRowFactor() - main.getColumnDelta(); i > 0; --i) {
                v = scoring.getGapOpenPenalty() + scoring.getGapExtensionPenalty() * (i - 1);
                main.set(0, i, v);
                gapIn1.set(0, i, v);
                gapIn2.set(0, i, -1073741824);
            }
            for (i = main.getColumnDelta(); i > 0; --i) {
                v = scoring.getGapOpenPenalty() + scoring.getGapExtensionPenalty() * (i - 1);
                main.set(i, 0, v);
                gapIn1.set(i, 0, -1073741824);
                gapIn2.set(i, 0, v);
            }
            main.set(0, 0, 0);
            gapIn1.set(0, 0, -1073741824);
            gapIn2.set(0, 0, -1073741824);
        }
    }
}

