/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.AlignmentCache;
import com.milaboratory.core.alignment.BandedMatrix;
import com.milaboratory.core.alignment.BandedSemiLocalResult;
import com.milaboratory.core.alignment.CachedIntArray;
import com.milaboratory.core.alignment.LinearGapAlignmentScoring;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.sequence.NucleotideSequence;

public final class BandedLinearAligner {
    private BandedLinearAligner() {
    }

    public static float align0(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width, MutationsBuilder<NucleotideSequence> mutations, CachedIntArray cachedArray) {
        int j;
        int to;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        BandedMatrix matrix = new BandedMatrix(cachedArray, size1, size2, width);
        for (i = matrix.getRowFactor() - matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(0, i, scoring.getGapPenalty() * i);
        }
        for (i = matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(i, 0, scoring.getGapPenalty() * i);
        }
        matrix.set(0, 0, 0);
        for (i = 0; i < length1; ++i) {
            to = Math.min(i + matrix.getRowFactor() - matrix.getColumnDelta() + 1, length2);
            for (j = Math.max(0, i - matrix.getColumnDelta()); j < to; ++j) {
                int match = matrix.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + i), seq2.codeAt(offset2 + j));
                int delete = matrix.get(i, j + 1) + scoring.getGapPenalty();
                int insert = matrix.get(i + 1, j) + scoring.getGapPenalty();
                matrix.set(i + 1, j + 1, Math.max(match, Math.max(delete, insert)));
            }
        }
        to = mutations.size();
        i = length1 - 1;
        j = length2 - 1;
        while (i >= 0 || j >= 0) {
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + i);
                byte c2 = seq2.codeAt(offset2 + j);
                if (matrix.get(i + 1, j + 1) == matrix.get(i, j) + scoring.getScore(c1, c2)) {
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            if (i >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i, j + 1) + scoring.getGapPenalty()) {
                mutations.appendDeletion(offset1 + i, seq1.codeAt(offset1 + i));
                --i;
                continue;
            }
            if (j >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i + 1, j) + scoring.getGapPenalty()) {
                mutations.appendInsertion(offset1 + i + 1, (NucleotideSequence)seq2.codeAt(offset2 + j));
                --j;
                continue;
            }
            throw new RuntimeException();
        }
        mutations.reverseRange(to, mutations.size());
        return matrix.get(length1, length2);
    }

    public static BandedSemiLocalResult alignRightAdded0(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int addedNucleotides1, int offset2, int length2, int addedNucleotides2, int width, MutationsBuilder<NucleotideSequence> mutations, CachedIntArray cachedArray) {
        int j;
        int to;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        BandedMatrix matrix = new BandedMatrix(cachedArray, size1, size2, width);
        for (i = matrix.getRowFactor() - matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(0, i, scoring.getGapPenalty() * i);
        }
        for (i = matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(i, 0, scoring.getGapPenalty() * i);
        }
        matrix.set(0, 0, 0);
        for (i = 0; i < length1; ++i) {
            to = Math.min(i + matrix.getRowFactor() - matrix.getColumnDelta() + 1, length2);
            for (j = Math.max(0, i - matrix.getColumnDelta()); j < to; ++j) {
                int match = matrix.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + i), seq2.codeAt(offset2 + j));
                int delete = matrix.get(i, j + 1) + scoring.getGapPenalty();
                int insert = matrix.get(i + 1, j) + scoring.getGapPenalty();
                matrix.set(i + 1, j + 1, Math.max(match, Math.max(delete, insert)));
            }
        }
        int maxI = -1;
        int maxJ = -1;
        int maxScore = Integer.MIN_VALUE;
        j = length2;
        for (i = length1 - addedNucleotides1; i < size1; ++i) {
            if (maxScore >= matrix.get(i, j)) continue;
            maxScore = matrix.get(i, j);
            maxI = i;
            maxJ = j;
        }
        i = length1;
        for (j = length2 - addedNucleotides2; j < size2; ++j) {
            if (maxScore >= matrix.get(i, j)) continue;
            maxScore = matrix.get(i, j);
            maxI = i;
            maxJ = j;
        }
        to = mutations.size();
        i = maxI - 1;
        j = maxJ - 1;
        while (i >= 0 || j >= 0) {
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + i);
                byte c2 = seq2.codeAt(offset2 + j);
                if (matrix.get(i + 1, j + 1) == matrix.get(i, j) + scoring.getScore(c1, c2)) {
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            if (i >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i, j + 1) + scoring.getGapPenalty()) {
                mutations.appendDeletion(offset1 + i, seq1.codeAt(offset1 + i));
                --i;
                continue;
            }
            if (j >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i + 1, j) + scoring.getGapPenalty()) {
                mutations.appendInsertion(offset1 + i + 1, (NucleotideSequence)seq2.codeAt(offset2 + j));
                --j;
                continue;
            }
            throw new RuntimeException();
        }
        mutations.reverseRange(to, mutations.size());
        return new BandedSemiLocalResult(offset1 + maxI - 1, offset2 + maxJ - 1, maxScore);
    }

    public static BandedSemiLocalResult alignLeftAdded0(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int addedNucleotides1, int offset2, int length2, int addedNucleotides2, int width, MutationsBuilder<NucleotideSequence> mutations, CachedIntArray cachedArray) {
        int j;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        BandedMatrix matrix = new BandedMatrix(cachedArray, size1, size2, width);
        for (i = matrix.getRowFactor() - matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(0, i, scoring.getGapPenalty() * i);
        }
        for (i = matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(i, 0, scoring.getGapPenalty() * i);
        }
        matrix.set(0, 0, 0);
        for (i = 0; i < length1; ++i) {
            int to = Math.min(i + matrix.getRowFactor() - matrix.getColumnDelta() + 1, length2);
            for (j = Math.max(0, i - matrix.getColumnDelta()); j < to; ++j) {
                int match = matrix.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + length1 - 1 - i), seq2.codeAt(offset2 + length2 - 1 - j));
                int delete = matrix.get(i, j + 1) + scoring.getGapPenalty();
                int insert = matrix.get(i + 1, j) + scoring.getGapPenalty();
                matrix.set(i + 1, j + 1, Math.max(match, Math.max(delete, insert)));
            }
        }
        int maxI = -1;
        int maxJ = -1;
        int maxScore = Integer.MIN_VALUE;
        j = length2;
        for (i = length1 - addedNucleotides1; i < size1; ++i) {
            if (maxScore >= matrix.get(i, j)) continue;
            maxScore = matrix.get(i, j);
            maxI = i;
            maxJ = j;
        }
        i = length1;
        for (j = length2 - addedNucleotides2; j < size2; ++j) {
            if (maxScore >= matrix.get(i, j)) continue;
            maxScore = matrix.get(i, j);
            maxI = i;
            maxJ = j;
        }
        i = maxI - 1;
        j = maxJ - 1;
        while (i >= 0 || j >= 0) {
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + length1 - 1 - i);
                byte c2 = seq2.codeAt(offset2 + length2 - 1 - j);
                if (matrix.get(i + 1, j + 1) == matrix.get(i, j) + scoring.getScore(c1, c2)) {
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + length1 - 1 - i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            if (i >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i, j + 1) + scoring.getGapPenalty()) {
                mutations.appendDeletion(offset1 + length1 - 1 - i, seq1.codeAt(offset1 + length1 - 1 - i));
                --i;
                continue;
            }
            if (j >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i + 1, j) + scoring.getGapPenalty()) {
                mutations.appendInsertion(offset1 + length1 - 1 - i, (NucleotideSequence)seq2.codeAt(offset2 + length2 - 1 - j));
                --j;
                continue;
            }
            throw new RuntimeException();
        }
        return new BandedSemiLocalResult(offset1 + length1 - maxI, offset2 + length2 - maxJ, maxScore);
    }

    public static BandedSemiLocalResult alignSemiLocalLeft0(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width, int stopPenalty, MutationsBuilder<NucleotideSequence> mutations, CachedIntArray cachedArray) {
        int j;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        int matchReward = scoring.getScore((byte)0, (byte)0);
        BandedMatrix matrix = new BandedMatrix(cachedArray, size1, size2, width);
        for (i = matrix.getRowFactor() - matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(0, i, scoring.getGapPenalty() * i);
        }
        for (i = matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(i, 0, scoring.getGapPenalty() * i);
        }
        matrix.set(0, 0, 0);
        int max = 0;
        int iStop = 0;
        int jStop = 0;
        for (i = 0; i < length1; ++i) {
            int to = Math.min(i + matrix.getRowFactor() - matrix.getColumnDelta() + 1, size2 - 1);
            int rowMax = Integer.MIN_VALUE;
            for (j = Math.max(0, i - matrix.getColumnDelta()); j < to; ++j) {
                int match = matrix.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + i), seq2.codeAt(offset2 + j));
                int delete = matrix.get(i, j + 1) + scoring.getGapPenalty();
                int insert = matrix.get(i + 1, j) + scoring.getGapPenalty();
                match = Math.max(match, Math.max(delete, insert));
                matrix.set(i + 1, j + 1, match);
                if (max < match) {
                    iStop = i + 1;
                    jStop = j + 1;
                    max = match;
                }
                rowMax = Math.max(rowMax, match);
            }
            if (rowMax - i * matchReward < stopPenalty) break;
        }
        int fromL = mutations.size();
        i = iStop - 1;
        j = jStop - 1;
        while (i >= 0 || j >= 0) {
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + i);
                byte c2 = seq2.codeAt(offset2 + j);
                if (matrix.get(i + 1, j + 1) == matrix.get(i, j) + scoring.getScore(c1, c2)) {
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            if (i >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i, j + 1) + scoring.getGapPenalty()) {
                mutations.appendDeletion(offset1 + i, seq1.codeAt(offset1 + i));
                --i;
                continue;
            }
            if (j >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i + 1, j) + scoring.getGapPenalty()) {
                mutations.appendInsertion(offset1 + i + 1, (NucleotideSequence)seq2.codeAt(offset2 + j));
                --j;
                continue;
            }
            throw new RuntimeException();
        }
        mutations.reverseRange(fromL, mutations.size());
        return new BandedSemiLocalResult(offset1 + iStop - 1, offset2 + jStop - 1, max);
    }

    public static BandedSemiLocalResult alignSemiLocalRight0(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width, int stopPenalty, MutationsBuilder<NucleotideSequence> mutations, CachedIntArray cachedArray) {
        int j;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        int matchReward = scoring.getScore((byte)0, (byte)0);
        BandedMatrix matrix = new BandedMatrix(cachedArray, size1, size2, width);
        for (i = matrix.getRowFactor() - matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(0, i, scoring.getGapPenalty() * i);
        }
        for (i = matrix.getColumnDelta(); i > 0; --i) {
            matrix.set(i, 0, scoring.getGapPenalty() * i);
        }
        matrix.set(0, 0, 0);
        int max = 0;
        int iStop = 0;
        int jStop = 0;
        for (i = 0; i < length1; ++i) {
            int to = Math.min(i + matrix.getRowFactor() - matrix.getColumnDelta() + 1, length2);
            int rowMax = Integer.MIN_VALUE;
            for (j = Math.max(0, i - matrix.getColumnDelta()); j < to; ++j) {
                int match = matrix.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + length1 - 1 - i), seq2.codeAt(offset2 + length2 - 1 - j));
                int delete = matrix.get(i, j + 1) + scoring.getGapPenalty();
                int insert = matrix.get(i + 1, j) + scoring.getGapPenalty();
                match = Math.max(match, Math.max(delete, insert));
                matrix.set(i + 1, j + 1, match);
                if (max < match) {
                    iStop = i + 1;
                    jStop = j + 1;
                    max = match;
                }
                rowMax = Math.max(rowMax, match);
            }
            if (rowMax - i * matchReward < stopPenalty) break;
        }
        i = iStop - 1;
        j = jStop - 1;
        while (i >= 0 || j >= 0) {
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + length1 - 1 - i);
                byte c2 = seq2.codeAt(offset2 + length2 - 1 - j);
                if (matrix.get(i + 1, j + 1) == matrix.get(i, j) + scoring.getScore(c1, c2)) {
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + length1 - 1 - i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            if (i >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i, j + 1) + scoring.getGapPenalty()) {
                mutations.appendDeletion(offset1 + length1 - 1 - i, seq1.codeAt(offset1 + length1 - 1 - i));
                --i;
                continue;
            }
            if (j >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i + 1, j) + scoring.getGapPenalty()) {
                mutations.appendInsertion(offset1 + length1 - 1 - i, (NucleotideSequence)seq2.codeAt(offset2 + length2 - 1 - j));
                --j;
                continue;
            }
            throw new RuntimeException();
        }
        return new BandedSemiLocalResult(offset1 + length1 - iStop, offset2 + length2 - jStop, max);
    }

    public static Alignment<NucleotideSequence> align(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int width) {
        return BandedLinearAligner.align(scoring, seq1, seq2, 0, seq1.size(), 0, seq2.size(), width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alignment<NucleotideSequence> align(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width) {
        try {
            MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
            float score = BandedLinearAligner.align0(scoring, seq1, seq2, offset1, length1, offset2, length2, width, mutations, AlignmentCache.get());
            Alignment<NucleotideSequence> alignment = new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(offset1, offset1 + length1), new Range(offset2, offset2 + length2), score);
            return alignment;
        }
        finally {
            AlignmentCache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alignment<NucleotideSequence> alignLeftAdded(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int addedNucleotides1, int offset2, int length2, int addedNucleotides2, int width) {
        try {
            MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
            BandedSemiLocalResult result = BandedLinearAligner.alignLeftAdded0(scoring, seq1, seq2, offset1, length1, addedNucleotides1, offset2, length2, addedNucleotides2, width, mutations, AlignmentCache.get());
            Alignment<NucleotideSequence> alignment = new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(result.sequence1Stop, offset1 + length1), new Range(result.sequence2Stop, offset2 + length2), result.score);
            return alignment;
        }
        finally {
            AlignmentCache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alignment<NucleotideSequence> alignRightAdded(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int addedNucleotides1, int offset2, int length2, int addedNucleotides2, int width) {
        try {
            MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
            BandedSemiLocalResult result = BandedLinearAligner.alignRightAdded0(scoring, seq1, seq2, offset1, length1, addedNucleotides1, offset2, length2, addedNucleotides2, width, mutations, AlignmentCache.get());
            Alignment<NucleotideSequence> alignment = new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(offset1, result.sequence1Stop + 1), new Range(offset2, result.sequence2Stop + 1), result.score);
            return alignment;
        }
        finally {
            AlignmentCache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alignment<NucleotideSequence> alignSemiLocalLeft(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width, int stopPenalty) {
        try {
            int minLength = Math.min(length1, length2) + width + 1;
            length1 = Math.min(length1, minLength);
            length2 = Math.min(length2, minLength);
            MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
            BandedSemiLocalResult result = BandedLinearAligner.alignSemiLocalLeft0(scoring, seq1, seq2, offset1, length1, offset2, length2, width, stopPenalty, mutations, AlignmentCache.get());
            Alignment<NucleotideSequence> alignment = new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(offset1, result.sequence1Stop + 1), new Range(offset2, result.sequence2Stop + 1), result.score);
            return alignment;
        }
        finally {
            AlignmentCache.release();
        }
    }

    public static Alignment<NucleotideSequence> alignSemiLocalLeft(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int width, int stopPenalty) {
        return BandedLinearAligner.alignSemiLocalLeft(scoring, seq1, seq2, 0, seq1.size(), 0, seq2.size(), width, stopPenalty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alignment<NucleotideSequence> alignSemiLocalRight(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int offset1, int length1, int offset2, int length2, int width, int stopPenalty) {
        try {
            int minLength = Math.min(length1, length2) + width + 1;
            int l1 = Math.min(length1, minLength);
            int l2 = Math.min(length2, minLength);
            offset1 = offset1 + length1 - l1;
            offset2 = offset2 + length2 - l2;
            length1 = l1;
            length2 = l2;
            MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
            BandedSemiLocalResult result = BandedLinearAligner.alignSemiLocalRight0(scoring, seq1, seq2, offset1, length1, offset2, length2, width, stopPenalty, mutations, AlignmentCache.get());
            Alignment<NucleotideSequence> alignment = new Alignment<NucleotideSequence>(seq1, mutations.createAndDestroy(), new Range(result.sequence1Stop, offset1 + length1), new Range(result.sequence2Stop, offset2 + length2), result.score);
            return alignment;
        }
        finally {
            AlignmentCache.release();
        }
    }

    public static Alignment<NucleotideSequence> alignSemiLocalRight(LinearGapAlignmentScoring scoring, NucleotideSequence seq1, NucleotideSequence seq2, int width, int stopPenalty) {
        return BandedLinearAligner.alignSemiLocalRight(scoring, seq1, seq2, 0, seq1.size(), 0, seq2.size(), width, stopPenalty);
    }
}

