/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.alignment.CachedIntArray;
import java.io.Serializable;
import java.util.Arrays;

public final class BandedMatrix
implements Serializable {
    public static final int DEFAULT_VALUE = -1073741824;
    private final int[] matrix;
    private final int rowFactor;
    private final int columnDelta;

    public BandedMatrix(CachedIntArray cachedArray, int size1, int size2, int width) {
        if (width >= size1) {
            width = size1 - 1;
        }
        if (width >= size2) {
            width = size2 - 1;
        }
        this.rowFactor = 2 * width + Math.abs(size2 - size1);
        this.columnDelta = -Math.min(0, size2 - size1) + width;
        this.matrix = cachedArray.get((size1 - 1) * this.rowFactor + this.columnDelta + size2);
    }

    public int getRowFactor() {
        return this.rowFactor;
    }

    public int getColumnDelta() {
        return this.columnDelta;
    }

    public int get(int i, int j) {
        if (j - i < -this.columnDelta || j - i > this.rowFactor - this.columnDelta) {
            return -1073741824;
        }
        return this.matrix[i * this.rowFactor + j + this.columnDelta];
    }

    public void set(int i, int j, int value) {
        assert (j - i >= -this.columnDelta && j - i <= this.rowFactor - this.columnDelta) : String.format("i: %s, j: %s, columnDelta: %s, rowFactor: %s", i, j, this.columnDelta, this.rowFactor);
        this.matrix[i * this.rowFactor + j + this.columnDelta] = value;
    }

    public String toString() {
        return Arrays.toString(this.matrix);
    }
}

