/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.milaboratory.core.alignment.AbstractAlignmentScoring;
import com.milaboratory.core.alignment.BLASTMatrix;
import com.milaboratory.core.alignment.SubstitutionMatrix;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.AminoAcidSequence;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class LinearGapAlignmentScoring<S extends Sequence<S>>
extends AbstractAlignmentScoring<S>
implements Serializable {
    private final int gapPenalty;

    private LinearGapAlignmentScoring() {
        super(NucleotideSequence.ALPHABET, new SubstitutionMatrix(Integer.MIN_VALUE, Integer.MIN_VALUE));
        this.gapPenalty = Integer.MIN_VALUE;
    }

    @JsonCreator
    public LinearGapAlignmentScoring(@JsonProperty(value="alphabet") Alphabet<S> alphabet, @JsonProperty(value="subsMatrix") SubstitutionMatrix subsMatrix, @JsonProperty(value="gapPenalty") int gapPenalty) {
        super(alphabet, subsMatrix);
        if (gapPenalty >= 0) {
            throw new IllegalArgumentException();
        }
        this.gapPenalty = gapPenalty;
    }

    public LinearGapAlignmentScoring(Alphabet<S> alphabet, int[] subsMatrix, int gapPenalty) {
        super(alphabet, new SubstitutionMatrix(subsMatrix));
        if (gapPenalty >= 0) {
            throw new IllegalArgumentException();
        }
        this.gapPenalty = gapPenalty;
    }

    public LinearGapAlignmentScoring(Alphabet<S> alphabet, int match, int mismatch, int gap) {
        this(alphabet, new SubstitutionMatrix(match, mismatch), gap);
    }

    public int getGapPenalty() {
        return this.gapPenalty;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinearGapAlignmentScoring that = (LinearGapAlignmentScoring)o;
        return this.gapPenalty == that.gapPenalty;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.gapPenalty;
        return result;
    }

    public static LinearGapAlignmentScoring<NucleotideSequence> getNucleotideBLASTScoring() {
        return LinearGapAlignmentScoring.getNucleotideBLASTScoring(-5);
    }

    public static LinearGapAlignmentScoring<NucleotideSequence> getNucleotideBLASTScoring(int gapPenalty) {
        return new LinearGapAlignmentScoring<NucleotideSequence>(NucleotideSequence.ALPHABET, 5, -4, gapPenalty);
    }

    public static LinearGapAlignmentScoring<AminoAcidSequence> getAminoAcidBLASTScoring(BLASTMatrix matrix) {
        return LinearGapAlignmentScoring.getAminoAcidBLASTScoring(matrix, -5);
    }

    public static LinearGapAlignmentScoring<AminoAcidSequence> getAminoAcidBLASTScoring(BLASTMatrix matrix, int gapPenalty) {
        return new LinearGapAlignmentScoring<AminoAcidSequence>(AminoAcidSequence.ALPHABET, matrix.getMatrix(), gapPenalty);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerializationObject(this.alphabet, this.subsMatrix, this.gapPenalty);
    }

    protected static class SerializationObject
    implements Serializable {
        final Alphabet alphabet;
        final SubstitutionMatrix matrix;
        final int gapPenalty;

        public SerializationObject() {
            this(null, null, 0);
        }

        public SerializationObject(Alphabet alphabet, SubstitutionMatrix matrix, int gapPenalty) {
            this.alphabet = alphabet;
            this.matrix = matrix;
            this.gapPenalty = gapPenalty;
        }

        private Object readResolve() throws ObjectStreamException {
            return new LinearGapAlignmentScoring(this.alphabet, this.matrix, this.gapPenalty);
        }
    }
}

