/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.mutations.MutationType;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.util.BitArray;
import com.milaboratory.util.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiAlignmentHelper {
    int minimalPositionWidth = 0;
    final String subject;
    final String[] queries;
    final int[] subjectPositions;
    final int[][] queryPositions;
    final BitArray[] match;
    final List<String> annotationStrings = new ArrayList<String>();
    final List<String> annotationStringTitles = new ArrayList<String>();
    String subjectLeftTitle;
    final String[] queryLeftTitles;
    String subjectRightTitle;
    final String[] queryRightTitles;
    public static final Settings DEFAULT_SETTINGS = new Settings(false, true, false, ' ', ' ');
    public static final Settings DOT_MATCH_SETTINGS = new Settings(true, true, false, '.', ' ');

    private MultiAlignmentHelper(String subject, String[] queries, int[] subjectPositions, int[][] queryPositions, BitArray[] match) {
        this(subject, queries, subjectPositions, queryPositions, match, "", new String[queries.length], "", new String[queries.length]);
    }

    private MultiAlignmentHelper(String subject, String[] queries, int[] subjectPositions, int[][] queryPositions, BitArray[] match, String subjectLeftTitle, String[] queryLeftTitles, String subjectRightTitle, String[] queryRightTitles) {
        this.subject = subject;
        this.queries = queries;
        this.subjectPositions = subjectPositions;
        this.queryPositions = queryPositions;
        this.match = match;
        this.subjectLeftTitle = subjectLeftTitle;
        this.queryLeftTitles = queryLeftTitles;
        this.subjectRightTitle = subjectRightTitle;
        this.queryRightTitles = queryRightTitles;
    }

    public String getSubjectLeftTitle() {
        return this.subjectLeftTitle;
    }

    public String getSubjectRightTitle() {
        return this.subjectRightTitle;
    }

    public String getQueryLeftTitle(int i) {
        return this.queryLeftTitles[i];
    }

    public String getQueryRightTitle(int i) {
        return this.queryRightTitles[i];
    }

    public int getActualPositionWidth() {
        int ret = ("" + this.getSubjectFrom()).length();
        for (int i = 0; i < this.queries.length; ++i) {
            ret = Math.max(ret, ("" + this.getQueryFrom(i)).length());
        }
        return ret;
    }

    public void setMinimalPositionWidth(int minimalPositionWidth) {
        this.minimalPositionWidth = minimalPositionWidth;
    }

    public MultiAlignmentHelper setSubjectLeftTitle(String subjectLeftTitle) {
        this.subjectLeftTitle = subjectLeftTitle;
        return this;
    }

    public MultiAlignmentHelper addSubjectQuality(String title, SequenceQuality quality) {
        char[] chars = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            chars[i] = this.subjectPositions[i] < 0 ? 32 : (int)MultiAlignmentHelper.simplifiedQuality(quality.value(this.subjectPositions[i]));
        }
        this.addAnnotationString(title, new String(chars));
        return this;
    }

    private static char simplifiedQuality(int value) {
        if ((value /= 5) > 9) {
            value = 9;
        }
        return Integer.toString(value).charAt(0);
    }

    public MultiAlignmentHelper setSubjectRightTitle(String subjectRightTitle) {
        this.subjectRightTitle = subjectRightTitle;
        return this;
    }

    public MultiAlignmentHelper addAnnotationString(String title, String string) {
        if (string.length() != this.size()) {
            throw new IllegalArgumentException();
        }
        this.annotationStrings.add(string);
        this.annotationStringTitles.add(title);
        return this;
    }

    public MultiAlignmentHelper setQueryLeftTitle(int id, String queryLeftTitle) {
        this.queryLeftTitles[id] = queryLeftTitle;
        return this;
    }

    public MultiAlignmentHelper setQueryRightTitle(int id, String queryRightTitle) {
        this.queryRightTitles[id] = queryRightTitle;
        return this;
    }

    public int getSubjectPositionAt(int position) {
        return this.subjectPositions[position];
    }

    public int subjectToAlignmentPosition(int subjectPosition) {
        for (int i = 0; i < this.subjectPositions.length; ++i) {
            if (this.subjectPositions[i] != subjectPosition) continue;
            return i;
        }
        return -1;
    }

    public int getQueryPositionAt(int index, int position) {
        return this.queryPositions[index][position];
    }

    public int getAbsSubjectPositionAt(int position) {
        return MultiAlignmentHelper.aabs(this.subjectPositions[position]);
    }

    public int getAbsQueryPositionAt(int index, int position) {
        return MultiAlignmentHelper.aabs(this.queryPositions[index][position]);
    }

    private static int aabs(int pos) {
        if (pos >= 0) {
            return pos;
        }
        if (pos == -1) {
            return -1;
        }
        return -2 - pos;
    }

    public int getSubjectFrom() {
        return MultiAlignmentHelper.getFirstPosition(this.subjectPositions);
    }

    public int getSubjectTo() {
        return MultiAlignmentHelper.getLastPosition(this.subjectPositions);
    }

    public int getSubjectLength() {
        return 1 + this.getSubjectTo() - this.getSubjectFrom();
    }

    public int getQueryFrom(int index) {
        return MultiAlignmentHelper.getFirstPosition(this.queryPositions[index]);
    }

    public int getQueryTo(int index) {
        return MultiAlignmentHelper.getLastPosition(this.queryPositions[index]);
    }

    public int size() {
        return this.subject.length();
    }

    public MultiAlignmentHelper getRange(int from, int to) {
        boolean[] queriesToExclude = new boolean[this.queries.length];
        int queriesCount = 0;
        for (int i = 0; i < this.queries.length; ++i) {
            boolean exclude = true;
            for (int j = from; j < to; ++j) {
                if (this.queryPositions[i][j] == -1) continue;
                exclude = false;
                break;
            }
            queriesToExclude[i] = exclude;
            if (exclude) continue;
            ++queriesCount;
        }
        String[] cQueries = new String[queriesCount];
        int[][] cQueryPositions = new int[queriesCount][];
        BitArray[] cMatch = new BitArray[queriesCount];
        String[] cQueryLeftTitles = new String[queriesCount];
        String[] cQueryRightTitles = new String[queriesCount];
        int j = 0;
        for (int i = 0; i < this.queries.length; ++i) {
            if (queriesToExclude[i]) continue;
            cQueries[j] = this.queries[i].substring(from, to);
            cQueryPositions[j] = Arrays.copyOfRange(this.queryPositions[i], from, to);
            cMatch[j] = this.match[i].getRange(from, to);
            cQueryLeftTitles[j] = this.queryLeftTitles[i];
            cQueryRightTitles[j] = this.queryRightTitles[i];
            ++j;
        }
        MultiAlignmentHelper result = new MultiAlignmentHelper(this.subject.substring(from, to), cQueries, Arrays.copyOfRange(this.subjectPositions, from, to), cQueryPositions, cMatch, this.subjectLeftTitle, cQueryLeftTitles, this.subjectRightTitle, cQueryRightTitles);
        for (int i = 0; i < this.annotationStrings.size(); ++i) {
            result.addAnnotationString(this.annotationStringTitles.get(i), this.annotationStrings.get(i).substring(from, to));
        }
        return result;
    }

    public MultiAlignmentHelper[] split(int length) {
        return this.split(length, false);
    }

    public MultiAlignmentHelper[] split(int length, boolean eqPositionWidth) {
        MultiAlignmentHelper[] ret = new MultiAlignmentHelper[(this.size() + length - 1) / length];
        for (int i = 0; i < ret.length; ++i) {
            int pointer = i * length;
            int l = Math.min(length, this.size() - pointer);
            ret[i] = this.getRange(pointer, pointer + l);
        }
        if (eqPositionWidth) {
            MultiAlignmentHelper.alignPositions(ret);
        }
        return ret;
    }

    private static int getFirstPosition(int[] array) {
        for (int pos : array) {
            if (pos < 0) continue;
            return pos;
        }
        for (int pos : array) {
            if (pos >= -1) continue;
            return -2 - pos;
        }
        return -1;
    }

    private static int getLastPosition(int[] array) {
        int i;
        for (i = array.length - 1; i >= 0; --i) {
            if (array[i] < 0) continue;
            return array[i];
        }
        for (i = array.length - 1; i >= 0; --i) {
            if (array[i] >= -1) continue;
            return -2 - array[i];
        }
        return -1;
    }

    private static int fixedWidthL(String[] strings) {
        return MultiAlignmentHelper.fixedWidthL(strings, 0);
    }

    private static int fixedWidthL(String[] strings, int minWidth) {
        int length = 0;
        for (String string : strings) {
            length = Math.max(length, string.length());
        }
        length = Math.max(length, minWidth);
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = MultiAlignmentHelper.spaces(length - strings[i].length()) + strings[i];
        }
        return length;
    }

    private static int fixedWidthR(String[] strings) {
        return MultiAlignmentHelper.fixedWidthR(strings, 0);
    }

    private static int fixedWidthR(String[] strings, int minWidth) {
        int length = 0;
        for (String string : strings) {
            length = Math.max(length, string.length());
        }
        length = Math.max(length, minWidth);
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i] + MultiAlignmentHelper.spaces(length - strings[i].length());
        }
        return length;
    }

    public String toString() {
        int i;
        int i2;
        int aCount = this.queries.length;
        int asSize = this.annotationStringTitles.size();
        String[] lines = new String[aCount + 1 + asSize];
        for (i2 = 0; i2 < asSize; ++i2) {
            lines[i2] = "";
        }
        lines[asSize] = "" + this.getSubjectFrom();
        for (i2 = 0; i2 < aCount; ++i2) {
            lines[i2 + 1 + asSize] = "" + this.getQueryFrom(i2);
        }
        int width = MultiAlignmentHelper.fixedWidthL(lines, this.minimalPositionWidth);
        for (i = 0; i < asSize; ++i) {
            lines[i] = this.annotationStringTitles.get(i) + MultiAlignmentHelper.spaces(width + 1);
        }
        lines[asSize] = (this.subjectLeftTitle == null ? "" : this.subjectLeftTitle) + " " + lines[asSize];
        for (i = 0; i < aCount; ++i) {
            lines[i + 1 + asSize] = (this.queryLeftTitles[i] == null ? "" : this.queryLeftTitles[i]) + " " + lines[i + 1 + asSize];
        }
        width = MultiAlignmentHelper.fixedWidthL(lines);
        for (i = 0; i < asSize; ++i) {
            int n = i;
            lines[n] = lines[n] + " " + this.annotationStrings.get(i);
        }
        int n = asSize;
        lines[n] = lines[n] + " " + this.subject + " " + this.getSubjectTo();
        for (i = 0; i < aCount; ++i) {
            int n2 = i + 1 + asSize;
            lines[n2] = lines[n2] + " " + this.queries[i] + " " + this.getQueryTo(i);
        }
        width = MultiAlignmentHelper.fixedWidthR(lines);
        int n3 = asSize;
        lines[n3] = lines[n3] + " " + this.subjectRightTitle;
        for (i = 0; i < aCount; ++i) {
            if (this.queryRightTitles[i] == null) continue;
            int n4 = i + 1 + asSize;
            lines[n4] = lines[n4] + " " + this.queryRightTitles[i];
        }
        StringBuilder result = new StringBuilder();
        for (int i3 = 0; i3 < lines.length; ++i3) {
            if (i3 != 0) {
                result.append("\n");
            }
            result.append(lines[i3]);
        }
        return result.toString();
    }

    public static <S extends Sequence<S>> MultiAlignmentHelper build(Settings settings, Range subjectRange, Alignment<S> ... alignments) {
        S subject = alignments[0].getSequence1();
        return MultiAlignmentHelper.build(settings, subjectRange, subject, alignments);
    }

    public static <S extends Sequence<S>> MultiAlignmentHelper build(Settings settings, Range subjectRange, S subject, Alignment<S> ... alignments) {
        int i;
        for (Alignment<S> alignment : alignments) {
            if (((Sequence)alignment.getSequence1()).equals(subject)) continue;
            throw new IllegalArgumentException();
        }
        int subjectPointer = subjectRange.getFrom();
        int subjectPointerTo = subjectRange.getTo();
        int aCount = alignments.length;
        int[] queryPointers = new int[aCount];
        int[] mutationPointers = new int[aCount];
        Mutations[] mutations = new Mutations[aCount];
        List[] matches = new List[aCount];
        IntArrayList subjectPositions = new IntArrayList();
        IntArrayList[] queryPositions = new IntArrayList[aCount];
        StringBuilder subjectString = new StringBuilder();
        StringBuilder[] queryStrings = new StringBuilder[aCount];
        for (int i2 = 0; i2 < aCount; ++i2) {
            queryPointers[i2] = alignments[i2].getSequence2Range().getFrom();
            matches[i2] = new ArrayList();
            mutations[i2] = alignments[i2].getAbsoluteMutations();
            queryPositions[i2] = new IntArrayList();
            queryStrings[i2] = new StringBuilder();
        }
        Alphabet<S> alphabet = subject.getAlphabet();
        BitArray processed = new BitArray(aCount);
        block6: while (true) {
            int i3;
            int i4;
            boolean doContinue = subjectPointer < subjectPointerTo;
            for (i4 = 0; i4 < aCount; ++i4) {
                doContinue |= mutationPointers[i4] < mutations[i4].size();
            }
            if (!doContinue) break;
            processed.clearAll();
            for (i4 = 0; i4 < aCount; ++i4) {
                if (alignments[i4].getSequence1Range().contains(subjectPointer) || alignments[i4].getSequence1Range().containsBoundary(subjectPointer) && mutationPointers[i4] != mutations[i4].size()) continue;
                queryStrings[i4].append(settings.outOfRangeChar);
                queryPositions[i4].add(-1);
                matches[i4].add(false);
                processed.set(i4);
            }
            boolean insertion = false;
            for (i3 = 0; i3 < aCount; ++i3) {
                if (mutationPointers[i3] >= mutations[i3].size() || mutations[i3].getTypeByIndex(mutationPointers[i3]) != MutationType.Insertion || mutations[i3].getPositionByIndex(mutationPointers[i3]) != subjectPointer) continue;
                insertion = true;
                queryStrings[i3].append(mutations[i3].getToAsSymbolByIndex(mutationPointers[i3]));
                int n = i3;
                int n2 = queryPointers[n];
                queryPointers[n] = n2 + 1;
                queryPositions[i3].add(n2);
                matches[i3].add(false);
                int n3 = i3;
                mutationPointers[n3] = mutationPointers[n3] + 1;
                assert (!processed.get(i3));
                processed.set(i3);
            }
            if (insertion) {
                subjectString.append('-');
                subjectPositions.add(-2 - subjectPointer);
                i3 = 0;
                while (true) {
                    if (i3 >= aCount) continue block6;
                    if (!processed.get(i3)) {
                        queryStrings[i3].append('-');
                        queryPositions[i3].add(-2 - queryPointers[i3]);
                        matches[i3].add(false);
                    }
                    ++i3;
                }
            }
            char subjectSymbol = subject.symbolAt(subjectPointer);
            subjectString.append(subjectSymbol);
            subjectPositions.add(subjectPointer);
            for (i = 0; i < aCount; ++i) {
                if (processed.get(i)) continue;
                Mutations cMutations = mutations[i];
                int cMutationPointer = mutationPointers[i];
                boolean mutated = false;
                if (cMutationPointer < cMutations.size()) {
                    int mutPosition = cMutations.getPositionByIndex(cMutationPointer);
                    assert (mutPosition >= subjectPointer);
                    boolean bl = mutated = mutPosition == subjectPointer;
                }
                if (mutated) {
                    switch (cMutations.getRawTypeByIndex(cMutationPointer)) {
                        case 32: {
                            char symbol = cMutations.getToAsSymbolByIndex(cMutationPointer);
                            queryStrings[i].append(settings.lowerCaseMismatch ? Character.toLowerCase(symbol) : symbol);
                            int n = i;
                            int n4 = queryPointers[n];
                            queryPointers[n] = n4 + 1;
                            queryPositions[i].add(n4);
                            matches[i].add(false);
                            break;
                        }
                        case 64: {
                            queryStrings[i].append('-');
                            queryPositions[i].add(-2 - queryPointers[i]);
                            matches[i].add(false);
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    int n = i;
                    mutationPointers[n] = mutationPointers[n] + 1;
                    continue;
                }
                if (settings.markMatchWithSpecialLetter) {
                    queryStrings[i].append(settings.matchChar);
                } else {
                    queryStrings[i].append(settings.lowerCaseMatch ? Character.toLowerCase(subjectSymbol) : subjectSymbol);
                }
                int n = i;
                int n5 = queryPointers[n];
                queryPointers[n] = n5 + 1;
                queryPositions[i].add(n5);
                matches[i].add(true);
            }
            ++subjectPointer;
        }
        int[][] queryPositionsArrays = new int[aCount][];
        BitArray[] matchesBAs = new BitArray[aCount];
        String[] queryStringsArray = new String[aCount];
        for (i = 0; i < aCount; ++i) {
            queryPositionsArrays[i] = queryPositions[i].toArray();
            matchesBAs[i] = new BitArray(matches[i]);
            queryStringsArray[i] = queryStrings[i].toString();
        }
        return new MultiAlignmentHelper(subjectString.toString(), queryStringsArray, subjectPositions.toArray(), queryPositionsArrays, matchesBAs);
    }

    public static void alignPositions(MultiAlignmentHelper[] helpers) {
        int maxPositionWidth = 0;
        for (MultiAlignmentHelper helper : helpers) {
            maxPositionWidth = Math.max(maxPositionWidth, helper.getActualPositionWidth());
        }
        for (MultiAlignmentHelper helper : helpers) {
            helper.setMinimalPositionWidth(maxPositionWidth);
        }
    }

    private static String spaces(int n) {
        char[] c = new char[n];
        Arrays.fill(c, ' ');
        return String.valueOf(c);
    }

    public static class Settings {
        public final boolean markMatchWithSpecialLetter;
        public final boolean lowerCaseMatch;
        public final boolean lowerCaseMismatch;
        public final char matchChar;
        public final char outOfRangeChar;

        public Settings(boolean markMatchWithSpecialLetter, boolean lowerCaseMatch, boolean lowerCaseMismatch, char matchChar, char outOfRangeChar) {
            this.markMatchWithSpecialLetter = markMatchWithSpecialLetter;
            this.lowerCaseMatch = lowerCaseMatch;
            this.lowerCaseMismatch = lowerCaseMismatch;
            this.matchChar = matchChar;
            this.outOfRangeChar = outOfRangeChar;
        }
    }
}

