/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.milaboratory.core.alignment.SubstitutionMatrix;
import com.milaboratory.core.sequence.AminoAcidSequence;
import com.milaboratory.util.IntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

final class ScoringMatrixIO {
    ScoringMatrixIO() {
    }

    public static int[] readAABlastMatrix(InputStream stream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        int[] stopValues = new int[]{0, 21};
        IntArrayList mappings = new IntArrayList(30);
        int alSize = AminoAcidSequence.ALPHABET.size();
        int[] matrix = new int[alSize * alSize];
        Arrays.fill(matrix, Integer.MIN_VALUE);
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (line.startsWith(" ")) {
                String[] letters = line.trim().split("\\s+");
                for (int i = 0; i < letters.length; ++i) {
                    mappings.add(ScoringMatrixIO.getAACode(letters[i]));
                }
                continue;
            }
            String[] cells = line.trim().split("\\s+");
            for (int from : ScoringMatrixIO.getVals(ScoringMatrixIO.getAACode(cells[0]), stopValues)) {
                for (int i = 1; i < cells.length; ++i) {
                    for (int to : ScoringMatrixIO.getVals(mappings.get(i - 1), stopValues)) {
                        matrix[from * alSize + to] = Integer.parseInt(cells[i]);
                    }
                }
            }
        }
        for (int val : matrix) {
            if (val != Integer.MIN_VALUE) continue;
            throw new IllegalArgumentException("Some letters are missing in matrix.");
        }
        return matrix;
    }

    private static int[] getVals(int ll, int[] stopValues) {
        if (ll == -1) {
            return new int[0];
        }
        if (ll == -2) {
            return stopValues;
        }
        return new int[]{ll};
    }

    private static byte getAACode(String letter) {
        if (letter.length() != 1) {
            throw new IllegalArgumentException();
        }
        char l = letter.charAt(0);
        if (l == '*' || l == '*') {
            return -2;
        }
        return AminoAcidSequence.ALPHABET.symbolToCode(l);
    }

    public static final class Serializer
    extends JsonSerializer<SubstitutionMatrix> {
        public void serialize(SubstitutionMatrix value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value.data.length == 2) {
                jgen.writeString("simple(match = " + value.data[0] + ", mismatch = " + value.data[1] + ")");
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < value.data.length; ++i) {
                    sb.append(value.data[i]);
                    sb.append(", ");
                }
                sb.delete(sb.length() - 2, sb.length());
                jgen.writeString("raw(" + sb.toString() + ")");
            }
        }
    }

    public static final class Deserializer
    extends JsonDeserializer<SubstitutionMatrix> {
        public SubstitutionMatrix deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String strValue = (String)jp.readValueAs(String.class);
            if ((strValue = strValue.replaceAll("\\s", "").toLowerCase()).startsWith("raw(")) {
                if (!strValue.endsWith(")")) {
                    throw new IOException("Not balanced brackets in : " + strValue);
                }
                strValue = strValue.substring(4, strValue.length() - 1);
                String[] split = strValue.split(",");
                int[] values = new int[split.length];
                for (int i = 0; i < split.length; ++i) {
                    values[i] = Integer.parseInt(split[i], 10);
                }
                return new SubstitutionMatrix(values);
            }
            if (strValue.startsWith("simple(")) {
                if (!strValue.endsWith(")")) {
                    throw new IOException("Not balanced brackets in : " + strValue);
                }
                strValue = strValue.substring(7, strValue.length() - 1);
                String[] split = strValue.split(",");
                int match = Integer.MIN_VALUE;
                int mismatch = Integer.MIN_VALUE;
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].startsWith("match=")) {
                        match = Integer.parseInt(split[i].substring(6), 10);
                    }
                    if (!split[i].startsWith("mismatch=")) continue;
                    mismatch = Integer.parseInt(split[i].substring(9), 10);
                }
                if (match == Integer.MIN_VALUE) {
                    throw new IOException("Match value not set in : " + strValue);
                }
                if (mismatch == Integer.MIN_VALUE) {
                    throw new IOException("Mismatch value not set in : " + strValue);
                }
                return new SubstitutionMatrix(match, mismatch);
            }
            throw new IOException("Can't parse: " + strValue);
        }
    }
}

