/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Wildcard;
import gnu.trove.set.hash.TByteHashSet;
import java.util.Arrays;

public final class ScoringUtils {
    private ScoringUtils() {
    }

    public static int[] getSymmetricMatrix(int match, int mismatch, Alphabet<?> alphabet) {
        int codes = alphabet.size();
        int[] matrix = new int[codes * codes];
        Arrays.fill(matrix, mismatch);
        for (int i = 0; i < codes; ++i) {
            matrix[i + codes * i] = match;
        }
        return ScoringUtils.fillWildcardScores(matrix, alphabet, new byte[0]);
    }

    public static int[] setMismatchScore(Alphabet<?> alphabet, int[] matrix, int mismatch) {
        int size = (int)Math.round(Math.sqrt(matrix.length));
        if (size * size != matrix.length || alphabet.size() != size) {
            throw new IllegalArgumentException();
        }
        int[] result = (int[])matrix.clone();
        int basicSize = alphabet.basicSize();
        for (int i = 0; i < basicSize; ++i) {
            for (int j = 0; j < basicSize; ++j) {
                if (i == j) continue;
                result[i + size * j] = mismatch;
            }
        }
        return ScoringUtils.fillWildcardScores(result, alphabet, new byte[0]);
    }

    public static int[] setMatchScore(Alphabet<?> alphabet, int[] matrix, int match) {
        int size = (int)Math.round(Math.sqrt(matrix.length));
        if (size * size != matrix.length || alphabet.size() != size) {
            throw new IllegalArgumentException();
        }
        int[] result = (int[])matrix.clone();
        int basicSize = alphabet.basicSize();
        for (int i = 0; i < basicSize; ++i) {
            result[i + size * i] = match;
        }
        return ScoringUtils.fillWildcardScores(result, alphabet, new byte[0]);
    }

    public static int[] fillWildcardScores(int[] matrix, Alphabet<?> alphabet, byte ... exclude) {
        int alSize = alphabet.size();
        if (matrix.length != alSize * alSize) {
            throw new IllegalArgumentException("Wrong matrix size.");
        }
        TByteHashSet excludeSet = new TByteHashSet(exclude);
        for (Wildcard wc1 : alphabet.getAllWildcards()) {
            for (Wildcard wc2 : alphabet.getAllWildcards()) {
                if (!(!wc1.isBasic() && !excludeSet.contains(wc1.getCode()) || !wc2.isBasic() && !excludeSet.contains(wc2.getCode()))) continue;
                int sumScore = 0;
                for (int i = 0; i < wc1.basicSize(); ++i) {
                    for (int j = 0; j < wc2.basicSize(); ++j) {
                        sumScore += matrix[wc1.getMatchingCode(i) + wc2.getMatchingCode(j) * alSize];
                    }
                }
                matrix[wc1.getCode() + wc2.getCode() * alSize] = sumScore /= wc1.basicSize() * wc2.basicSize();
            }
        }
        return matrix;
    }
}

