/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.milaboratory.core.alignment.ScoringMatrixIO;
import com.milaboratory.core.alignment.ScoringUtils;
import com.milaboratory.core.sequence.Alphabet;
import java.io.Serializable;
import java.util.Arrays;

@JsonSerialize(using=ScoringMatrixIO.Serializer.class)
@JsonDeserialize(using=ScoringMatrixIO.Deserializer.class)
final class SubstitutionMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    final int[] data;

    public SubstitutionMatrix(int ... data) {
        int size;
        this.data = data;
        if (data.length != 2 && data.length != (size = (int)Math.sqrt(data.length)) * size) {
            throw new IllegalArgumentException("Wrong matrix size.");
        }
    }

    public int[] createSubstitutionMatrix(Alphabet<?> alphabet) {
        if (this.data.length == 2) {
            return ScoringUtils.getSymmetricMatrix(this.data[0], this.data[1], alphabet);
        }
        if (this.data.length != alphabet.size() * alphabet.size()) {
            throw new IllegalArgumentException();
        }
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubstitutionMatrix that = (SubstitutionMatrix)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

