/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.batch;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.Processor;
import cc.redberry.pipe.blocks.ParallelProcessor;
import com.milaboratory.core.alignment.batch.AlignmentHit;
import com.milaboratory.core.alignment.batch.AlignmentResult;
import com.milaboratory.core.alignment.batch.BatchAligner;
import com.milaboratory.core.alignment.batch.HasSequence;
import com.milaboratory.core.alignment.batch.PipedAlignmentResult;
import com.milaboratory.core.alignment.batch.PipedAlignmentResultImpl;
import com.milaboratory.core.alignment.batch.PipedBatchAligner;
import com.milaboratory.core.alignment.batch.SequenceExtractor;
import com.milaboratory.core.sequence.Sequence;

public abstract class AbstractBatchAligner<S extends Sequence<S>, H extends AlignmentHit<S, ?>>
implements BatchAligner<S, H>,
PipedBatchAligner<S, H> {
    protected volatile int threads = 1;

    @Override
    public abstract AlignmentResult<H> align(S var1);

    @Override
    public <Q> OutputPort<PipedAlignmentResult<H, Q>> align(OutputPort<Q> input, final SequenceExtractor<Q, S> extractor) {
        Processor proc = new Processor<Q, PipedAlignmentResult<H, Q>>(){

            public PipedAlignmentResult<H, Q> process(Q input) {
                Object seq = extractor.extract(input);
                AlignmentResult result = AbstractBatchAligner.this.align(seq);
                return new PipedAlignmentResultImpl(result.getHits(), input);
            }
        };
        return this.wrapPipe(proc, input);
    }

    @Override
    public <Q extends HasSequence<S>> OutputPort<PipedAlignmentResult<H, Q>> align(OutputPort<Q> input) {
        Processor proc = new Processor<Q, PipedAlignmentResult<H, Q>>(){

            public PipedAlignmentResult<H, Q> process(Q input) {
                AlignmentResult result = AbstractBatchAligner.this.align(input.getSequence());
                return new PipedAlignmentResultImpl(result.getHits(), input);
            }
        };
        return this.wrapPipe(proc, input);
    }

    private <Q> OutputPort<PipedAlignmentResult<H, Q>> wrapPipe(Processor<Q, PipedAlignmentResult<H, Q>> proc, OutputPort<Q> input) {
        if (this.threads == 1) {
            return CUtils.wrap(input, proc);
        }
        int t = this.threads == 0 ? Runtime.getRuntime().availableProcessors() : this.threads;
        return new ParallelProcessor(input, proc, t);
    }
}

