/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.batch;

import com.milaboratory.core.alignment.Aligner;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.batch.AbstractBatchAligner;
import com.milaboratory.core.alignment.batch.AlignmentHit;
import com.milaboratory.core.alignment.batch.AlignmentHitImpl;
import com.milaboratory.core.alignment.batch.AlignmentResult;
import com.milaboratory.core.alignment.batch.AlignmentResultImpl;
import com.milaboratory.core.alignment.batch.BatchAlignerWithBase;
import com.milaboratory.core.alignment.batch.BatchAlignmentUtil;
import com.milaboratory.core.alignment.batch.SimpleBatchAlignerParameters;
import com.milaboratory.core.sequence.Sequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleBatchAligner<S extends Sequence<S>, P>
extends AbstractBatchAligner<S, AlignmentHit<S, P>>
implements BatchAlignerWithBase<S, P, AlignmentHit<S, P>> {
    final SimpleBatchAlignerParameters<S> parameters;
    final List<Record<S, P>> references = new ArrayList<Record<S, P>>();

    public SimpleBatchAligner(SimpleBatchAlignerParameters<S> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void addReference(S sequence, P payload) {
        this.references.add(new Record<S, P>(sequence, payload));
    }

    @Override
    public AlignmentResult<AlignmentHit<S, P>> align(S sequence, int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AlignmentResult<AlignmentHit<S, P>> align(S sequence) {
        if (this.references.isEmpty()) {
            return new AlignmentResultImpl<AlignmentHit<S, P>>();
        }
        ArrayList<AlignmentHit<S, P>> alignments = new ArrayList<AlignmentHit<S, P>>(this.references.size());
        for (Record<S, P> record : this.references) {
            alignments.add(this.alignSingle(record, sequence));
        }
        Collections.sort(alignments, BatchAlignmentUtil.ALIGNMENT_SCORE_HIT_COMPARATOR);
        float topScore = ((AlignmentHit)alignments.get(0)).getAlignment().getScore();
        float scoreThreshold = Math.max(topScore * this.parameters.getRelativeMinScore(), this.parameters.getAbsoluteMinScore());
        for (int i = 0; i < alignments.size(); ++i) {
            if (i != this.parameters.getMaxHits() && !(((AlignmentHit)alignments.get(i)).getAlignment().getScore() < scoreThreshold)) continue;
            return new AlignmentResultImpl<AlignmentHit<S, P>>(new ArrayList(alignments.subList(0, i)));
        }
        return new AlignmentResultImpl<AlignmentHit<S, P>>(alignments);
    }

    AlignmentHit<S, P> alignSingle(Record<S, P> record, S query) {
        Alignment<S> alignment = this.parameters.isGlobal() ? Aligner.alignGlobal(this.parameters.getScoring(), record.sequence, query) : Aligner.alignLocal(this.parameters.getScoring(), record.sequence, query);
        return new AlignmentHitImpl(alignment, record.payload);
    }

    private static class Record<S extends Sequence<S>, P> {
        final S sequence;
        final P payload;

        public Record(S sequence, P payload) {
            this.sequence = sequence;
            this.payload = payload;
        }

        public S getSequence() {
            return this.sequence;
        }

        public P getPayload() {
            return this.payload;
        }
    }
}

