/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.benchmark;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.Processor;
import com.milaboratory.core.alignment.AlignmentUtils;
import com.milaboratory.core.alignment.batch.AlignmentHit;
import com.milaboratory.core.alignment.batch.AlignmentResult;
import com.milaboratory.core.alignment.batch.BatchAlignerWithBaseParameters;
import com.milaboratory.core.alignment.batch.BatchAlignerWithBaseWithFilter;
import com.milaboratory.core.alignment.benchmark.BenchmarkInput;
import com.milaboratory.core.alignment.benchmark.BenchmarkResults;
import com.milaboratory.core.alignment.benchmark.KAlignerQuery;
import com.milaboratory.core.alignment.kaligner2.KAligner2Statistics;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.util.RandomUtil;
import java.util.Iterator;

public final class Benchmark<T extends BatchAlignerWithBaseParameters>
implements Processor<BenchmarkInput<T>, BenchmarkResults> {
    final long maxExecutionTime;
    final long maxNoHits;
    ExceptionListener exceptionListener;

    public Benchmark(long maxExecutionTime) {
        this(maxExecutionTime, Integer.MAX_VALUE);
    }

    public Benchmark(long maxExecutionTime, long maxNoHits) {
        this.maxExecutionTime = maxExecutionTime;
        this.maxNoHits = maxNoHits;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public BenchmarkResults process(BenchmarkInput input) {
        RandomUtil.reseedThreadLocal(input.challenge.seed);
        KAligner2Statistics stat = new KAligner2Statistics();
        BatchAlignerWithBaseWithFilter<NucleotideSequence, Integer, AlignmentHit<NucleotideSequence, Integer>> aligner = input.params.createAligner();
        NucleotideSequence[] db = input.challenge.getDB();
        for (int i = 0; i < db.length; ++i) {
            aligner.addReference(db[i], i);
        }
        long executionTime = 0L;
        int processedQueries = 0;
        int processedGoodQueries = 0;
        int falsePositives = 0;
        int mismatched = 0;
        int noHits = 0;
        int scoreError = 0;
        long start = System.nanoTime();
        block3: for (KAlignerQuery query : CUtils.it(input.challenge.queries())) {
            if (System.nanoTime() - start > this.maxExecutionTime || (long)noHits > this.maxNoHits) break;
            long seed = RandomUtil.reseedThreadLocal();
            try {
                AlignmentHit hit;
                long b = System.nanoTime();
                AlignmentResult result = aligner.align(query.query);
                executionTime += System.nanoTime() - b;
                ++processedQueries;
                if (query.isFalse()) {
                    if (!result.hasHits()) continue;
                    ++falsePositives;
                    continue;
                }
                ++processedGoodQueries;
                if (!result.hasHits()) {
                    ++noHits;
                    continue;
                }
                for (AlignmentHit hit2 : result.getHits()) {
                    if (query.query.getRange(hit2.getAlignment().getSequence2Range()).equals(AlignmentUtils.getAlignedSequence2Part(hit2.getAlignment()))) continue;
                    System.out.println("Expected:");
                    System.out.println(query.expectedAlignment.getAlignmentHelper());
                    System.out.println("Actual:");
                    System.out.println(hit2.getAlignment().getAlignmentHelper());
                    throw new RuntimeException("Wrong answer.");
                }
                float topScore = ((AlignmentHit)result.getHits().get(0)).getAlignment().getScore();
                Iterator i$ = result.getHits().iterator();
                while (i$.hasNext() && (hit = (AlignmentHit)i$.next()).getAlignment().getScore() == topScore) {
                    if (!hit.getRecordPayload().equals(query.targetId)) continue;
                    if (!((double)topScore < 0.95 * (double)query.expectedAlignment.getScore())) continue block3;
                    ++scoreError;
                    continue block3;
                }
                ++mismatched;
            }
            catch (Exception e) {
                if (this.exceptionListener != null) {
                    this.exceptionListener.onException(new ExceptionData(seed, e, db, query.query, input));
                    continue;
                }
                throw e;
            }
        }
        return new BenchmarkResults(input, stat, executionTime, processedQueries, processedGoodQueries, falsePositives, mismatched, noHits, scoreError);
    }

    public static final class ExceptionData {
        public final long seed;
        public final Throwable exception;
        public final NucleotideSequence[] db;
        public final NucleotideSequence query;
        public final BenchmarkInput input;

        public ExceptionData(long seed, Throwable exception, NucleotideSequence[] db, NucleotideSequence query, BenchmarkInput input) {
            this.seed = seed;
            this.exception = exception;
            this.db = db;
            this.query = query;
            this.input = input;
        }
    }

    public static interface ExceptionListener {
        public void onException(ExceptionData var1);
    }
}

