/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.benchmark;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.milaboratory.core.alignment.benchmark.BenchmarkInput;
import com.milaboratory.core.alignment.kaligner2.KAligner2Statistics;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class BenchmarkResults {
    @JsonIgnore
    public final BenchmarkInput input;
    public final KAligner2Statistics stat;
    public final long executionTime;
    public final int processedQueries;
    public final int processedGoodQueries;
    public final int falsePositives;
    public final int mismatched;
    public final int noHits;
    public final int scoreError;

    public BenchmarkResults(BenchmarkInput input, KAligner2Statistics stat, long executionTime, int processedQueries, int processedGoodQueries, int falsePositives, int mismatched, int noHits, int scoreError) {
        this.input = input;
        this.stat = stat;
        this.executionTime = executionTime;
        this.processedQueries = processedQueries;
        this.processedGoodQueries = processedGoodQueries;
        this.falsePositives = falsePositives;
        this.mismatched = mismatched;
        this.noHits = noHits;
        this.scoreError = scoreError;
    }

    public BenchmarkInput getInput() {
        return this.input;
    }

    public KAligner2Statistics getStat() {
        return this.stat;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public int getProcessedGoodQueries() {
        return this.processedGoodQueries;
    }

    public int getProcessedQueries() {
        return this.processedQueries;
    }

    public int getMismatched() {
        return this.mismatched;
    }

    public int getNoHits() {
        return this.noHits;
    }

    public double getNoHitsFraction() {
        return 1.0 * (double)this.noHits / (double)this.processedGoodQueries;
    }

    public double getMismatchedFraction() {
        return 1.0 * (double)this.mismatched / (double)this.processedGoodQueries;
    }

    public double getBadFraction() {
        return 1.0 * (double)(this.noHits + this.mismatched) / (double)this.processedGoodQueries;
    }

    public double getFalsePositiveFraction() {
        return 1.0 * (double)this.falsePositives / (double)(this.processedQueries - this.processedGoodQueries);
    }

    public double getScoreErrorFraction() {
        return 1.0 * (double)this.scoreError / (double)(this.processedGoodQueries - this.noHits - this.mismatched);
    }

    public long getAverageTiming() {
        return this.executionTime / (long)this.processedQueries;
    }
}

