/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.benchmark;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.mutations.generator.NucleotideMutationModel;
import com.milaboratory.core.sequence.NucleotideSequence;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public final class ChallengeParameters {
    final int dbSize;
    final int dbMinSeqLength;
    final int dbMaxSeqLength;
    final int queryCount;
    final int falseCount;
    final int minClusters;
    final int maxClusters;
    final int minClusterLength;
    final int maxClusterLength;
    final int minIndelLength;
    final int maxIndelLength;
    final double insertionProbability;
    final double deletionProbability;
    final double boundaryInsertProbability;
    final NucleotideMutationModel mutationModel;
    final int minAlignmentScoring;
    final int maxAlignmentScoring;
    final AffineGapAlignmentScoring<NucleotideSequence> scoring;

    public ChallengeParameters(int dbSize, int dbMinSeqLength, int dbMaxSeqLength, int queryCount, int falseCount, int minClusters, int maxClusters, int minClusterLength, int maxClusterLength, int minIndelLength, int maxIndelLength, double insertionProbability, double deletionProbability, double boundaryInsertProbability, NucleotideMutationModel mutationModel, int minAlignmentScoring, int maxAlignmentScoring, AffineGapAlignmentScoring<NucleotideSequence> scoring) {
        this.dbSize = dbSize;
        this.dbMinSeqLength = dbMinSeqLength;
        this.dbMaxSeqLength = dbMaxSeqLength;
        this.queryCount = queryCount;
        this.falseCount = falseCount;
        this.minClusters = minClusters;
        this.maxClusters = maxClusters;
        this.minClusterLength = minClusterLength;
        this.maxClusterLength = maxClusterLength;
        this.minIndelLength = minIndelLength;
        this.maxIndelLength = maxIndelLength;
        this.insertionProbability = insertionProbability;
        this.deletionProbability = deletionProbability;
        this.boundaryInsertProbability = boundaryInsertProbability;
        this.mutationModel = mutationModel;
        this.minAlignmentScoring = minAlignmentScoring;
        this.maxAlignmentScoring = maxAlignmentScoring;
        this.scoring = scoring;
    }

    public ChallengeParameters setQueryCount(int newCount) {
        return new ChallengeParameters(this.dbSize, this.dbMinSeqLength, this.dbMaxSeqLength, newCount, this.falseCount, this.minClusters, this.maxClusters, this.minClusterLength, this.maxClusterLength, this.minIndelLength, this.maxIndelLength, this.insertionProbability, this.deletionProbability, this.boundaryInsertProbability, this.mutationModel, this.minAlignmentScoring, this.maxAlignmentScoring, this.scoring);
    }
}

