/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.benchmark;

import cc.redberry.pipe.OutputPort;
import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.alignment.Aligner;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.AlignmentUtils;
import com.milaboratory.core.alignment.benchmark.Challenge;
import com.milaboratory.core.alignment.benchmark.ChallengeParameters;
import com.milaboratory.core.alignment.benchmark.KAlignerQuery;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.mutations.generator.GenericNucleotideMutationModel;
import com.milaboratory.core.mutations.generator.MutationsGenerator;
import com.milaboratory.core.mutations.generator.NucleotideMutationModel;
import com.milaboratory.core.mutations.generator.SubstitutionModels;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public final class ChallengeProvider
implements OutputPort<Challenge> {
    public static int MAX_RERUNS = 200;
    final ChallengeParameters parameters;
    final RandomGenerator gen;
    final RandomDataGenerator rdg;
    private static final double deletionProbability = 5.22E-4;
    private static final double insertionProbability = 1.98E-4;

    public ChallengeProvider(ChallengeParameters parameters, long seed) {
        this.parameters = parameters;
        this.gen = new Well19937c(seed);
        this.rdg = new RandomDataGenerator(this.gen);
    }

    public Challenge take() {
        NucleotideSequence[] db = ChallengeProvider.generateDB(this.rdg, this.parameters);
        long seed = this.gen.nextLong();
        Well19937c rg = new Well19937c(seed);
        RandomDataGenerator generator = new RandomDataGenerator((RandomGenerator)rg);
        AtomicInteger counter = new AtomicInteger();
        ArrayList<KAlignerQuery> queries = new ArrayList<KAlignerQuery>();
        int consequentReruns = 0;
        for (int n = 0; n < this.parameters.queryCount; ++n) {
            Alignment<NucleotideSequence> expectedAlignment;
            int i;
            MutationsBuilder<NucleotideSequence> totalMutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
            NucleotideMutationModel model = this.parameters.mutationModel.clone();
            model.reseed(generator.getRandomGenerator().nextLong());
            int targetId = generator.nextInt(0, db.length - 1);
            NucleotideSequence target = db[targetId];
            SequenceBuilder queryBuilder = NucleotideSequence.ALPHABET.createBuilder();
            if (generator.nextUniform(0.0, 1.0) < this.parameters.boundaryInsertProbability) {
                queryBuilder.append(ChallengeProvider.randomSequence(NucleotideSequence.ALPHABET, generator, this.parameters.minIndelLength, this.parameters.maxIndelLength, true));
            }
            ArrayList<Range> tRanges = new ArrayList<Range>();
            ArrayList<Range> qRanges = new ArrayList<Range>();
            ArrayList<Mutations<NucleotideSequence>> muts = new ArrayList<Mutations<NucleotideSequence>>();
            int tOffset = generator.nextInt(0, this.parameters.maxIndelLength);
            int qOffset = queryBuilder.size();
            int n2 = i = this.parameters.minClusters == this.parameters.maxClusters ? this.parameters.minClusters : generator.nextInt(this.parameters.minClusters, this.parameters.maxClusters);
            while (i > 0) {
                Mutations<NucleotideSequence> m;
                Range r;
                if (tRanges.isEmpty()) {
                    if ((r = new Range(tOffset, tOffset += generator.nextInt(this.parameters.minClusterLength, this.parameters.maxClusterLength))).getTo() > target.size()) break;
                    tRanges.add(r);
                    m = MutationsGenerator.generateMutations(target, model, r);
                    muts.add(m);
                    NucleotideSequence queryPart = m.move(-r.getFrom()).mutate(target.getRange(r));
                    qRanges.add(new Range(qOffset, qOffset += queryPart.size()));
                    queryBuilder.append(queryPart);
                    totalMutations.append(m);
                } else {
                    int previousOffset;
                    NucleotideSequence ins;
                    double d;
                    MutationsBuilder<NucleotideSequence> tempMutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
                    double v = generator.nextUniform(0.0, 1.0);
                    if (d < this.parameters.insertionProbability) {
                        ins = ChallengeProvider.randomSequence(NucleotideSequence.ALPHABET, generator, this.parameters.minIndelLength, this.parameters.maxIndelLength, true);
                        tempMutations.appendInsertion(tOffset, ins);
                    } else if (v < this.parameters.insertionProbability + this.parameters.deletionProbability) {
                        previousOffset = tOffset;
                        ins = NucleotideSequence.EMPTY;
                        if ((tOffset += generator.nextInt(this.parameters.minIndelLength, this.parameters.maxIndelLength)) <= target.size()) {
                            tempMutations.appendDeletion(previousOffset, tOffset - previousOffset, target);
                        }
                    } else {
                        ins = ChallengeProvider.randomSequence(NucleotideSequence.ALPHABET, generator, this.parameters.minIndelLength, this.parameters.maxIndelLength, true);
                        previousOffset = tOffset;
                        Alignment<NucleotideSequence> result = Aligner.alignGlobalAffine(this.parameters.scoring, target.getRange(previousOffset, tOffset += generator.nextInt(this.parameters.minIndelLength, this.parameters.maxIndelLength)), ins);
                        if (tOffset <= target.size()) {
                            tempMutations.append(result.getAbsoluteMutations().move(previousOffset));
                        }
                    }
                    r = new Range(tOffset, tOffset += generator.nextInt(this.parameters.minClusterLength, this.parameters.maxClusterLength));
                    if (r.getTo() > target.size()) break;
                    totalMutations.append(tempMutations);
                    tRanges.add(r);
                    m = MutationsGenerator.generateMutations(target, model, r);
                    muts.add(m);
                    qOffset = qOffset + ins.size();
                    qRanges.add(new Range(qOffset, qOffset += r.length() + m.getLengthDelta()));
                    queryBuilder.append(ins).append(m.move(-r.getFrom()).mutate(target.getRange(r)));
                    totalMutations.append(m);
                }
                --i;
            }
            if (generator.nextUniform(0.0, 1.0) < this.parameters.boundaryInsertProbability) {
                queryBuilder.append(ChallengeProvider.randomSequence(NucleotideSequence.ALPHABET, generator, this.parameters.minIndelLength, this.parameters.maxIndelLength, true));
            }
            if ((expectedAlignment = new Alignment<NucleotideSequence>(target, totalMutations.createAndDestroy(), new Range(((Range)tRanges.get(0)).getFrom(), ((Range)tRanges.get(tRanges.size() - 1)).getTo()), new Range(((Range)qRanges.get(0)).getFrom(), ((Range)qRanges.get(qRanges.size() - 1)).getTo()), this.parameters.scoring)).getScore() < (float)this.parameters.minAlignmentScoring || expectedAlignment.getScore() > (float)this.parameters.maxAlignmentScoring) {
                --n;
                if (++consequentReruns <= MAX_RERUNS) continue;
                throw new RuntimeException("Too many reruns.");
            }
            consequentReruns = 0;
            NucleotideSequence q = (NucleotideSequence)queryBuilder.createAndDestroy();
            assert (AlignmentUtils.getAlignedSequence2Part(expectedAlignment).equals(q.getRange(expectedAlignment.getSequence2Range())));
            KAlignerQuery query = new KAlignerQuery(targetId, qRanges, tRanges, muts, q, expectedAlignment);
            queries.add(query);
        }
        for (int i = 0; i < this.parameters.falseCount; ++i) {
            queries.add(new KAlignerQuery(ChallengeProvider.randomSequence(NucleotideSequence.ALPHABET, generator, this.parameters.minClusters * (this.parameters.minClusterLength + this.parameters.minIndelLength) + this.parameters.minIndelLength, this.parameters.maxClusters * (this.parameters.maxClusterLength + this.parameters.maxIndelLength) + this.parameters.maxIndelLength, true)));
        }
        Collections.shuffle(queries, new Random(this.gen.nextLong()));
        return new Challenge(db, queries, this.parameters, seed);
    }

    public static NucleotideSequence[] generateDB(RandomDataGenerator generator, ChallengeParameters params) {
        NucleotideSequence[] db = new NucleotideSequence[params.dbSize];
        for (int i = 0; i < params.dbSize; ++i) {
            db[i] = ChallengeProvider.randomSequence(NucleotideSequence.ALPHABET, generator, params.dbMinSeqLength, params.dbMaxSeqLength, true);
        }
        return db;
    }

    public static <S extends Sequence<S>> S randomSequence(Alphabet<S> alphabet, RandomDataGenerator r, int minLength, int maxLength, boolean basicLettersOnly) {
        return ChallengeProvider.randomSequence(alphabet, r.getRandomGenerator(), minLength, maxLength, basicLettersOnly);
    }

    public static <S extends Sequence<S>> S randomSequence(Alphabet<S> alphabet, RandomGenerator r, int minLength, int maxLength, boolean basicLettersOnly) {
        int length = minLength == maxLength ? minLength : minLength + r.nextInt(maxLength - minLength + 1);
        SequenceBuilder<byte> builder = alphabet.createBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((byte)r.nextInt(basicLettersOnly ? alphabet.basicSize() : alphabet.size()));
        }
        return builder.createAndDestroy();
    }

    public static ChallengeParameters getParams1NoGap(AffineGapAlignmentScoring<NucleotideSequence> scoring, int minAlignmentScoring, int maxAlignmentScoring, double multiplier) {
        return new ChallengeParameters(100, 100, 500, 100000, 1000000, 1, 4, 15, 50, 3, 30, 0.45, 0.45, 0.5, new GenericNucleotideMutationModel(SubstitutionModels.getEmpiricalNucleotideSubstitutionModel(), 0.0, 0.0).multiplyProbabilities(multiplier), minAlignmentScoring, maxAlignmentScoring, scoring);
    }

    public static ChallengeParameters getParamsOneCluster(AffineGapAlignmentScoring<NucleotideSequence> scoring, int minAlignmentScoring, int maxAlignmentScoring, double multiplier) {
        return new ChallengeParameters(100, 350, 500, 1000000, 1000000, 1, 1, 35, 80, 30, 100, 0.45, 0.45, 0.5, new GenericNucleotideMutationModel(SubstitutionModels.getEmpiricalNucleotideSubstitutionModel(), 5.22E-4, 1.98E-4).multiplyProbabilities(multiplier), minAlignmentScoring, maxAlignmentScoring, scoring);
    }

    public static ChallengeParameters getParamsTwoClusters(AffineGapAlignmentScoring<NucleotideSequence> scoring, int minAlignmentScoring, int maxAlignmentScoring, double multiplier) {
        return new ChallengeParameters(100, 350, 500, 1000000, 1000000, 2, 2, 35, 100, 30, 80, 0.45, 0.45, 0.5, new GenericNucleotideMutationModel(SubstitutionModels.getEmpiricalNucleotideSubstitutionModel(), 5.22E-4, 1.98E-4).multiplyProbabilities(multiplier), minAlignmentScoring, maxAlignmentScoring, scoring);
    }
}

