/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.blast;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.Processor;
import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.batch.HasSequence;
import com.milaboratory.core.alignment.batch.PipedAlignmentResult;
import com.milaboratory.core.alignment.batch.PipedAlignmentResultImpl;
import com.milaboratory.core.alignment.batch.PipedBatchAlignerWithBase;
import com.milaboratory.core.alignment.batch.SequenceExtractor;
import com.milaboratory.core.alignment.blast.BlastAlignerExt;
import com.milaboratory.core.alignment.blast.BlastAlignerParameters;
import com.milaboratory.core.alignment.blast.BlastDB;
import com.milaboratory.core.alignment.blast.BlastDBBuilder;
import com.milaboratory.core.alignment.blast.BlastHit;
import com.milaboratory.core.alignment.blast.BlastHitExt;
import com.milaboratory.core.sequence.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BlastAlignerAbstract<S extends Sequence<S>, P, H extends BlastHit<S, P>>
implements PipedBatchAlignerWithBase<S, P, H> {
    private final List<S> sequenceList = new ArrayList<S>();
    private final Map<String, S> sequences = new HashMap<String, S>();
    private final Map<String, P> payloads = new HashMap<String, P>();
    private final BlastAlignerParameters parameters;
    private volatile BlastDB db = null;
    private volatile BlastAlignerExt<S> aligner = null;
    private volatile int processCount = 1;

    public BlastAlignerAbstract() {
        this(null);
    }

    public BlastAlignerAbstract(BlastAlignerParameters parameters) {
        this.parameters = parameters;
    }

    public void setConcurrentBlastProcessCount(int processCount) {
        this.processCount = processCount;
    }

    @Override
    public <Q> OutputPort<? extends PipedAlignmentResult<H, Q>> align(OutputPort<Q> input, SequenceExtractor<Q, S> extractor) {
        this.ensureInit();
        OutputPort iResults = this.aligner.align(input, extractor);
        return CUtils.wrap(iResults, new ResultsConverter());
    }

    @Override
    public <Q extends HasSequence<S>> OutputPort<PipedAlignmentResult<H, Q>> align(OutputPort<Q> input) {
        this.ensureInit();
        OutputPort iResults = this.aligner.align(input);
        return CUtils.wrap(iResults, new ResultsConverter());
    }

    private synchronized void ensureInit() {
        if (this.db != null) {
            return;
        }
        this.db = BlastDBBuilder.build(new ArrayList<S>(this.sequenceList));
        this.aligner = new BlastAlignerExt(this.db, this.parameters);
        this.aligner.setConcurrentBlastProcessCount(this.processCount);
    }

    @Override
    public synchronized void addReference(S sequence, P payload) {
        if (this.db != null) {
            throw new IllegalStateException("Aligner is already in use, can't add sequence to database.");
        }
        String key = BlastDBBuilder.getIdKey(this.sequenceList.size());
        this.sequenceList.add(sequence);
        this.payloads.put(key, payload);
        this.sequences.put(key, sequence);
    }

    protected abstract H createHit(Alignment<S> var1, P var2, BlastHit<S, ?> var3);

    private class ResultsConverter<Q>
    implements Processor<PipedAlignmentResult<BlastHitExt<S>, Q>, PipedAlignmentResult<H, Q>> {
        private ResultsConverter() {
        }

        public PipedAlignmentResult<H, Q> process(PipedAlignmentResult<BlastHitExt<S>, Q> input) {
            ArrayList hits = new ArrayList(input.getHits().size());
            for (BlastHitExt iHit : input.getHits()) {
                String id = iHit.getSubjectId();
                Sequence sequence = (Sequence)BlastAlignerAbstract.this.sequences.get(id);
                Object payload = BlastAlignerAbstract.this.payloads.get(id);
                Alignment<Object> alignment = iHit.getAlignment();
                Range subjectRange = iHit.getSubjectRange();
                alignment = new Alignment<Sequence>(sequence, alignment.getAbsoluteMutations().move(subjectRange.getLower()), subjectRange, alignment.getSequence2Range(), alignment.getScore());
                hits.add(BlastAlignerAbstract.this.createHit(alignment, payload, iHit));
            }
            return new PipedAlignmentResultImpl(hits, input.getQuery());
        }
    }
}

