/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.blast;

import cc.redberry.pipe.InputPort;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.OutputPortCloseable;
import cc.redberry.pipe.blocks.Buffer;
import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.batch.BatchAlignmentUtil;
import com.milaboratory.core.alignment.batch.HasSequence;
import com.milaboratory.core.alignment.batch.PipedAlignmentResult;
import com.milaboratory.core.alignment.batch.PipedAlignmentResultImpl;
import com.milaboratory.core.alignment.batch.PipedBatchAligner;
import com.milaboratory.core.alignment.batch.SequenceExtractor;
import com.milaboratory.core.alignment.blast.Blast;
import com.milaboratory.core.alignment.blast.BlastAlignerParameters;
import com.milaboratory.core.alignment.blast.BlastDB;
import com.milaboratory.core.alignment.blast.BlastHitExt;
import com.milaboratory.core.io.sequence.fasta.FastaWriter;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsUtil;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BlastAlignerExtAbstract<S extends Sequence<S>, H extends BlastHitExt<S>>
implements PipedBatchAligner<S, H> {
    private static final String OUTFMT = "7 btop sstart send qstart qend score bitscore evalue stitle sseqid sseq";
    private static final String QUERY_ID_PREFIX = "Q";
    final BlastDB database;
    final Alphabet<S> alphabet;
    final BlastAlignerParameters parameters;
    volatile int processCount = 1;

    public BlastAlignerExtAbstract(BlastDB database) {
        this(database, null);
    }

    public BlastAlignerExtAbstract(BlastDB database, BlastAlignerParameters parameters) {
        this.database = database;
        this.alphabet = database.getAlphabet();
        this.parameters = parameters == null ? new BlastAlignerParameters() : parameters;
        this.parameters.chechAlphabet(this.alphabet);
    }

    public void setConcurrentBlastProcessCount(int processCount) {
        this.processCount = processCount;
    }

    @Override
    public <Q> OutputPort<PipedAlignmentResult<H, Q>> align(OutputPort<Q> input, SequenceExtractor<Q, S> extractor) {
        return new BlastWorker<Q>(input, extractor);
    }

    @Override
    public <Q extends HasSequence<S>> OutputPort<PipedAlignmentResult<H, Q>> align(OutputPort<Q> input) {
        return new BlastWorker<Q>(input, BatchAlignmentUtil.DUMMY_EXTRACTOR);
    }

    protected abstract H createHit(Alignment<S> var1, double var2, double var4, double var6, Range var8, String var9, String var10);

    private class BlastSequencePusher<Q>
    extends Thread {
        final AtomicLong counter = new AtomicLong();
        final OutputPort<Q> source;
        final SequenceExtractor<Q, S> sequenceExtractor;
        final ConcurrentMap<String, Q> queryMapping;
        final FastaWriter<S> writer;

        public BlastSequencePusher(OutputPort<Q> source, SequenceExtractor<Q, S> sequenceExtractor, ConcurrentMap<String, Q> queryMapping, OutputStream stream) {
            this.source = source;
            this.sequenceExtractor = sequenceExtractor;
            this.queryMapping = queryMapping;
            this.writer = new FastaWriter(stream, 75);
        }

        @Override
        public void run() {
            Object query;
            while ((query = this.source.take()) != null) {
                Object sequence = this.sequenceExtractor.extract(query);
                String name = BlastAlignerExtAbstract.QUERY_ID_PREFIX + this.counter.incrementAndGet();
                this.queryMapping.put(name, query);
                this.writer.write(name, sequence);
            }
            this.writer.close();
        }
    }

    private class BlastResultsFetcher<Q>
    extends Thread {
        final InputPort<PipedAlignmentResult<H, Q>> resultsInputPort;
        final BufferedReader reader;
        final ConcurrentMap<String, Q> queryMapping;

        public BlastResultsFetcher(InputPort<PipedAlignmentResult<H, Q>> resultsInputPort, ConcurrentMap<String, Q> queryMapping, InputStream stream) {
            this.resultsInputPort = resultsInputPort;
            this.reader = new BufferedReader(new InputStreamReader(stream));
            this.queryMapping = queryMapping;
        }

        @Override
        public void run() {
            try {
                String line;
                int num = -1;
                Object query = null;
                ArrayList hits = null;
                while ((line = this.reader.readLine()) != null) {
                    if (line.contains("hits found")) {
                        num = Integer.parseInt(line.replace("#", "").replace("hits found", "").trim());
                        hits = new ArrayList(num);
                    } else if (line.contains("Query")) {
                        String qid = line.replace("# Query: ", "").trim();
                        query = this.queryMapping.remove(qid);
                        if (query == null) {
                            throw new RuntimeException();
                        }
                    } else if (!line.startsWith("#")) {
                        if (hits == null) {
                            throw new RuntimeException();
                        }
                        hits.add(this.parseLine(line));
                    }
                    if (hits == null || hits.size() != num) continue;
                    if (query == null) {
                        throw new RuntimeException();
                    }
                    this.resultsInputPort.put(new PipedAlignmentResultImpl(hits, query));
                    query = null;
                    hits = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.resultsInputPort.put(null);
            }
        }

        private H parseLine(String line) {
            String[] fields = line.split("\t");
            int i = 0;
            String btop = fields[i++];
            String sstart = fields[i++];
            String send = fields[i++];
            String qstart = fields[i++];
            String qend = fields[i++];
            String score = fields[i++];
            String bitscore = fields[i++];
            String evalue = fields[i++];
            String stitle = fields[i++];
            String sseqid = fields[i++];
            String sseq = fields[i++].replace("-", "");
            Mutations mutations = new Mutations(BlastAlignerExtAbstract.this.alphabet, MutationsUtil.btopDecode(btop, BlastAlignerExtAbstract.this.alphabet));
            Alignment alignment = new Alignment(BlastAlignerExtAbstract.this.alphabet.parse(sseq), mutations, new Range(0, sseq.length()), new Range(Integer.parseInt(qstart) - 1, Integer.parseInt(qend)), Float.parseFloat(bitscore));
            Range sRange = new Range(Integer.parseInt(sstart) - 1, Integer.parseInt(send));
            return BlastAlignerExtAbstract.this.createHit(alignment, Double.parseDouble(score), Double.parseDouble(bitscore), Double.parseDouble(evalue), sRange, sseqid, stitle);
        }
    }

    private class BlastWorkerSingle<Q> {
        final ConcurrentMap<String, Q> queryMapping = new ConcurrentHashMap<String, Q>();
        final Process process;
        final BlastSequencePusher<Q> pusher;
        final BlastResultsFetcher<Q> fetcher;

        public BlastWorkerSingle(OutputPort<Q> source, SequenceExtractor<Q, S> sequenceExtractor, InputPort<PipedAlignmentResult<H, Q>> resultsPort) {
            try {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.addAll(Arrays.asList(Blast.toBlastCommand(BlastAlignerExtAbstract.this.database.getAlphabet()), "-db", BlastAlignerExtAbstract.this.database.getName(), "-outfmt", BlastAlignerExtAbstract.OUTFMT));
                BlastAlignerExtAbstract.this.parameters.addArgumentsTo(cmd);
                ProcessBuilder processBuilder = Blast.getProcessBuilder(cmd);
                processBuilder.redirectErrorStream(false);
                BlastAlignerExtAbstract.this.parameters.addEnvVariablesTo(processBuilder);
                this.process = processBuilder.start();
                this.pusher = new BlastSequencePusher<Q>(source, sequenceExtractor, this.queryMapping, this.process.getOutputStream());
                this.fetcher = new BlastResultsFetcher<Q>(resultsPort, this.queryMapping, this.process.getInputStream());
                this.pusher.start();
                this.fetcher.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            if (this.pusher.source instanceof OutputPortCloseable) {
                ((OutputPortCloseable)this.pusher.source).close();
            }
        }
    }

    private class BlastWorker<Q>
    implements OutputPortCloseable<PipedAlignmentResult<H, Q>> {
        final Buffer<PipedAlignmentResult<H, Q>> resultsBuffer;
        final BlastWorkerSingle<Q>[] workers;

        public BlastWorker(OutputPort<Q> source, SequenceExtractor<Q, S> sequenceExtractor) {
            int pc = BlastAlignerExtAbstract.this.processCount;
            this.resultsBuffer = new Buffer(64 * pc);
            this.workers = new BlastWorkerSingle[pc];
            for (int i = 0; i < pc; ++i) {
                this.workers[i] = new BlastWorkerSingle<Q>(source, sequenceExtractor, this.resultsBuffer.createInputPort());
            }
        }

        public void close() {
            for (BlastWorkerSingle<Q> worker : this.workers) {
                worker.close();
            }
        }

        public PipedAlignmentResult<H, Q> take() {
            return (PipedAlignmentResult)this.resultsBuffer.take();
        }
    }
}

