/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.blast;

import com.milaboratory.core.alignment.blast.BlastTask;
import com.milaboratory.core.sequence.Alphabet;
import java.util.Arrays;
import java.util.List;

public class BlastAlignerParameters {
    private int batchSize = Integer.MIN_VALUE;
    private BlastTask blastTask = null;
    private double eValue = Double.NaN;
    private int wordSize = Integer.MIN_VALUE;
    private int gapOpen = Integer.MIN_VALUE;
    private int gapExtend = Integer.MIN_VALUE;
    private int penalty = Integer.MIN_VALUE;
    private int reward = Integer.MIN_VALUE;
    private int numAlignments = Integer.MIN_VALUE;
    private int numThreads = Integer.MIN_VALUE;
    private String matrix = null;

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumAlignments() {
        return this.numAlignments;
    }

    public void setNumAlignments(int numAlignments) {
        this.numAlignments = numAlignments;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public BlastTask getBlastTask() {
        return this.blastTask;
    }

    public void setBlastTask(BlastTask blastTask) {
        this.blastTask = blastTask;
    }

    public double getEValue() {
        return this.eValue;
    }

    public void setEValue(double eValue) {
        this.eValue = eValue;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public void setWordSize(int wordSize) {
        this.wordSize = wordSize;
    }

    public int getGapOpen() {
        return this.gapOpen;
    }

    public void setGapOpen(int gapOpen) {
        this.gapOpen = gapOpen;
    }

    public int getGapExtend() {
        return this.gapExtend;
    }

    public void setGapExtend(int gapExtend) {
        this.gapExtend = gapExtend;
    }

    public String getMatrix() {
        return this.matrix;
    }

    public void setMatrix(String matrix) {
        this.matrix = matrix;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void setPenalty(int penalty) {
        this.penalty = penalty;
    }

    public int getReward() {
        return this.reward;
    }

    public void setReward(int reward) {
        this.reward = reward;
    }

    public void chechAlphabet(Alphabet<?> alphabet) {
        if (this.blastTask != null && alphabet != this.blastTask.alphabet) {
            throw new IllegalArgumentException("The \"" + this.blastTask.value + "\" is not compatible with alphabet " + alphabet);
        }
    }

    public void addEnvVariablesTo(ProcessBuilder processBuilder) {
        if (this.batchSize != Integer.MIN_VALUE) {
            processBuilder.environment().put("BATCH_SIZE", Integer.toString(this.batchSize));
        }
    }

    public void addArgumentsTo(List<String> cmd) {
        if (this.blastTask != null) {
            cmd.addAll(Arrays.asList("-task", this.blastTask.value));
        }
        if (!Double.isNaN(this.eValue)) {
            cmd.addAll(Arrays.asList("-evalue", Double.toString(this.eValue)));
        }
        if (this.wordSize != Integer.MIN_VALUE) {
            cmd.addAll(Arrays.asList("-word_size", Integer.toString(this.wordSize)));
        }
        if (this.gapOpen != Integer.MIN_VALUE) {
            cmd.addAll(Arrays.asList("-gapopen", Integer.toString(this.gapOpen)));
        }
        if (this.gapExtend != Integer.MIN_VALUE) {
            cmd.addAll(Arrays.asList("-gapextend", Integer.toString(this.gapExtend)));
        }
        if (this.penalty != Integer.MIN_VALUE) {
            cmd.addAll(Arrays.asList("-penalty", Integer.toString(this.penalty)));
        }
        if (this.reward != Integer.MIN_VALUE) {
            cmd.addAll(Arrays.asList("-reward", Integer.toString(this.reward)));
        }
        if (this.numAlignments != Integer.MIN_VALUE) {
            cmd.addAll(Arrays.asList("-num_alignments", Integer.toString(this.numAlignments)));
        }
        if (this.numThreads != Integer.MIN_VALUE) {
            cmd.addAll(Arrays.asList("-num_threads", Integer.toString(this.numThreads)));
        }
        if (this.matrix != null) {
            cmd.addAll(Arrays.asList("-matrix", this.matrix));
        }
    }
}

