/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.blast;

import com.milaboratory.core.alignment.blast.Blast;
import com.milaboratory.core.io.sequence.fasta.FastaReader;
import com.milaboratory.core.io.sequence.fasta.FastaRecord;
import com.milaboratory.core.sequence.AbstractArrayAlphabet;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.AminoAcidSequence;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class BlastDB<S extends Sequence<S>> {
    private final String name;
    private final String title;
    private final long recordsCount;
    private final long lettersCount;
    private final Alphabet<S> alphabet;
    private final List<String> volumes;
    private final boolean temp;
    private static final Map<Alphabet<?>, String[]> extensionsToDelete = new HashMap();
    private static final Pattern[] linePatterns;

    public BlastDB(String name, String title, long recordsCount, long lettersCount, Alphabet<S> alphabet, List<String> volumes, boolean temp) {
        this.name = name;
        this.title = title;
        this.recordsCount = recordsCount;
        this.lettersCount = lettersCount;
        this.alphabet = alphabet;
        this.volumes = volumes;
        this.temp = temp;
    }

    public S retriveSequenceById(String id) {
        try {
            Process proc = Blast.getProcessBuilder("blastdbcmd", "-db", this.name, "-entry", id).start();
            FastaReader<S> reader = new FastaReader<S>(proc.getInputStream(), this.getAlphabet());
            Object record = reader.take();
            while (reader.take() != null) {
            }
            proc.waitFor();
            if (record == null) {
                return null;
            }
            return ((FastaRecord)record).getSequence();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Alphabet<S> getAlphabet() {
        return this.alphabet;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public long getRecordsCount() {
        return this.recordsCount;
    }

    public long getLettersCount() {
        return this.lettersCount;
    }

    public static Pattern[] getLinePatterns() {
        return linePatterns;
    }

    protected void finalize() throws Throwable {
        if (this.temp) {
            String path = this.volumes.get(0);
            for (String ext : extensionsToDelete.get(this.alphabet)) {
                Path p = Paths.get(path + ext, new String[0]);
                if (!Files.exists(p, new LinkOption[0])) continue;
                Files.delete(p);
            }
        }
        super.finalize();
    }

    public static <S extends Sequence<S>> BlastDB<S> get(String name) {
        return BlastDB.get(name, false);
    }

    static <S extends Sequence<S>> BlastDB<S> get(String name, boolean temp) {
        try {
            boolean p;
            ProcessBuilder processBuilder = Blast.getProcessBuilder("blastdbcmd", "-db", name, "-info");
            Process proc = processBuilder.start();
            List lines = IOUtils.readLines((InputStream)proc.getInputStream(), (Charset)Charset.forName("US-ASCII"));
            String error = IOUtils.toString((InputStream)proc.getErrorStream(), (Charset)Charset.forName("US-ASCII"));
            if (proc.waitFor() != 0) {
                throw new RuntimeException("Error: " + error);
            }
            ArrayList<Matcher> matchers = new ArrayList<Matcher>();
            for (int i = 0; i < linePatterns.length; ++i) {
                if (linePatterns[i] == null) continue;
                String line = (String)lines.get(i);
                Matcher m = linePatterns[i].matcher(line);
                if (!m.matches()) {
                    throw new RuntimeException("Line " + i + " don't matches pattern " + linePatterns[i].pattern() + ". Line: " + line);
                }
                matchers.add(m);
            }
            String dbTitle = ((Matcher)matchers.get(0)).group(1);
            long records = Long.parseLong(((Matcher)matchers.get(1)).group(1).replace(",", ""));
            long letters = Long.parseLong(((Matcher)matchers.get(1)).group(2).replace(",", ""));
            ArrayList<String> volumes = new ArrayList<String>(lines.subList(6, lines.size()));
            for (int i = 0; i < volumes.size(); ++i) {
                volumes.set(i, ((String)volumes.get(i)).trim());
            }
            String path = (String)volumes.get(0);
            boolean n = Files.exists(Paths.get(path + ".nsq", new String[0]), new LinkOption[0]);
            if (!n ^ (p = Files.exists(Paths.get(path + ".psq", new String[0]), new LinkOption[0]))) {
                throw new RuntimeException("Can't determine db type.");
            }
            AbstractArrayAlphabet alphabet = n ? NucleotideSequence.ALPHABET : AminoAcidSequence.ALPHABET;
            return new BlastDB<NucleotideSequence>(name, dbTitle, records, letters, alphabet, volumes, temp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        extensionsToDelete.put(NucleotideSequence.ALPHABET, new String[]{".nhr", ".nin", ".nnd", ".nni", ".nog", ".nsd", ".nsi", ".nsq"});
        extensionsToDelete.put(AminoAcidSequence.ALPHABET, new String[]{".phr", ".pin", ".pnd", ".pni", ".pog", ".psd", ".psi", ".psq"});
        linePatterns = new Pattern[]{Pattern.compile("^Database: (.*)$"), Pattern.compile("^\\s*([0-9,]+)\\s*sequences;\\s*([0-9,]+)\\s*total .*$"), null, null, null, Pattern.compile("^\\s*Volumes:\\s*$")};
    }
}

