/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.blast;

import com.milaboratory.core.alignment.blast.Blast;
import com.milaboratory.core.alignment.blast.BlastDB;
import com.milaboratory.core.io.sequence.fasta.FastaWriter;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.util.RandomUtil;
import com.milaboratory.util.TempFileManager;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;

public final class BlastDBBuilder {
    private static final String RECORD_PREFIX = "RECORD";
    private static Path blastDbFolder = null;

    private static synchronized Path getTmpDBPath() {
        if (blastDbFolder == null) {
            blastDbFolder = TempFileManager.getTempDir().toPath();
        }
        return blastDbFolder;
    }

    public static String getIdFasta(int id) {
        return "lcl|RECORD" + id + "|";
    }

    public static String getIdKey(int id) {
        return RECORD_PREFIX + id;
    }

    public static <S extends Sequence<S>> BlastDB build(List<S> sequences) {
        return BlastDBBuilder.build(sequences, false);
    }

    public static <S extends Sequence<S>> BlastDB build(List<S> sequences, boolean buildIdIndex) {
        return BlastDBBuilder.build(sequences, buildIdIndex, null, true);
    }

    private static <S extends Sequence<S>> BlastDB build(List<S> sequences, boolean buildIdIndex, Path path, boolean tmp) {
        if (sequences.isEmpty()) {
            throw new IllegalArgumentException("No records.");
        }
        if (path == null) {
            path = BlastDBBuilder.getTmpDBPath();
        }
        Alphabet alphabet = ((Sequence)sequences.get(0)).getAlphabet();
        try {
            String name = RandomUtil.getThreadLocalRandomData().nextHexString(40);
            String fullName = path.resolve(name).toString();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.addAll(Arrays.asList("makeblastdb", "-dbtype", Blast.toBlastAlphabet(alphabet), "-out", fullName, "-title", name));
            cmd.addAll(Arrays.asList("-parse_seqids", "-hash_index"));
            Process proc = Blast.getProcessBuilder(cmd).start();
            FastaWriter<Sequence> writer = new FastaWriter<Sequence>(proc.getOutputStream(), 75);
            for (int i = 0; i < sequences.size(); ++i) {
                writer.write(BlastDBBuilder.getIdFasta(i), (Sequence)sequences.get(i));
            }
            writer.close();
            String err = IOUtils.toString((InputStream)proc.getErrorStream(), (Charset)Charset.forName("US-ASCII"));
            if (proc.waitFor() != 0) {
                throw new RuntimeException("Something goes wrong: " + err);
            }
            return BlastDB.get(fullName, tmp);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

