/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner1;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import cc.redberry.pipe.Processor;
import cc.redberry.pipe.blocks.ParallelProcessor;
import cc.redberry.primitives.Filter;
import com.milaboratory.core.alignment.batch.AlignmentResult;
import com.milaboratory.core.alignment.batch.BatchAlignerWithBaseWithFilter;
import com.milaboratory.core.alignment.batch.HasSequence;
import com.milaboratory.core.alignment.batch.PipedBatchAlignerWithBase;
import com.milaboratory.core.alignment.batch.SequenceExtractor;
import com.milaboratory.core.alignment.kaligner1.KAlignerParameters;
import com.milaboratory.core.alignment.kaligner1.KAlignmentHit;
import com.milaboratory.core.alignment.kaligner1.KAlignmentResult;
import com.milaboratory.core.alignment.kaligner1.KAlignmentResultP;
import com.milaboratory.core.alignment.kaligner1.KMapper;
import com.milaboratory.core.alignment.kaligner1.KMappingResult;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.util.BitArray;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class KAligner<P>
implements PipedBatchAlignerWithBase<NucleotideSequence, P, KAlignmentHit<P>>,
BatchAlignerWithBaseWithFilter<NucleotideSequence, P, KAlignmentHit<P>>,
Serializable {
    final KMapper mapper;
    final KAlignerParameters parameters;
    final List<NucleotideSequence> sequences = new ArrayList<NucleotideSequence>();
    final TIntObjectHashMap<P> payloads = new TIntObjectHashMap();
    final boolean lazyResults;
    volatile int threads = 1;

    public KAligner(KAlignerParameters parameters) {
        this(parameters, false);
    }

    public KAligner(KAlignerParameters parameters, boolean lazyResults) {
        this.mapper = KMapper.createFromParameters(parameters);
        this.parameters = parameters.clone();
        this.lazyResults = lazyResults;
    }

    public void setThreadCount(int threads) {
        this.threads = threads;
    }

    public int addReference(NucleotideSequence sequence) {
        return this.addReference(sequence, 0, sequence.size());
    }

    @Override
    public BitArray createFilter(Filter<P> filter) {
        BitArray ret = new BitArray(this.sequences.size());
        TIntObjectIterator it = this.payloads.iterator();
        while (it.hasNext()) {
            it.advance();
            if (!filter.accept(it.value())) continue;
            ret.set(it.key());
        }
        return ret;
    }

    public int addReference(NucleotideSequence sequence, int offset, int length) {
        if (sequence.containWildcards()) {
            throw new IllegalArgumentException("Reference sequences with wildcards not supported.");
        }
        int id = this.mapper.addReference(sequence, offset, length);
        assert (this.sequences.size() == id);
        this.sequences.add(sequence);
        return id;
    }

    public NucleotideSequence getReference(int id) {
        return this.sequences.get(id);
    }

    @Override
    public KAlignmentResult<P> align(NucleotideSequence sequence) {
        return this.align(sequence, 0, sequence.size());
    }

    @Override
    public KAlignmentResult<P> align(NucleotideSequence sequence, int from, int to) {
        return this.align(sequence, from, to, true, null);
    }

    public KAlignmentResult<P> align(NucleotideSequence sequence, int from, int to, boolean restrictToRange, BitArray filter) {
        KMappingResult kResult = this.mapper.align(sequence, from, to, filter);
        KAlignmentResult result = restrictToRange ? new KAlignmentResult(this, kResult, sequence, from, to) : new KAlignmentResult(this, kResult, sequence, 0, sequence.size());
        if (!this.lazyResults) {
            result.calculateAllAlignments();
        } else {
            result.sortAccordingToMapperScores();
        }
        return result;
    }

    @Override
    public AlignmentResult<KAlignmentHit<P>> align(NucleotideSequence sequence, int from, int to, BitArray filter) {
        return this.align(sequence, from, to, true, filter);
    }

    @Override
    public <Q> OutputPort<KAlignmentResultP<P, Q>> align(OutputPort<Q> input, final SequenceExtractor<Q, NucleotideSequence> extractor) {
        if (this.lazyResults) {
            throw new IllegalStateException("Piped processing is supported for lazy results.");
        }
        Processor proc = new Processor<Q, KAlignmentResultP<P, Q>>(){

            public KAlignmentResultP<P, Q> process(Q input) {
                NucleotideSequence seq = (NucleotideSequence)extractor.extract(input);
                KMappingResult kResult = KAligner.this.mapper.align(seq);
                return new KAlignmentResultP(input, KAligner.this, kResult, seq, 0, seq.size());
            }
        };
        return this.wrapPipe(proc, input);
    }

    @Override
    public <Q extends HasSequence<NucleotideSequence>> OutputPort<KAlignmentResultP<P, Q>> align(OutputPort<Q> input) {
        if (this.lazyResults) {
            throw new IllegalStateException("Piped processing is supported for lazy results.");
        }
        Processor proc = new Processor<Q, KAlignmentResultP<P, Q>>(){

            public KAlignmentResultP<P, Q> process(Q input) {
                NucleotideSequence seq = (NucleotideSequence)input.getSequence();
                KMappingResult kResult = KAligner.this.mapper.align(seq);
                return new KAlignmentResultP(input, KAligner.this, kResult, seq, 0, seq.size());
            }
        };
        return this.wrapPipe(proc, input);
    }

    @Override
    public void addReference(NucleotideSequence sequence, P payload) {
        int id = this.addReference(sequence);
        this.payloads.put(id, payload);
    }

    private <Q> OutputPort<KAlignmentResultP<P, Q>> wrapPipe(Processor<Q, KAlignmentResultP<P, Q>> proc, OutputPort<Q> input) {
        if (this.threads == 1) {
            return CUtils.wrap(input, proc);
        }
        int t = this.threads == 0 ? Runtime.getRuntime().availableProcessors() : this.threads;
        return new ParallelProcessor(input, proc, t);
    }
}

