/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner1;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.milaboratory.core.alignment.LinearGapAlignmentScoring;
import com.milaboratory.core.alignment.kaligner1.AbstractKAlignerParameters;
import com.milaboratory.core.alignment.kaligner1.KAligner;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.util.GlobalObjectMappers;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class KAlignerParameters
implements Cloneable,
Serializable,
AbstractKAlignerParameters {
    private static final long serialVersionUID = 1L;
    private static final Map<String, KAlignerParameters> knownParameters;
    private int mapperKValue;
    private boolean floatingLeftBound;
    private boolean floatingRightBound;
    private float mapperAbsoluteMinScore;
    private float mapperRelativeMinScore;
    private float mapperMatchScore;
    private float mapperMismatchPenalty;
    private float mapperOffsetShiftPenalty;
    private int mapperMinSeedsDistance;
    private int mapperMaxSeedsDistance;
    private int minAlignmentLength;
    private int maxAdjacentIndels;
    private int alignmentStopPenalty;
    private float absoluteMinScore;
    private float relativeMinScore;
    private int maxHits;
    private LinearGapAlignmentScoring<NucleotideSequence> scoring;

    public static KAlignerParameters getByName(String name) {
        KAlignerParameters params = knownParameters.get(name);
        if (params == null) {
            return null;
        }
        return params.clone();
    }

    public static Set<String> getAvailableNames() {
        return knownParameters.keySet();
    }

    public KAlignerParameters() {
    }

    public KAlignerParameters(int mapperKValue, boolean floatingLeftBound, boolean floatingRightBound, float mapperAbsoluteMinScore, float mapperRelativeMinScore, float mapperMatchScore, float mapperMismatchPenalty, float mapperOffsetShiftPenalty, int mapperMinSeedsDistance, int mapperMaxSeedsDistance, int minAlignmentLength, int maxAdjacentIndels, int alignmentStopPenalty, float absoluteMinScore, float relativeMinScore, int maxHits, LinearGapAlignmentScoring<NucleotideSequence> scoring) {
        this.mapperKValue = mapperKValue;
        this.floatingLeftBound = floatingLeftBound;
        this.floatingRightBound = floatingRightBound;
        this.mapperAbsoluteMinScore = mapperAbsoluteMinScore;
        this.mapperRelativeMinScore = mapperRelativeMinScore;
        this.mapperMatchScore = mapperMatchScore;
        this.mapperMismatchPenalty = mapperMismatchPenalty;
        this.mapperOffsetShiftPenalty = mapperOffsetShiftPenalty;
        this.mapperMinSeedsDistance = mapperMinSeedsDistance;
        this.mapperMaxSeedsDistance = mapperMaxSeedsDistance;
        this.minAlignmentLength = minAlignmentLength;
        this.maxAdjacentIndels = maxAdjacentIndels;
        this.alignmentStopPenalty = alignmentStopPenalty;
        this.absoluteMinScore = absoluteMinScore;
        this.relativeMinScore = relativeMinScore;
        this.maxHits = maxHits;
        this.scoring = scoring;
        if (scoring != null && !scoring.uniformBasicMatchScore()) {
            throw new IllegalArgumentException("Use scoring with common match score.");
        }
    }

    public <P> KAligner<P> createAligner() {
        return new KAligner(this);
    }

    public int getMapperKValue() {
        return this.mapperKValue;
    }

    public KAlignerParameters setMapperKValue(int kValue) {
        this.mapperKValue = kValue;
        return this;
    }

    public float getMapperAbsoluteMinScore() {
        return this.mapperAbsoluteMinScore;
    }

    public KAlignerParameters setMapperAbsoluteMinScore(float mapperAbsoluteMinScore) {
        this.mapperAbsoluteMinScore = mapperAbsoluteMinScore;
        return this;
    }

    public float getMapperRelativeMinScore() {
        return this.mapperRelativeMinScore;
    }

    public KAlignerParameters setMapperRelativeMinScore(float mapperRelativeMinScore) {
        this.mapperRelativeMinScore = mapperRelativeMinScore;
        return this;
    }

    public float getMapperMatchScore() {
        return this.mapperMatchScore;
    }

    public KAlignerParameters setMapperMatchScore(float mapperMatchScore) {
        this.mapperMatchScore = mapperMatchScore;
        return this;
    }

    public float getMapperMismatchPenalty() {
        return this.mapperMismatchPenalty;
    }

    public KAlignerParameters setMapperMismatchPenalty(float mapperMismatchPenalty) {
        this.mapperMismatchPenalty = mapperMismatchPenalty;
        return this;
    }

    public int getMinAlignmentLength() {
        return this.minAlignmentLength;
    }

    public KAlignerParameters setMinAlignmentLength(int minAlignmentLength) {
        this.minAlignmentLength = minAlignmentLength;
        return this;
    }

    public int getMaxAdjacentIndels() {
        return this.maxAdjacentIndels;
    }

    public KAlignerParameters setMaxAdjacentIndels(int maxAdjacentIndels) {
        this.maxAdjacentIndels = maxAdjacentIndels;
        return this;
    }

    public int getMapperMinSeedsDistance() {
        return this.mapperMinSeedsDistance;
    }

    public KAlignerParameters setMapperMinSeedsDistance(int mapperMinSeedsDistance) {
        this.mapperMinSeedsDistance = mapperMinSeedsDistance;
        return this;
    }

    public int getMapperMaxSeedsDistance() {
        return this.mapperMaxSeedsDistance;
    }

    public KAlignerParameters setMapperMaxSeedsDistance(int mapperMaxSeedsDistance) {
        this.mapperMaxSeedsDistance = mapperMaxSeedsDistance;
        return this;
    }

    public int getAlignmentStopPenalty() {
        return this.alignmentStopPenalty;
    }

    public KAlignerParameters setAlignmentStopPenalty(int alignmentStopPenalty) {
        this.alignmentStopPenalty = alignmentStopPenalty;
        return this;
    }

    public LinearGapAlignmentScoring<NucleotideSequence> getScoring() {
        return this.scoring;
    }

    public KAlignerParameters setScoring(LinearGapAlignmentScoring scoring) {
        if (scoring != null && !scoring.uniformBasicMatchScore()) {
            throw new IllegalArgumentException("Use scoring with common match score.");
        }
        this.scoring = scoring;
        return this;
    }

    @Override
    public boolean isFloatingLeftBound() {
        return this.floatingLeftBound;
    }

    public KAlignerParameters setFloatingLeftBound(boolean floatingLeftBound) {
        this.floatingLeftBound = floatingLeftBound;
        return this;
    }

    @Override
    public boolean isFloatingRightBound() {
        return this.floatingRightBound;
    }

    public KAlignerParameters setFloatingRightBound(boolean floatingRightBound) {
        this.floatingRightBound = floatingRightBound;
        return this;
    }

    public float getMapperOffsetShiftPenalty() {
        return this.mapperOffsetShiftPenalty;
    }

    public KAlignerParameters setMapperOffsetShiftPenalty(float mapperOffsetShiftPenalty) {
        this.mapperOffsetShiftPenalty = mapperOffsetShiftPenalty;
        return this;
    }

    public float getAbsoluteMinScore() {
        return this.absoluteMinScore;
    }

    public KAlignerParameters setAbsoluteMinScore(float absoluteMinScore) {
        this.absoluteMinScore = absoluteMinScore;
        return this;
    }

    @Override
    public float getRelativeMinScore() {
        return this.relativeMinScore;
    }

    public KAlignerParameters setRelativeMinScore(float relativeMinScore) {
        this.relativeMinScore = relativeMinScore;
        return this;
    }

    @Override
    public int getMaxHits() {
        return this.maxHits;
    }

    public KAlignerParameters setMaxHits(int maxHits) {
        this.maxHits = maxHits;
        return this;
    }

    @Override
    public KAlignerParameters clone() {
        try {
            KAlignerParameters c = (KAlignerParameters)super.clone();
            if (this.scoring != null) {
                c.setScoring(this.scoring);
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KAlignerParameters that = (KAlignerParameters)o;
        if (this.floatingLeftBound != that.floatingLeftBound) {
            return false;
        }
        if (this.floatingRightBound != that.floatingRightBound) {
            return false;
        }
        if (Float.compare(that.mapperRelativeMinScore, this.mapperRelativeMinScore) != 0) {
            return false;
        }
        if (this.mapperKValue != that.mapperKValue) {
            return false;
        }
        if (Float.compare(that.mapperMatchScore, this.mapperMatchScore) != 0) {
            return false;
        }
        if (this.maxAdjacentIndels != that.maxAdjacentIndels) {
            return false;
        }
        if (this.mapperMaxSeedsDistance != that.mapperMaxSeedsDistance) {
            return false;
        }
        if (this.minAlignmentLength != that.minAlignmentLength) {
            return false;
        }
        if (Float.compare(that.mapperAbsoluteMinScore, this.mapperAbsoluteMinScore) != 0) {
            return false;
        }
        if (this.mapperMinSeedsDistance != that.mapperMinSeedsDistance) {
            return false;
        }
        if (Float.compare(that.mapperMismatchPenalty, this.mapperMismatchPenalty) != 0) {
            return false;
        }
        if (Float.compare(that.mapperOffsetShiftPenalty, this.mapperOffsetShiftPenalty) != 0) {
            return false;
        }
        if (this.alignmentStopPenalty != that.alignmentStopPenalty) {
            return false;
        }
        return this.scoring.equals(that.scoring);
    }

    public int hashCode() {
        int result = this.mapperKValue;
        result = 31 * result + (this.floatingLeftBound ? 1 : 0);
        result = 31 * result + (this.floatingRightBound ? 1 : 0);
        result = 31 * result + (this.mapperAbsoluteMinScore != 0.0f ? Float.floatToIntBits(this.mapperAbsoluteMinScore) : 0);
        result = 31 * result + (this.mapperRelativeMinScore != 0.0f ? Float.floatToIntBits(this.mapperRelativeMinScore) : 0);
        result = 31 * result + (this.mapperMatchScore != 0.0f ? Float.floatToIntBits(this.mapperMatchScore) : 0);
        result = 31 * result + (this.mapperMismatchPenalty != 0.0f ? Float.floatToIntBits(this.mapperMismatchPenalty) : 0);
        result = 31 * result + (this.mapperOffsetShiftPenalty != 0.0f ? Float.floatToIntBits(this.mapperOffsetShiftPenalty) : 0);
        result = 31 * result + this.minAlignmentLength;
        result = 31 * result + this.maxAdjacentIndels;
        result = 31 * result + this.mapperMinSeedsDistance;
        result = 31 * result + this.mapperMaxSeedsDistance;
        result = 31 * result + this.alignmentStopPenalty;
        result = 31 * result + this.scoring.hashCode();
        return result;
    }

    public String toString() {
        try {
            return "KAlignerParameters" + GlobalObjectMappers.PRETTY.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "Error...";
        }
    }

    static {
        Map map = null;
        try {
            InputStream is = KAlignerParameters.class.getClassLoader().getResourceAsStream("parameters/kaligner_parameters.json");
            TypeReference<HashMap<String, KAlignerParameters>> typeRef = new TypeReference<HashMap<String, KAlignerParameters>>(){};
            map = (Map)GlobalObjectMappers.ONE_LINE.readValue(is, (TypeReference)typeRef);
        }
        catch (IOException ioe) {
            System.out.println("ERROR!");
            ioe.printStackTrace();
        }
        knownParameters = map;
    }
}

