/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner1;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.AlignmentCache;
import com.milaboratory.core.alignment.AlignmentScoring;
import com.milaboratory.core.alignment.AlignmentTrimmer;
import com.milaboratory.core.alignment.BandedLinearAligner;
import com.milaboratory.core.alignment.BandedSemiLocalResult;
import com.milaboratory.core.alignment.CachedIntArray;
import com.milaboratory.core.alignment.LinearGapAlignmentScoring;
import com.milaboratory.core.alignment.batch.AlignmentHit;
import com.milaboratory.core.alignment.kaligner1.KAligner;
import com.milaboratory.core.alignment.kaligner1.KAlignerParameters;
import com.milaboratory.core.alignment.kaligner1.KAlignmentResult;
import com.milaboratory.core.alignment.kaligner1.KMappingHit;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.util.IntArrayList;
import java.io.Serializable;
import java.util.Arrays;

public final class KAlignmentHit<P>
implements Serializable,
AlignmentHit<NucleotideSequence, P> {
    private final KAlignmentResult<P> result;
    private final int index;
    private Alignment<NucleotideSequence> alignment = null;

    public KAlignmentHit(KAlignmentResult<P> result, int index) {
        this.result = result;
        this.index = index;
    }

    @Override
    public P getRecordPayload() {
        return (P)this.result.aligner.payloads.get(this.getId());
    }

    public int getId() {
        return this.result.mappingResult.hits.get((int)this.index).id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateAlignment() {
        CachedIntArray array = AlignmentCache.get();
        try {
            BandedSemiLocalResult br;
            int currentOffset;
            int i;
            KMappingHit hit = this.result.mappingResult.hits.get(this.index);
            IntArrayList seeds = this.result.mappingResult.seeds;
            KAligner aligner = this.result.aligner;
            KAlignerParameters parameters = aligner.parameters;
            NucleotideSequence reference = aligner.getReference(hit.id);
            NucleotideSequence target = this.result.target;
            int targetFrom = this.result.targetFrom;
            int targetTo = this.result.targetTo;
            MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
            int maxIndels = parameters.getMaxAdjacentIndels();
            int kValue = parameters.getMapperKValue();
            int gRefFrom = -1;
            int gRefTo = -1;
            int gSeqFrom = -1;
            int gSeqTo = -1;
            int previousOffset = Integer.MIN_VALUE;
            int previousSeedPosition = Integer.MIN_VALUE;
            for (i = 0; i < hit.seedOffsets.length; ++i) {
                currentOffset = hit.seedOffsets[i];
                if (currentOffset == -2147483647 || previousOffset != Integer.MIN_VALUE) continue;
                previousOffset = currentOffset;
                gSeqFrom = previousSeedPosition = seeds.get(hit.from + i);
                gSeqTo = gSeqFrom + kValue;
                gRefFrom = gSeqFrom - previousOffset;
                gRefTo = gSeqTo - previousOffset;
                ++i;
                break;
            }
            int seqFrom = previousOffset - maxIndels;
            int seqLength = previousSeedPosition - seqFrom;
            int seqAdded = maxIndels * 2 + 1;
            int refFrom = targetFrom - previousOffset - maxIndels;
            int refLength = previousSeedPosition - previousOffset - refFrom;
            int refAdded = maxIndels * 2 + 1;
            if (seqFrom < targetFrom) {
                seqFrom = targetFrom - seqFrom;
                seqLength -= seqFrom;
                seqAdded -= seqFrom;
                seqFrom = targetFrom;
                if (seqAdded < 0) {
                    seqAdded = 0;
                } else if (seqAdded > seqLength) {
                    seqAdded = seqLength;
                }
            }
            if (refFrom < 0) {
                refLength += refFrom;
                refAdded += refFrom;
                refFrom = 0;
                if (refAdded < 0) {
                    refAdded = 0;
                } else if (refAdded > refLength) {
                    refAdded = refLength;
                }
            }
            AlignmentScoring scoring = parameters.getScoring();
            if (parameters.isFloatingLeftBound()) {
                br = BandedLinearAligner.alignSemiLocalRight0((LinearGapAlignmentScoring)scoring, reference, target, refFrom, refLength, seqFrom, seqLength, maxIndels, parameters.getAlignmentStopPenalty(), mutations, array);
                gRefFrom = br.sequence1Stop;
                gSeqFrom = br.sequence2Stop;
            } else {
                br = BandedLinearAligner.alignLeftAdded0((LinearGapAlignmentScoring)scoring, reference, target, refFrom, refLength, refAdded, seqFrom, seqLength, seqAdded, maxIndels, mutations, array);
                assert (br.sequence2Stop == seqFrom || br.sequence1Stop == refFrom);
                gSeqFrom = br.sequence2Stop;
                gRefFrom = br.sequence1Stop;
            }
            while (i < hit.seedOffsets.length) {
                currentOffset = hit.seedOffsets[i];
                if (currentOffset != -2147483647 && previousOffset != Integer.MIN_VALUE) {
                    int currentSeedPosition = seeds.get(hit.from + i);
                    seqFrom = previousSeedPosition + kValue;
                    seqLength = currentSeedPosition - seqFrom;
                    refFrom = seqFrom - previousOffset;
                    refLength = currentSeedPosition - currentOffset - refFrom;
                    assert (((NucleotideSequence)target.getRange(seqFrom - kValue, seqFrom)).equals(reference.getRange(refFrom - kValue, refFrom)));
                    if (refLength < 0 || seqLength < 0) {
                        seqFrom -= kValue;
                        refFrom -= kValue;
                        seqLength += kValue;
                        refLength += kValue;
                    }
                    if (refLength > 0 || seqLength > 0) {
                        BandedLinearAligner.align0((LinearGapAlignmentScoring)scoring, reference, target, refFrom, refLength, seqFrom, seqLength, parameters.getMaxAdjacentIndels(), mutations, array);
                    }
                    gSeqTo = currentSeedPosition + kValue;
                    gRefTo = gSeqTo - currentOffset;
                    previousOffset = currentOffset;
                    previousSeedPosition = currentSeedPosition;
                }
                ++i;
            }
            seqFrom = gSeqTo;
            seqLength = reference.size() - gRefTo + maxIndels;
            seqAdded = maxIndels * 2 + 1;
            refFrom = gRefTo;
            refLength = targetTo - gSeqTo + maxIndels;
            refAdded = maxIndels * 2 + 1;
            if (seqFrom + seqLength > targetTo) {
                if ((seqAdded -= seqFrom + seqLength - targetTo) > (seqLength = targetTo - seqFrom)) {
                    seqAdded = seqLength;
                } else if (seqAdded < 0) {
                    seqAdded = 0;
                }
            }
            if (refFrom + refLength > reference.size()) {
                if ((refAdded -= refFrom + refLength - reference.size()) > (refLength = reference.size() - refFrom)) {
                    refAdded = refLength;
                } else if (refAdded < 0) {
                    refAdded = 0;
                }
            }
            if (parameters.isFloatingRightBound()) {
                br = BandedLinearAligner.alignSemiLocalLeft0((LinearGapAlignmentScoring)scoring, reference, target, refFrom, refLength, seqFrom, seqLength, maxIndels, parameters.getAlignmentStopPenalty(), mutations, array);
                gRefTo = br.sequence1Stop + 1;
                gSeqTo = br.sequence2Stop + 1;
            } else {
                br = BandedLinearAligner.alignRightAdded0((LinearGapAlignmentScoring)scoring, reference, target, refFrom, refLength, refAdded, seqFrom, seqLength, seqAdded, maxIndels, mutations, array);
                gRefTo = br.sequence1Stop + 1;
                gSeqTo = br.sequence2Stop + 1;
            }
            Mutations<NucleotideSequence> muts = mutations.createAndDestroy();
            Alignment<NucleotideSequence> al = new Alignment<NucleotideSequence>(reference, muts, new Range(gRefFrom, gRefTo), new Range(gSeqFrom, gSeqTo), scoring);
            if (parameters.isFloatingRightBound()) {
                al = AlignmentTrimmer.rightTrimAlignment(al, scoring);
            }
            if (parameters.isFloatingLeftBound()) {
                al = AlignmentTrimmer.leftTrimAlignment(al, scoring);
            }
            this.alignment = al;
        }
        finally {
            AlignmentCache.release();
        }
    }

    public KMappingHit getKMersHit() {
        return this.result.mappingResult.hits.get(this.index);
    }

    @Override
    public Alignment<NucleotideSequence> getAlignment() {
        if (this.alignment == null) {
            throw new IllegalStateException("Alignment has not yet been built.");
        }
        return this.alignment;
    }

    public KAlignmentResult getResult() {
        return this.result;
    }

    public NucleotideSequence getHitSequence() {
        return this.result.aligner.getReference(this.getId());
    }

    public static void printHitAlignment(KAlignmentHit hit) {
        NucleotideSequence ref = hit.getResult().getAligner().getReference(hit.getId());
        Alignment<NucleotideSequence> la = hit.getAlignment();
        System.out.println(la.getAlignmentHelper());
        System.out.println(hit.getResult().getTarget());
        int prev = 0;
        for (int i = hit.getKMersHit().from; i < hit.getKMersHit().to; ++i) {
            if (hit.getKMersHit().seedOffsets[i - hit.getKMersHit().from] == -2147483647) continue;
            int curr = hit.getResult().getMappingResult().seeds.get(i);
            System.out.print(KAlignmentHit.spaces(curr - prev) + "*");
            prev = curr + 1;
        }
        System.out.println();
    }

    private static String spaces(int n) {
        char[] charArray = new char[n];
        Arrays.fill(charArray, ' ');
        return new String(charArray);
    }
}

