/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner1;

import com.milaboratory.core.alignment.batch.AlignmentResult;
import com.milaboratory.core.alignment.kaligner1.KAligner;
import com.milaboratory.core.alignment.kaligner1.KAlignerParameters;
import com.milaboratory.core.alignment.kaligner1.KAlignmentHit;
import com.milaboratory.core.alignment.kaligner1.KMappingResult;
import com.milaboratory.core.sequence.NucleotideSequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class KAlignmentResult<P>
implements AlignmentResult<KAlignmentHit<P>>,
Iterable<KAlignmentHit<P>>,
Serializable {
    private static final Comparator<KAlignmentHit> HIT_COMPARATOR = new Comparator<KAlignmentHit>(){

        @Override
        public int compare(KAlignmentHit o1, KAlignmentHit o2) {
            return Float.compare(o2.getAlignment().getScore(), o1.getAlignment().getScore());
        }
    };
    private static final Comparator<KAlignmentHit> HIT_COMPARATOR_MAPPER = new Comparator<KAlignmentHit>(){

        @Override
        public int compare(KAlignmentHit o1, KAlignmentHit o2) {
            return Float.compare(o2.getKMersHit().score, o1.getKMersHit().score);
        }
    };
    final KAligner<P> aligner;
    final KMappingResult mappingResult;
    final List<KAlignmentHit<P>> hits;
    final NucleotideSequence target;
    final int targetFrom;
    final int targetTo;

    public KAlignmentResult(KAligner<P> aligner, KMappingResult mappingResult, NucleotideSequence target, int targetFrom, int targetTo) {
        this.aligner = aligner;
        this.mappingResult = mappingResult;
        this.target = target;
        this.targetFrom = targetFrom;
        this.targetTo = targetTo;
        this.hits = new ArrayList<KAlignmentHit<P>>(mappingResult.hits.size());
        for (int i = 0; i < mappingResult.hits.size(); ++i) {
            this.hits.add(new KAlignmentHit(this, i));
        }
    }

    public KAligner getAligner() {
        return this.aligner;
    }

    public KMappingResult getMappingResult() {
        return this.mappingResult;
    }

    @Override
    public boolean hasHits() {
        return !this.hits.isEmpty();
    }

    @Override
    public KAlignmentHit getBestHit() {
        if (this.hits.isEmpty()) {
            return null;
        }
        return this.hits.get(0);
    }

    @Override
    public List<KAlignmentHit<P>> getHits() {
        return this.hits;
    }

    public NucleotideSequence getTarget() {
        return this.target;
    }

    public int getTargetFrom() {
        return this.targetFrom;
    }

    public int getTargetTo() {
        return this.targetTo;
    }

    private void _calculateAllAlignments() {
        for (KAlignmentHit<P> hit : this.hits) {
            hit.calculateAlignment();
        }
    }

    public void sortAccordingToMapperScores() {
        Collections.sort(this.hits, HIT_COMPARATOR_MAPPER);
    }

    public void calculateAllAlignments() {
        this._calculateAllAlignments();
        this.refresh();
    }

    public void refresh() {
        KAlignerParameters params = this.aligner.parameters;
        this.sortHits(params.getAbsoluteMinScore(), params.getRelativeMinScore(), params.getMaxHits());
    }

    private void sortHits(double minScore, double tolerance, int maxHits) {
        Collections.sort(this.hits, HIT_COMPARATOR);
        if (this.hits.isEmpty()) {
            return;
        }
        minScore = Math.max(minScore, (double)this.hits.get(0).getAlignment().getScore() * tolerance);
        if (this.hits.size() > maxHits) {
            minScore = Math.max(minScore, (double)this.hits.get(maxHits - 1).getAlignment().getScore());
        }
        for (int i = this.hits.size() - 1; i >= 0 && (double)this.hits.get(i).getAlignment().getScore() < minScore; --i) {
            this.hits.remove(i);
        }
    }

    @Override
    public Iterator<KAlignmentHit<P>> iterator() {
        return this.hits.iterator();
    }
}

