/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner1;

import com.milaboratory.core.alignment.kaligner1.KAlignerParameters;
import com.milaboratory.core.alignment.kaligner1.KMappingHit;
import com.milaboratory.core.alignment.kaligner1.KMappingResult;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.util.BitArray;
import com.milaboratory.util.IntArrayList;
import com.milaboratory.util.RandomUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public final class KMapper
implements Serializable {
    public static final int SEED_NOT_FOUND_OFFSET = -2147483647;
    private final int bitsForOffset;
    private final int offsetMask;
    private final int kValue;
    private final int[][] base;
    private final int[] lengths;
    private final float absoluteMinScore;
    private final float relativeMinScore;
    private final float matchScore;
    private final float mismatchPenalty;
    private final float offsetShiftPenalty;
    private final int minAlignmentLength;
    private final int maxIndels;
    private final boolean floatingLeftBound;
    private final boolean floatingRightBound;
    private final int minDistance;
    private final int maxDistance;
    private boolean built = false;
    private int[] refFrom = new int[10];
    private int[] refLength = new int[10];
    private int maxReferenceLength = 0;
    private int minReferenceLength = Integer.MAX_VALUE;
    private int sequencesInBase = 0;
    private BitArray allFilter;

    public KMapper(int kValue, int minDistance, int maxDistance, float absoluteMinScore, float relativeMinScore, int minAlignmentLength, float matchScore, float mismatchPenalty, float offsetShiftPenalty, int maxIndels, boolean floatingLeftBound, boolean floatingRightBound) {
        this.kValue = kValue;
        this.bitsForOffset = 18;
        this.offsetMask = -1 >>> 32 - this.bitsForOffset;
        int maxNumberOfKmers = 1 << kValue * 2;
        this.base = new int[maxNumberOfKmers][10];
        this.lengths = new int[maxNumberOfKmers];
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.absoluteMinScore = absoluteMinScore;
        this.relativeMinScore = relativeMinScore;
        this.minAlignmentLength = minAlignmentLength;
        this.matchScore = matchScore;
        this.mismatchPenalty = mismatchPenalty;
        this.offsetShiftPenalty = offsetShiftPenalty;
        this.maxIndels = maxIndels;
        this.floatingLeftBound = floatingLeftBound;
        this.floatingRightBound = floatingRightBound;
    }

    public static KMapper createFromParameters(KAlignerParameters parameters) {
        return new KMapper(parameters.getMapperKValue(), parameters.getMapperMinSeedsDistance(), parameters.getMapperMaxSeedsDistance(), parameters.getMapperAbsoluteMinScore(), parameters.getMapperRelativeMinScore(), parameters.getMinAlignmentLength(), parameters.getMapperMatchScore(), parameters.getMapperMismatchPenalty(), parameters.getMapperOffsetShiftPenalty(), parameters.getMaxAdjacentIndels(), parameters.isFloatingLeftBound(), parameters.isFloatingRightBound());
    }

    static int getBestOffset(IntArrayList offsets, int except, int shift, int maxOffsetDelta) {
        if (offsets.size() == 1) {
            return offsets.get(0) >> shift;
        }
        int old = 0x1FFFFFFF;
        int maxOffset = Integer.MIN_VALUE;
        int maxCount = 0;
        int lastMaxIndex = offsets.size() - 1;
        int[] counters = new int[maxOffsetDelta + 1];
        for (int i = offsets.size() - 1; i >= 0; --i) {
            int current = offsets.get(i) >> shift;
            if (old - current > maxOffsetDelta) {
                if (maxCount < lastMaxIndex - i && old != except) {
                    maxOffset = old - KMapper.maxIndex(counters);
                    maxCount = lastMaxIndex - i;
                }
                old = current;
                lastMaxIndex = i;
                Arrays.fill(counters, 0);
            }
            int n = old - current;
            counters[n] = counters[n] + 1;
        }
        if (maxCount < lastMaxIndex + 1 && old != except) {
            maxOffset = old - KMapper.maxIndex(counters);
        }
        assert (maxOffset != 0x1FFFFFFF && maxOffset != Integer.MIN_VALUE);
        return maxOffset;
    }

    private static int maxIndex(int[] array) {
        int value = array[array.length - 1];
        int maxI = array.length - 1;
        for (int i = maxI - 1; i >= 0; --i) {
            if (array[i] <= value) continue;
            value = array[i];
            maxI = i;
        }
        return maxI;
    }

    private void addKmer(int kmer, int id, int offset) {
        if (this.base[kmer].length == this.lengths[kmer]) {
            this.base[kmer] = Arrays.copyOf(this.base[kmer], this.base[kmer].length * 3 / 2 + 1);
        }
        if ((offset & this.offsetMask) != offset) {
            throw new IllegalArgumentException("Record is too long.");
        }
        int n = kmer;
        int n2 = this.lengths[n];
        this.lengths[n] = n2 + 1;
        this.base[kmer][n2] = id << this.bitsForOffset | offset;
    }

    public int addReference(NucleotideSequence sequence) {
        return this.addReference(sequence, 0, sequence.size());
    }

    public int addReference(NucleotideSequence sequence, int offset, int length) {
        this.built = false;
        if (this.refLength.length == this.sequencesInBase) {
            this.refLength = Arrays.copyOf(this.refLength, this.sequencesInBase * 3 / 2 + 1);
            this.refFrom = Arrays.copyOf(this.refFrom, this.sequencesInBase * 3 / 2 + 1);
        }
        int id = this.sequencesInBase++;
        this.refFrom[id] = offset;
        this.refLength[id] = sequence.size();
        this.maxReferenceLength = Math.max(this.maxReferenceLength, sequence.size());
        this.minReferenceLength = Math.min(this.minReferenceLength, sequence.size());
        int kmer = 0;
        int kmerMask = -1 >>> 32 - this.kValue * 2;
        int tMask = -1 >>> 34 - this.kValue * 2;
        int to = length - this.kValue;
        for (int j = 0; j < this.kValue; ++j) {
            kmer = kmer << 2 | sequence.codeAt(j + offset);
        }
        this.addKmer(kmer, id, offset);
        for (int i = 1; i <= to; ++i) {
            if ((((kmer = kmerMask & (kmer << 2 | sequence.codeAt(offset + i + this.kValue - 1))) ^ kmer >>> 2) & tMask) == 0 && ((kmer ^ kmer << 2) & tMask << 2) == 0) continue;
            this.addKmer(kmer, id, i + offset);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureBuilt() {
        if (!this.built) {
            KMapper kMapper = this;
            synchronized (kMapper) {
                if (!this.built) {
                    for (int i = 0; i < this.base.length; ++i) {
                        this.base[i] = Arrays.copyOf(this.base[i], this.lengths[i]);
                    }
                    this.refLength = Arrays.copyOf(this.refLength, this.sequencesInBase);
                    this.refFrom = Arrays.copyOf(this.refFrom, this.sequencesInBase);
                    this.allFilter = new BitArray(this.sequencesInBase);
                    this.allFilter.setAll();
                    this.built = true;
                }
            }
        }
    }

    private void getScoreFromOffsets(IntArrayList offsets, Info ret) {
        int score = 0;
        int shift = 32 - this.bitsForOffset;
        int bestOffset = KMapper.getBestOffset(offsets, Integer.MIN_VALUE, shift, this.maxIndels);
        for (int i = offsets.size() - 1; i >= 0; --i) {
            int current = (offsets.get(i) >> shift) - bestOffset;
            if ((current > this.maxIndels || current < 0) && (current < -this.maxIndels || current >= 0)) continue;
            ++score;
        }
        ret.score = score;
        ret.offset = bestOffset;
    }

    public KMappingResult align(NucleotideSequence sequence) {
        return this.align(sequence, 0, sequence.size(), null);
    }

    public KMappingResult align(NucleotideSequence sequence, int from, int to) {
        return this.align(sequence, from, to, null);
    }

    public KMappingResult align(NucleotideSequence sequence, int from, int to, BitArray filter) {
        KMappingHit hit;
        int j;
        int i;
        this.ensureBuilt();
        if (filter == null) {
            filter = this.allFilter;
        }
        ArrayList<KMappingHit> result = new ArrayList<KMappingHit>();
        if (to - from <= this.kValue) {
            return new KMappingResult(null, result);
        }
        IntArrayList seedPositions = new IntArrayList((to - from) / this.minDistance + 2);
        int seedPosition = from;
        seedPositions.add(seedPosition);
        Well19937c random = RandomUtil.getThreadLocalRandom();
        while ((seedPosition += random.nextInt(this.maxDistance + 1 - this.minDistance) + this.minDistance) < to - this.kValue) {
            seedPositions.add(seedPosition);
        }
        seedPositions.add(to - this.kValue);
        int[] seeds = new int[seedPositions.size()];
        IntArrayList[] candidates = new IntArrayList[this.sequencesInBase];
        for (int i2 = 0; i2 < seeds.length; ++i2) {
            int kmer = 0;
            for (int j2 = seedPositions.get(i2); j2 < seedPositions.get(i2) + this.kValue; ++j2) {
                kmer = kmer << 2 | sequence.codeAt(j2);
            }
            seeds[i2] = kmer;
            if (this.base[kmer].length == 0) continue;
            for (int record : this.base[kmer]) {
                int id = record >>> this.bitsForOffset;
                if (!filter.get(id)) continue;
                int offset = record & this.offsetMask;
                if (candidates[id] == null) {
                    candidates[id] = new IntArrayList();
                }
                candidates[id].add(seedPositions.get(i2) - offset << 32 - this.bitsForOffset | i2);
            }
        }
        Info info = new Info();
        for (i = candidates.length - 1; i >= 0; --i) {
            double preScore;
            if (candidates[i] == null || candidates[i].size() < (this.minAlignmentLength - this.kValue + 1) / this.maxDistance) continue;
            candidates[i].sort();
            this.getScoreFromOffsets(candidates[i], info);
            int cFrom = Math.max(info.offset, from);
            int cTo = Math.min(info.offset + this.refLength[i], to) - this.kValue;
            int siFrom = -1;
            int siTo = -1;
            for (j = seedPositions.size() - 1; j >= 0; --j) {
                seedPosition = seedPositions.get(j);
                if (seedPosition > cTo) continue;
                if (siTo == -1) {
                    siTo = j + 1;
                }
                if (seedPosition >= cFrom) continue;
                siFrom = j + 1;
                break;
            }
            if (siFrom == -1) {
                siFrom = 0;
            }
            if (!((preScore = (double)(this.matchScore * (float)info.score)) >= (double)this.absoluteMinScore)) continue;
            result.add(new KMappingHit(info.offset, i, (float)preScore, siFrom, siTo));
        }
        int seedIndexMask = -1 >>> this.bitsForOffset;
        double maxScore = 0.0;
        for (j = result.size() - 1; j >= 0; --j) {
            int c;
            hit = result.get(j);
            hit.seedOffsets = new int[hit.to - hit.from];
            Arrays.fill(hit.seedOffsets, -2147483647);
            for (int k = candidates[hit.id].size() - 1; k >= 0; --k) {
                int offsetDelta;
                c = candidates[hit.id].get(k);
                int seedIndex = c & seedIndexMask;
                if (seedIndex < result.get((int)j).from || seedIndex >= result.get((int)j).to || (offsetDelta = Math.abs((c >> 32 - this.bitsForOffset) - hit.offset)) > this.maxIndels || hit.seedOffsets[seedIndex -= hit.from] != -2147483647 && Math.abs(hit.seedOffsets[seedIndex] - hit.offset) <= offsetDelta) continue;
                hit.seedOffsets[seedIndex] = c >> 32 - this.bitsForOffset;
            }
            int prev = -1;
            c = -1;
            for (i = hit.seedOffsets.length - 1; i >= 0; --i) {
                if (hit.seedOffsets[i] == -2147483647) continue;
                if (c != -1 && hit.seedOffsets[c] != hit.seedOffsets[prev] && hit.seedOffsets[prev] != hit.seedOffsets[i] && hit.seedOffsets[c] < hit.seedOffsets[prev] != hit.seedOffsets[prev] < hit.seedOffsets[i]) {
                    hit.seedOffsets[prev] = -2147483647;
                    prev = -1;
                }
                c = prev;
                prev = i;
            }
            float score = 0.0f;
            for (int off : hit.seedOffsets) {
                if (off != -2147483647) {
                    score += this.matchScore;
                    continue;
                }
                score += this.mismatchPenalty;
            }
            if (this.floatingLeftBound) {
                prev = -1;
                for (i = 0; i < hit.seedOffsets.length; ++i) {
                    if (hit.seedOffsets[i] == -2147483647) continue;
                    if (prev == -1) {
                        prev = i;
                        continue;
                    }
                    if (this.matchScore + (float)Math.abs(hit.seedOffsets[i] - hit.seedOffsets[prev]) * this.offsetShiftPenalty + (float)(i - prev - 1) * this.mismatchPenalty <= 0.0f) {
                        hit.seedOffsets[prev] = -2147483647;
                        prev = i;
                        continue;
                    }
                    score -= (float)prev * this.mismatchPenalty;
                    break;
                }
            }
            if (this.floatingRightBound) {
                prev = -1;
                for (i = hit.seedOffsets.length - 1; i >= 0; --i) {
                    if (hit.seedOffsets[i] == -2147483647) continue;
                    if (prev == -1) {
                        prev = i;
                        continue;
                    }
                    if (this.matchScore + (float)Math.abs(hit.seedOffsets[i] - hit.seedOffsets[prev]) * this.offsetShiftPenalty + (float)(prev - 1 - i) * this.mismatchPenalty <= 0.0f) {
                        hit.seedOffsets[prev] = -2147483647;
                        prev = i;
                        continue;
                    }
                    score -= (float)(hit.seedOffsets.length - 1 - prev) * this.mismatchPenalty;
                }
            }
            c = -1;
            prev = -1;
            for (i = hit.seedOffsets.length - 1; i >= 0; --i) {
                if (hit.seedOffsets[i] == -2147483647) continue;
                int currentSeedPosition = seedPositions.get(i + hit.from) - hit.seedOffsets[i];
                if (c == -1) {
                    c = currentSeedPosition;
                    prev = i;
                    continue;
                }
                if (c <= currentSeedPosition) {
                    hit.seedOffsets[i] = -2147483647;
                    continue;
                }
                score += (float)Math.abs(hit.seedOffsets[i] - hit.seedOffsets[prev]) * this.offsetShiftPenalty;
                c = currentSeedPosition;
                prev = i;
            }
            hit.score = score;
            if (score < this.absoluteMinScore) {
                result.remove(j);
            }
            if (!(maxScore < (double)score)) continue;
            maxScore = score;
        }
        maxScore *= (double)this.relativeMinScore;
        for (j = result.size() - 1; j >= 0; --j) {
            hit = result.get(j);
            if (!((double)hit.score < maxScore)) continue;
            result.remove(j);
        }
        return new KMappingResult(seedPositions, result);
    }

    public int getKValue() {
        return this.kValue;
    }

    public float getAbsoluteMinScore() {
        return this.absoluteMinScore;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public int getMaxIndels() {
        return this.maxIndels;
    }

    public float getRelativeMinScore() {
        return this.relativeMinScore;
    }

    public SummaryStatistics getRecordSizeSummaryStatistics() {
        SummaryStatistics ss = new SummaryStatistics();
        for (int len : this.lengths) {
            ss.addValue((double)len);
        }
        return ss;
    }

    public String toString() {
        SummaryStatistics ss = this.getRecordSizeSummaryStatistics();
        return "K=" + this.kValue + "; Avr=" + ss.getMean() + "; SD=" + ss.getStandardDeviation();
    }

    private static class Info {
        int offset;
        int score;

        private Info() {
        }
    }
}

