/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner2;

import cc.redberry.primitives.Filter;
import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.AlignmentScoring;
import com.milaboratory.core.alignment.BandedAffineAligner;
import com.milaboratory.core.alignment.BandedSemiLocalResult;
import com.milaboratory.core.alignment.batch.BatchAlignerWithBaseWithFilter;
import com.milaboratory.core.alignment.kaligner2.KAligner2Statistics;
import com.milaboratory.core.alignment.kaligner2.KAlignerParameters2;
import com.milaboratory.core.alignment.kaligner2.KAlignmentHit2;
import com.milaboratory.core.alignment.kaligner2.KAlignmentResult2;
import com.milaboratory.core.alignment.kaligner2.KMapper2;
import com.milaboratory.core.alignment.kaligner2.KMappingHit2;
import com.milaboratory.core.alignment.kaligner2.KMappingResult2;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.util.BitArray;
import com.milaboratory.util.IntArrayList;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class KAligner2<P>
implements BatchAlignerWithBaseWithFilter<NucleotideSequence, P, KAlignmentHit2<P>> {
    final KMapper2 mapper;
    final KAlignerParameters2 parameters;
    final List<NucleotideSequence> sequences = new ArrayList<NucleotideSequence>();
    final TIntObjectHashMap<P> payloads = new TIntObjectHashMap();
    private final KAligner2Statistics stat;
    private static final Comparator<KAlignmentHit2> SCORE_COMPARATOR = new Comparator<KAlignmentHit2>(){

        @Override
        public int compare(KAlignmentHit2 o1, KAlignmentHit2 o2) {
            return Double.compare(o2.alignment.getScore(), o1.alignment.getScore());
        }
    };

    public KAligner2(KAlignerParameters2 parameters) {
        this(parameters, null);
    }

    public KAligner2(KAlignerParameters2 parameters, KAligner2Statistics stat) {
        this.parameters = parameters;
        this.mapper = KMapper2.createFromParameters(parameters, stat);
        this.stat = stat;
    }

    public int addReference(NucleotideSequence sequence) {
        if (sequence.containWildcards()) {
            throw new IllegalArgumentException("Reference sequences with wildcards not supported.");
        }
        int id = this.mapper.addReference(sequence);
        assert (this.sequences.size() == id);
        this.sequences.add(sequence);
        return id;
    }

    @Override
    public BitArray createFilter(Filter<P> filter) {
        BitArray ret = new BitArray(this.sequences.size());
        TIntObjectIterator it = this.payloads.iterator();
        while (it.hasNext()) {
            it.advance();
            if (!filter.accept(it.value())) continue;
            ret.set(it.key());
        }
        return ret;
    }

    public NucleotideSequence getReference(int id) {
        return this.sequences.get(id);
    }

    @Override
    public void addReference(NucleotideSequence sequence, P payload) {
        this.payloads.put(this.addReference(sequence), payload);
    }

    @Override
    public KAlignmentResult2<P> align(NucleotideSequence sequence) {
        return this.align(sequence, 0, sequence.size());
    }

    @Override
    public KAlignmentResult2<P> align(NucleotideSequence sequence, int from, int to) {
        return this.align(sequence, from, to, (BitArray)null);
    }

    @Override
    public KAlignmentResult2<P> align(NucleotideSequence query, int from, int to, BitArray filter) {
        int i;
        if (this.stat != null) {
            this.stat.nextQuery();
        }
        BandedAffineAligner.MatrixCache cache = new BandedAffineAligner.MatrixCache();
        AlignmentScoring scoring = this.parameters.getScoring();
        KMappingResult2 mapping = this.mapper.align(query, from, to, filter);
        IntArrayList seeds = mapping.seeds;
        KMapper2.ArrList hits = new KMapper2.ArrList();
        int maxIndels = this.parameters.getMapperMaxClusterIndels();
        int nValue = this.mapper.getNValue();
        boolean kIsZero = this.mapper.getKValue() == 0;
        int halfN = nValue / 2;
        int leftBoundaryOffset = kIsZero ? 0 : halfN;
        int rightBoundaryOffset = kIsZero ? nValue : halfN;
        int rightLeftDeltaBoundaryOffset = rightBoundaryOffset - leftBoundaryOffset;
        KAlignmentResult2 kAlignmentResult = new KAlignmentResult2(mapping, hits, query, from, to);
        if (mapping.getHits().isEmpty()) {
            if (this.stat != null) {
                this.stat.kAlignerResult(kAlignmentResult);
            }
            return kAlignmentResult;
        }
        for (int hitIndex = 0; hitIndex < mapping.getHits().size(); ++hitIndex) {
            int added2;
            int added1;
            int delta;
            int seedPosition1;
            KMappingHit2 mappingHit = mapping.getHits().get(hitIndex);
            NucleotideSequence target = this.sequences.get(mappingHit.id);
            MutationsBuilder<NucleotideSequence> mutations = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
            int seedPosition2 = seeds.get(mappingHit.indexById(0)) + leftBoundaryOffset;
            int length1 = seedPosition1 = seedPosition2 + mappingHit.offsetById(0);
            int length2 = seedPosition2 - from;
            assert (length2 >= 0);
            if (length1 >= length2) {
                delta = Math.min(length1 - length2, maxIndels);
                added1 = maxIndels + delta;
                added2 = maxIndels - delta;
                if (length1 > length2 + maxIndels) {
                    length1 = length2 + maxIndels;
                }
            } else {
                delta = Math.min(length2 - length1, maxIndels);
                added1 = maxIndels - delta;
                added2 = maxIndels + delta;
                if (length2 > length1 + maxIndels) {
                    length2 = length1 + maxIndels;
                }
            }
            int offset1 = seedPosition1 - length1;
            int offset2 = seedPosition2 - length2;
            BandedSemiLocalResult br = this.parameters.isFloatingLeftBound() ? BandedAffineAligner.semiLocalLeft0((AffineGapAlignmentScoring<NucleotideSequence>)this.parameters.getScoring(), target, query, offset1, length1, offset2, length2, maxIndels, mutations, cache) : BandedAffineAligner.semiGlobalLeft0((AffineGapAlignmentScoring<NucleotideSequence>)this.parameters.getScoring(), target, query, offset1, length1, added1, offset2, length2, added2, maxIndels, mutations, cache);
            int seq1From = br.sequence1Stop;
            int seq2From = br.sequence2Stop;
            int previousSeedPosition2 = seedPosition2 + rightLeftDeltaBoundaryOffset;
            int previousSeedPosition1 = seedPosition1 + rightLeftDeltaBoundaryOffset;
            for (int seedId = 1; seedId < mappingHit.seedRecords.length; ++seedId) {
                seedPosition2 = seeds.get(mappingHit.indexById(seedId)) + leftBoundaryOffset;
                seedPosition1 = seedPosition2 + mappingHit.offsetById(seedId);
                offset1 = previousSeedPosition1;
                length1 = seedPosition1 - offset1;
                offset2 = previousSeedPosition2;
                length2 = seedPosition2 - offset2;
                assert (!kIsZero || ((NucleotideSequence)target.getRange(offset1 - nValue, offset1)).equals(query.getRange(offset2 - nValue, offset2)));
                if (length2 < 0 || length1 < 0) continue;
                assert (length1 >= 0 && length2 >= 0);
                BandedAffineAligner.align0((AffineGapAlignmentScoring<NucleotideSequence>)scoring, target, query, offset1, length1, offset2, length2, maxIndels, mutations, cache);
                previousSeedPosition1 = seedPosition1 + rightLeftDeltaBoundaryOffset;
                previousSeedPosition2 = seedPosition2 + rightLeftDeltaBoundaryOffset;
            }
            offset2 = previousSeedPosition2;
            offset1 = previousSeedPosition1;
            length1 = target.size() - offset1;
            if (length1 >= (length2 = to - offset2)) {
                delta = Math.min(length1 - length2, maxIndels);
                added1 = maxIndels + delta;
                added2 = maxIndels - delta;
                if (length1 > length2 + maxIndels) {
                    length1 = length2 + maxIndels;
                }
            } else {
                delta = Math.min(length2 - length1, maxIndels);
                added1 = maxIndels - delta;
                added2 = maxIndels + delta;
                if (length2 > length1 + maxIndels) {
                    length2 = length1 + maxIndels;
                }
            }
            br = this.parameters.isFloatingRightBound() ? BandedAffineAligner.semiLocalRight0((AffineGapAlignmentScoring<NucleotideSequence>)this.parameters.getScoring(), target, query, offset1, length1, offset2, length2, maxIndels, mutations, cache) : BandedAffineAligner.semiGlobalRight0((AffineGapAlignmentScoring<NucleotideSequence>)this.parameters.getScoring(), target, query, offset1, length1, added1, offset2, length2, added2, maxIndels, mutations, cache);
            int seq1To = br.sequence1Stop + 1;
            int seq2To = br.sequence2Stop + 1;
            Mutations<NucleotideSequence> muts = mutations.createAndDestroy();
            hits.add(new KAlignmentHit2<Object>(kAlignmentResult, mappingHit.id, new Alignment<NucleotideSequence>(target, muts, new Range(seq1From, seq1To), new Range(seq2From, seq2To), this.parameters.getScoring()), this.payloads.get(mappingHit.id)));
        }
        Collections.sort(hits, SCORE_COMPARATOR);
        int threshold = (int)Math.max((float)this.parameters.getAbsoluteMinScore(), this.parameters.getRelativeMinScore() * ((KAlignmentHit2)hits.get(0)).getAlignment().getScore());
        for (i = 0; i < this.parameters.getMaxHits() && i < hits.size() && !(((KAlignmentHit2)hits.get(i)).getAlignment().getScore() < (float)threshold); ++i) {
        }
        if (i < hits.size()) {
            hits.removeRange(i, hits.size());
        }
        if (this.stat != null) {
            this.stat.kAlignerResult(kAlignmentResult);
        }
        return kAlignmentResult;
    }
}

