/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.milaboratory.core.alignment.kaligner2.KAlignmentResult2;
import com.milaboratory.core.alignment.kaligner2.KMappingResult2;
import com.milaboratory.util.AtomicEnumHistogram;
import com.milaboratory.util.AtomicHistogram;
import com.milaboratory.util.GlobalObjectMappers;
import com.milaboratory.util.IntArrayList;
import java.util.concurrent.atomic.AtomicLong;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public final class KAligner2Statistics {
    @JsonIgnore
    final ThreadLocal<State> currentState = new ThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State();
        }
    };
    public final AtomicLong inputQueries = new AtomicLong();
    public final AtomicHistogram allInitialRecordsCount = new AtomicHistogram(0, 300);
    public final AtomicHistogram topInitialRecordsCount = new AtomicHistogram(0, 300);
    public final AtomicHistogram allInitialClusters = new AtomicHistogram(0, 20);
    public final AtomicHistogram topInitialClusters = new AtomicHistogram(0, 20);
    public final AtomicHistogram allRemovedByTrimming = new AtomicHistogram(0, 20);
    public final AtomicHistogram topRemovedByTrimming = new AtomicHistogram(0, 20);
    public final AtomicHistogram allRemovedByUntangling = new AtomicHistogram(0, 20);
    public final AtomicHistogram topRemovedByUntangling = new AtomicHistogram(0, 20);
    public final AtomicHistogram allUntangledClusters = new AtomicHistogram(0, 20);
    public final AtomicHistogram topUntangledClusters = new AtomicHistogram(0, 20);
    public final AtomicEnumHistogram<ClusterTrimmingType> allTrimming = new AtomicEnumHistogram<ClusterTrimmingType>(ClusterTrimmingType.class);
    public final AtomicEnumHistogram<ClusterTrimmingType> topTrimming = new AtomicEnumHistogram<ClusterTrimmingType>(ClusterTrimmingType.class);
    public final AtomicLong rerun = new AtomicLong();
    public final AtomicLong changeOfTop1 = new AtomicLong();
    public final AtomicLong changeOfTop2 = new AtomicLong();
    public final AtomicHistogram numberOfMappingHits = new AtomicHistogram(0, 20);
    public final AtomicHistogram numberOfAlignmentsHits = new AtomicHistogram(0, 20);
    public final AtomicHistogram filteredHitsByAlignments = new AtomicHistogram(0, 50);
    public final AtomicHistogram seedExtractionTime = new AtomicHistogram(0.0, 10000.0, 400);
    public final AtomicHistogram hitCalculationTime = new AtomicHistogram(0.0, 10000.0, 400);
    public final AtomicHistogram mapperTotalTime = new AtomicHistogram(0.0, 10000.0, 400);
    public final AtomicHistogram alignerTime = new AtomicHistogram(0.0, 10000.0, 400);
    public final AtomicHistogram totalTime = new AtomicHistogram(0.0, 10000.0, 400);

    public void nextQuery() {
        State state = this.currentState.get();
        state.reset();
        this.inputQueries.incrementAndGet();
    }

    public void afterCandidatesArrayDone(IntArrayList[] candidates) {
        State state = this.currentState.get();
        state.previousStep = System.nanoTime();
        this.seedExtractionTime.add((double)(state.previousStep - state.start) / 1000.0);
        int top = -1;
        for (int i = 0; i < candidates.length; ++i) {
            IntArrayList candidate = candidates[i];
            if (candidate == null) {
                this.allInitialRecordsCount.add(0.0);
                continue;
            }
            this.allInitialRecordsCount.add(candidate.size());
            if (top != -1 && candidates[top].size() >= candidate.size()) continue;
            top = i;
        }
        state.topByRecordsCount = top;
        if (top == -1) {
            this.topInitialRecordsCount.add(0.0);
        } else {
            this.topInitialRecordsCount.add(candidates[top].size());
        }
    }

    public void initialClusters(int id, IntArrayList results) {
        int clusters;
        State state = this.currentState.get();
        state.currentTargetIndex = id;
        state.clusters = clusters = KAligner2Statistics.countClusters(results);
        this.allInitialClusters.add(clusters);
        if (state.isCurrentTop()) {
            this.topInitialClusters.add(clusters);
        }
    }

    public void trimmingEvent(ClusterTrimmingType type) {
        State state = this.currentState.get();
        this.allTrimming.add(type);
        if (state.isCurrentTop()) {
            this.topTrimming.add(type);
        }
    }

    public void afterTrimming(int id, IntArrayList results) {
        State state = this.currentState.get();
        assert (state.currentTargetIndex == id);
        int clusters = KAligner2Statistics.countClusters(results);
        this.allRemovedByTrimming.add(state.clusters - clusters);
        if (state.isCurrentTop()) {
            this.topRemovedByTrimming.add(state.clusters - clusters);
        }
        state.clusters = clusters;
    }

    public void afterUntangling(IntArrayList untangled) {
        State state = this.currentState.get();
        int clusters = untangled.size();
        this.allRemovedByUntangling.add(state.clusters - clusters);
        if (state.isCurrentTop()) {
            this.topRemovedByUntangling.add(state.clusters - clusters);
        }
        this.allUntangledClusters.add(clusters);
        if (state.isCurrentTop()) {
            this.topUntangledClusters.add(clusters);
        }
    }

    public void reRunBecauseOfMicroTangling() {
        this.rerun.incrementAndGet();
    }

    public void kMappingResults(KMappingResult2 result) {
        State state = this.currentState.get();
        long timestamp = System.nanoTime();
        this.hitCalculationTime.add((double)(timestamp - state.previousStep) / 1000.0);
        this.mapperTotalTime.add((double)(timestamp - state.start) / 1000.0);
        state.previousStep = timestamp;
        if (result.hits == null) {
            this.numberOfMappingHits.add(0.0);
            state.mappingHits = 0;
            return;
        }
        this.numberOfMappingHits.add(result.hits.size());
        state.mappingHits = result.hits.size();
        int top = result.hits.isEmpty() ? -1 : result.hits.get((int)0).id;
        if (top != state.topByRecordsCount) {
            this.changeOfTop1.incrementAndGet();
        }
        state.topByMappingScore = top;
    }

    public void kAlignerResult(KAlignmentResult2 result) {
        State state = this.currentState.get();
        long timestamp = System.nanoTime();
        this.alignerTime.add((double)(timestamp - state.previousStep) / 1000.0);
        this.totalTime.add((double)(timestamp - state.start) / 1000.0);
        int hits = result.getHits().size();
        this.numberOfAlignmentsHits.add(hits);
        this.filteredHitsByAlignments.add(state.mappingHits - hits);
    }

    public String toString() {
        try {
            return GlobalObjectMappers.toOneLine(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int countClusters(IntArrayList results) {
        int clusters = 0;
        for (int i = 0; i < results.size(); i += 3) {
            if (results.get(i + 0) == -274653) continue;
            ++clusters;
        }
        return clusters;
    }

    public static enum ClusterTrimmingType {
        TrimLeftQuery,
        TrimLeftTarget,
        TrimRightQuery,
        TrimRightTarget;

    }

    public static final class State {
        volatile int topByRecordsCount;
        volatile int topByMappingScore;
        volatile int currentTargetIndex;
        volatile int clusters;
        volatile int mappingHits;
        volatile long start;
        volatile long previousStep;

        public boolean isCurrentTop() {
            return this.topByRecordsCount == this.currentTargetIndex;
        }

        void reset() {
            this.topByRecordsCount = -1;
            this.currentTargetIndex = -1;
            this.start = System.nanoTime();
        }
    }
}

