/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.alignment.kaligner1.AbstractKAlignerParameters;
import com.milaboratory.core.alignment.kaligner2.KAligner2;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.util.GlobalObjectMappers;
import java.io.Serializable;

public final class KAlignerParameters2
implements AbstractKAlignerParameters,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int mapperNValue;
    private int mapperKValue;
    private boolean floatingLeftBound;
    private boolean floatingRightBound;
    private int mapperAbsoluteMinClusterScore;
    private int mapperExtraClusterScore;
    private int mapperMatchScore;
    private int mapperMismatchScore;
    private int mapperOffsetShiftScore;
    private int mapperSlotCount;
    private int mapperMaxClusters;
    private int mapperMaxClusterIndels;
    private int mapperKMersPerPosition;
    private int mapperAbsoluteMinScore;
    private float mapperRelativeMinScore;
    private int mapperMinSeedsDistance;
    private int mapperMaxSeedsDistance;
    private int alignmentStopPenalty;
    private int absoluteMinScore;
    private float relativeMinScore;
    private int maxHits;
    private AffineGapAlignmentScoring<NucleotideSequence> scoring;

    public KAlignerParameters2() {
    }

    public KAlignerParameters2(int mapperNValue, int mapperKValue, boolean floatingLeftBound, boolean floatingRightBound, int mapperAbsoluteMinClusterScore, int mapperExtraClusterScore, int mapperAbsoluteMinScore, float mapperRelativeMinScore, int mapperMatchScore, int mapperMismatchScore, int mapperOffsetShiftScore, int mapperMinSeedsDistance, int mapperMaxSeedsDistance, int mapperSlotCount, int mapperMaxClusters, int mapperMaxClusterIndels, int mapperKMersPerPosition, int alignmentStopPenalty, int absoluteMinScore, float relativeMinScore, int maxHits, AffineGapAlignmentScoring scoring) {
        if (scoring != null && !scoring.uniformBasicMatchScore()) {
            throw new IllegalArgumentException("Use scoring with common match score.");
        }
        this.mapperNValue = mapperNValue;
        this.mapperKValue = mapperKValue;
        this.floatingLeftBound = floatingLeftBound;
        this.floatingRightBound = floatingRightBound;
        this.mapperAbsoluteMinClusterScore = mapperAbsoluteMinClusterScore;
        this.mapperExtraClusterScore = mapperExtraClusterScore;
        this.mapperAbsoluteMinScore = mapperAbsoluteMinScore;
        this.mapperRelativeMinScore = mapperRelativeMinScore;
        this.mapperMatchScore = mapperMatchScore;
        this.mapperMismatchScore = mapperMismatchScore;
        this.mapperOffsetShiftScore = mapperOffsetShiftScore;
        this.mapperMinSeedsDistance = mapperMinSeedsDistance;
        this.mapperMaxSeedsDistance = mapperMaxSeedsDistance;
        this.mapperSlotCount = mapperSlotCount;
        this.mapperMaxClusters = mapperMaxClusters;
        this.mapperMaxClusterIndels = mapperMaxClusterIndels;
        this.mapperKMersPerPosition = mapperKMersPerPosition;
        this.alignmentStopPenalty = alignmentStopPenalty;
        this.absoluteMinScore = absoluteMinScore;
        this.relativeMinScore = relativeMinScore;
        this.maxHits = maxHits;
        this.scoring = scoring;
    }

    public <P> KAligner2<P> createAligner() {
        return new KAligner2(this);
    }

    public int getMapperNValue() {
        return this.mapperNValue;
    }

    public KAlignerParameters2 setMapperNValue(int kValue) {
        this.mapperNValue = kValue;
        return this;
    }

    public int getMapperKValue() {
        return this.mapperKValue;
    }

    public KAlignerParameters2 setMapperKValue(int mapperKValue) {
        this.mapperKValue = mapperKValue;
        return this;
    }

    public int getMapperAbsoluteMinClusterScore() {
        return this.mapperAbsoluteMinClusterScore;
    }

    public KAlignerParameters2 setMapperAbsoluteMinClusterScore(int mapperAbsoluteMinScore) {
        this.mapperAbsoluteMinClusterScore = mapperAbsoluteMinScore;
        return this;
    }

    public float getMapperRelativeMinScore() {
        return this.mapperRelativeMinScore;
    }

    public KAlignerParameters2 setMapperRelativeMinScore(float mapperRelativeMinScore) {
        this.mapperRelativeMinScore = mapperRelativeMinScore;
        return this;
    }

    public int getMapperMatchScore() {
        return this.mapperMatchScore;
    }

    public KAlignerParameters2 setMapperMatchScore(int mapperMatchScore) {
        this.mapperMatchScore = mapperMatchScore;
        return this;
    }

    public int getMapperMismatchScore() {
        return this.mapperMismatchScore;
    }

    public KAlignerParameters2 setMapperMismatchScore(int mapperMismatchScore) {
        this.mapperMismatchScore = mapperMismatchScore;
        return this;
    }

    public int getMapperOffsetShiftScore() {
        return this.mapperOffsetShiftScore;
    }

    public KAlignerParameters2 setMapperOffsetShiftScore(int mapperOffsetShiftScore) {
        this.mapperOffsetShiftScore = mapperOffsetShiftScore;
        return this;
    }

    public int getMapperExtraClusterScore() {
        return this.mapperExtraClusterScore;
    }

    public KAlignerParameters2 setMapperExtraClusterScore(int mapperExtraClusterScore) {
        this.mapperExtraClusterScore = mapperExtraClusterScore;
        return this;
    }

    public int getMapperMinSeedsDistance() {
        return this.mapperMinSeedsDistance;
    }

    public KAlignerParameters2 setMapperMinSeedsDistance(int mapperMinSeedsDistance) {
        this.mapperMinSeedsDistance = mapperMinSeedsDistance;
        return this;
    }

    public int getMapperMaxSeedsDistance() {
        return this.mapperMaxSeedsDistance;
    }

    public KAlignerParameters2 setMapperMaxSeedsDistance(int mapperMaxSeedsDistance) {
        this.mapperMaxSeedsDistance = mapperMaxSeedsDistance;
        return this;
    }

    public int getMapperSlotCount() {
        return this.mapperSlotCount;
    }

    public KAlignerParameters2 setMapperSlotCount(int mapperSlotCount) {
        this.mapperSlotCount = mapperSlotCount;
        return this;
    }

    public int getMapperMaxClusterIndels() {
        return this.mapperMaxClusterIndels;
    }

    public KAlignerParameters2 setMapperMaxClusterIndels(int mapperMaxClusterIndels) {
        this.mapperMaxClusterIndels = mapperMaxClusterIndels;
        return this;
    }

    public int getMapperKMersPerPosition() {
        return this.mapperKMersPerPosition;
    }

    public KAlignerParameters2 setMapperKMersPerPosition(int mapperKMersPerPosition) {
        this.mapperKMersPerPosition = mapperKMersPerPosition;
        return this;
    }

    public int getMapperMaxClusters() {
        return this.mapperMaxClusters;
    }

    public KAlignerParameters2 setMapperMaxClusters(int mapperMaxClusters) {
        this.mapperMaxClusters = mapperMaxClusters;
        return this;
    }

    public int getAlignmentStopPenalty() {
        return this.alignmentStopPenalty;
    }

    public KAlignerParameters2 setAlignmentStopPenalty(int alignmentStopPenalty) {
        this.alignmentStopPenalty = alignmentStopPenalty;
        return this;
    }

    public AffineGapAlignmentScoring<NucleotideSequence> getScoring() {
        return this.scoring;
    }

    public KAlignerParameters2 setScoring(AffineGapAlignmentScoring<NucleotideSequence> scoring) {
        if (scoring != null && !scoring.uniformBasicMatchScore()) {
            throw new IllegalArgumentException("Use scoring with common match score.");
        }
        this.scoring = scoring;
        return this;
    }

    @Override
    public boolean isFloatingLeftBound() {
        return this.floatingLeftBound;
    }

    public KAlignerParameters2 setFloatingLeftBound(boolean floatingLeftBound) {
        this.floatingLeftBound = floatingLeftBound;
        return this;
    }

    @Override
    public boolean isFloatingRightBound() {
        return this.floatingRightBound;
    }

    public KAlignerParameters2 setFloatingRightBound(boolean floatingRightBound) {
        this.floatingRightBound = floatingRightBound;
        return this;
    }

    public int getMapperAbsoluteMinScore() {
        return this.mapperAbsoluteMinScore;
    }

    public KAlignerParameters2 setMapperAbsoluteMinScore(int mapperAbsoluteMinScore) {
        this.mapperAbsoluteMinScore = mapperAbsoluteMinScore;
        return this;
    }

    public int getAbsoluteMinScore() {
        return this.absoluteMinScore;
    }

    public KAlignerParameters2 setAbsoluteMinScore(int absoluteMinScore) {
        this.absoluteMinScore = absoluteMinScore;
        return this;
    }

    @Override
    public float getRelativeMinScore() {
        return this.relativeMinScore;
    }

    public KAlignerParameters2 setRelativeMinScore(float relativeMinScore) {
        this.relativeMinScore = relativeMinScore;
        return this;
    }

    @Override
    public int getMaxHits() {
        return this.maxHits;
    }

    public KAlignerParameters2 setMaxHits(int maxHits) {
        this.maxHits = maxHits;
        return this;
    }

    @Override
    public KAlignerParameters2 clone() {
        try {
            KAlignerParameters2 c = (KAlignerParameters2)super.clone();
            if (this.scoring != null) {
                c.setScoring(this.scoring);
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KAlignerParameters2 that = (KAlignerParameters2)o;
        if (this.mapperNValue != that.mapperNValue) {
            return false;
        }
        if (this.floatingLeftBound != that.floatingLeftBound) {
            return false;
        }
        if (this.floatingRightBound != that.floatingRightBound) {
            return false;
        }
        if (this.mapperAbsoluteMinClusterScore != that.mapperAbsoluteMinClusterScore) {
            return false;
        }
        if (this.mapperExtraClusterScore != that.mapperExtraClusterScore) {
            return false;
        }
        if (this.mapperMatchScore != that.mapperMatchScore) {
            return false;
        }
        if (this.mapperMismatchScore != that.mapperMismatchScore) {
            return false;
        }
        if (this.mapperOffsetShiftScore != that.mapperOffsetShiftScore) {
            return false;
        }
        if (this.mapperSlotCount != that.mapperSlotCount) {
            return false;
        }
        if (this.mapperMaxClusterIndels != that.mapperMaxClusterIndels) {
            return false;
        }
        if (this.mapperAbsoluteMinScore != that.mapperAbsoluteMinScore) {
            return false;
        }
        if (Float.compare(that.mapperRelativeMinScore, this.mapperRelativeMinScore) != 0) {
            return false;
        }
        if (this.mapperMinSeedsDistance != that.mapperMinSeedsDistance) {
            return false;
        }
        if (this.mapperMaxSeedsDistance != that.mapperMaxSeedsDistance) {
            return false;
        }
        if (this.alignmentStopPenalty != that.alignmentStopPenalty) {
            return false;
        }
        if (this.absoluteMinScore != that.absoluteMinScore) {
            return false;
        }
        if (Float.compare(that.relativeMinScore, this.relativeMinScore) != 0) {
            return false;
        }
        if (this.maxHits != that.maxHits) {
            return false;
        }
        return !(this.scoring == null ? that.scoring != null : !this.scoring.equals(that.scoring));
    }

    public int hashCode() {
        int result = this.mapperNValue;
        result = 31 * result + (this.floatingLeftBound ? 1 : 0);
        result = 31 * result + (this.floatingRightBound ? 1 : 0);
        result = 31 * result + this.mapperAbsoluteMinClusterScore;
        result = 31 * result + this.mapperExtraClusterScore;
        result = 31 * result + this.mapperMatchScore;
        result = 31 * result + this.mapperMismatchScore;
        result = 31 * result + this.mapperOffsetShiftScore;
        result = 31 * result + this.mapperSlotCount;
        result = 31 * result + this.mapperMaxClusterIndels;
        result = 31 * result + this.mapperAbsoluteMinScore;
        result = 31 * result + (this.mapperRelativeMinScore != 0.0f ? Float.floatToIntBits(this.mapperRelativeMinScore) : 0);
        result = 31 * result + this.mapperMinSeedsDistance;
        result = 31 * result + this.mapperMaxSeedsDistance;
        result = 31 * result + this.alignmentStopPenalty;
        result = 31 * result + this.absoluteMinScore;
        result = 31 * result + (this.relativeMinScore != 0.0f ? Float.floatToIntBits(this.relativeMinScore) : 0);
        result = 31 * result + this.maxHits;
        result = 31 * result + (this.scoring != null ? this.scoring.hashCode() : 0);
        return result;
    }

    public String toString() {
        try {
            return "KAlignerParameters" + GlobalObjectMappers.PRETTY.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "Error...";
        }
    }
}

