/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner2;

import cc.redberry.pipe.CUtils;
import cc.redberry.pipe.OutputPort;
import com.milaboratory.core.alignment.kaligner2.KAligner2Statistics;
import com.milaboratory.core.alignment.kaligner2.KAlignerParameters2;
import com.milaboratory.core.alignment.kaligner2.KMappingHit2;
import com.milaboratory.core.alignment.kaligner2.KMappingResult2;
import com.milaboratory.core.alignment.kaligner2.OffsetPacksAccumulator;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.util.BitArray;
import com.milaboratory.util.IntArrayList;
import com.milaboratory.util.IntCombinations;
import com.milaboratory.util.RandomUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public final class KMapper2
implements Serializable {
    public static final int SEED_NOT_FOUND_OFFSET = -2147483647;
    private static final int bitsForIndex = 13;
    private static final int indexMask = 8191;
    private static final int offsetMask = 524287;
    private final int nValue;
    private final int kValue;
    private final int kMersPerPosition;
    private final int[][][] base;
    private final int[][] lengths;
    private final int absoluteMinClusterScore;
    private final int extraClusterScore;
    private final int matchScore;
    private final int mismatchScore;
    private final int offsetShiftScore;
    private final int slotCount;
    private final int maxClusterIndels;
    private final int maxClusters;
    private final int absoluteMinScore;
    private final float relativeMinScore;
    private final boolean floatingLeftBound;
    private final boolean floatingRightBound;
    private final int minDistance;
    private final int maxDistance;
    private volatile boolean built = false;
    private int maxReferenceLength = 0;
    private int minReferenceLength = Integer.MAX_VALUE;
    private int sequencesInBase = 0;
    private BitArray allFilter;
    final ThreadLocal<ThreadLocalCache> memoryCache = new ThreadLocal<ThreadLocalCache>(){

        @Override
        protected ThreadLocalCache initialValue() {
            return new ThreadLocalCache(KMapper2.this.sequencesInBase, KMapper2.this.slotCount, KMapper2.this.maxClusterIndels, KMapper2.this.matchScore, KMapper2.this.mismatchScore, KMapper2.this.offsetShiftScore, KMapper2.this.absoluteMinClusterScore);
        }
    };
    private final KAligner2Statistics stat;
    private static final Comparator<KMappingHit2> SCORE_COMPARATOR = new Comparator<KMappingHit2>(){

        @Override
        public int compare(KMappingHit2 o1, KMappingHit2 o2) {
            return Integer.compare(o2.score, o1.score);
        }
    };

    public KMapper2(int nValue, int kValue, int minDistance, int maxDistance, int absoluteMinClusterScore, int extraClusterScore, int absoluteMinScore, float relativeMinScore, int matchScore, int mismatchScore, int offsetShiftScore, int slotCount, int maxClusters, int maxClusterIndels, int kMersPerPosition, boolean floatingLeftBound, boolean floatingRightBound) {
        this(nValue, kValue, minDistance, maxDistance, absoluteMinClusterScore, extraClusterScore, absoluteMinScore, relativeMinScore, matchScore, mismatchScore, offsetShiftScore, slotCount, maxClusters, maxClusterIndels, kMersPerPosition, floatingLeftBound, floatingRightBound, null);
    }

    public KMapper2(int nValue, int kValue, int minDistance, int maxDistance, int absoluteMinClusterScore, int extraClusterScore, int absoluteMinScore, float relativeMinScore, int matchScore, int mismatchScore, int offsetShiftScore, int slotCount, int maxClusters, int maxClusterIndels, int kMersPerPosition, boolean floatingLeftBound, boolean floatingRightBound, KAligner2Statistics stat) {
        if (nValue - kValue <= 2) {
            throw new IllegalArgumentException("Wrong combination of K and N values. K = " + kValue + " N = " + nValue + ".");
        }
        this.nValue = nValue;
        this.kValue = kValue;
        int maxHolesMask = kValue == 0 ? 1 : (-1 >>> 32 - kValue << nValue - kValue) + 1;
        this.base = new int[maxHolesMask][][];
        this.lengths = new int[maxHolesMask][];
        if (kValue == 0 && kMersPerPosition != 1 || kValue != 0 && kMersPerPosition > nValue / kValue) {
            throw new IllegalArgumentException("Wrong combination of nValue, kValue and kMersPerPosition.");
        }
        this.kMersPerPosition = kMersPerPosition;
        IntCombinations combinations = new IntCombinations(nValue, kValue);
        for (int[] combination : CUtils.it((OutputPort)combinations)) {
            int holesMask = KMapper2.getCombinationMask(combination);
            this.base[holesMask] = new int[1 << (nValue - kValue) * 2][];
            this.lengths[holesMask] = new int[1 << (nValue - kValue) * 2];
        }
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.absoluteMinClusterScore = absoluteMinClusterScore;
        this.extraClusterScore = extraClusterScore;
        this.absoluteMinScore = absoluteMinScore;
        this.relativeMinScore = relativeMinScore;
        this.matchScore = matchScore;
        this.mismatchScore = mismatchScore;
        this.offsetShiftScore = offsetShiftScore;
        this.slotCount = slotCount;
        this.maxClusters = maxClusters;
        this.maxClusterIndels = maxClusterIndels;
        this.floatingLeftBound = floatingLeftBound;
        this.floatingRightBound = floatingRightBound;
        this.stat = stat;
    }

    public static KMapper2 createFromParameters(KAlignerParameters2 parameters) {
        return KMapper2.createFromParameters(parameters, null);
    }

    public static KMapper2 createFromParameters(KAlignerParameters2 parameters, KAligner2Statistics stat) {
        return new KMapper2(parameters.getMapperNValue(), parameters.getMapperKValue(), parameters.getMapperMinSeedsDistance(), parameters.getMapperMaxSeedsDistance(), parameters.getMapperAbsoluteMinClusterScore(), parameters.getMapperExtraClusterScore(), parameters.getMapperAbsoluteMinScore(), parameters.getMapperRelativeMinScore(), parameters.getMapperMatchScore(), parameters.getMapperMismatchScore(), parameters.getMapperOffsetShiftScore(), parameters.getMapperSlotCount(), parameters.getMapperMaxClusters(), parameters.getMapperMaxClusterIndels(), parameters.getMapperKMersPerPosition(), parameters.isFloatingLeftBound(), parameters.isFloatingRightBound(), stat);
    }

    private void addKmer(int holesMask, int kmer, int id, int offset) {
        if (this.base[holesMask][kmer] == null) {
            this.base[holesMask][kmer] = new int[10];
        } else if (this.base[holesMask][kmer].length == this.lengths[holesMask][kmer]) {
            this.base[holesMask][kmer] = Arrays.copyOf(this.base[holesMask][kmer], this.base[holesMask][kmer].length * 3 / 2 + 1);
        }
        if ((offset & 0x7FFFF) != offset) {
            throw new IllegalArgumentException("Record is too long.");
        }
        assert (this.lengths[holesMask][kmer] == 0 || KMapper2.index(this.base[holesMask][kmer][this.lengths[holesMask][kmer] - 1]) != id || KMapper2.offset(this.base[holesMask][kmer][this.lengths[holesMask][kmer] - 1]) < offset);
        int[] nArray = this.lengths[holesMask];
        int n = kmer;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        this.base[holesMask][kmer][n2] = KMapper2.record(offset, id);
    }

    public int addReference(NucleotideSequence sequence) {
        if (this.built) {
            throw new IllegalStateException("Already in use.");
        }
        if (this.sequencesInBase >= 8192) {
            throw new IllegalArgumentException("Maximum number of records reached.");
        }
        this.built = false;
        int id = this.sequencesInBase++;
        this.maxReferenceLength = Math.max(this.maxReferenceLength, sequence.size());
        this.minReferenceLength = Math.min(this.minReferenceLength, sequence.size());
        int tMask = -1 >>> 34 - this.nValue * 2;
        int to = sequence.size() - this.nValue;
        IntCombinations combinations = new IntCombinations(this.nValue, this.kValue);
        for (int[] combination : CUtils.it((OutputPort)combinations)) {
            int holesMask = KMapper2.getCombinationMask(combination);
            int kmer = 0;
            for (int j = 0; j < this.nValue; ++j) {
                if ((holesMask >> j & 1) != 0) continue;
                kmer = kmer << 2 | sequence.codeAt(j);
            }
            this.addKmer(holesMask, kmer, id, 0);
            for (int i = 1; i <= to; ++i) {
                kmer = 0;
                for (int j = 0; j < this.nValue; ++j) {
                    if ((holesMask >> j & 1) != 0) continue;
                    kmer = kmer << 2 | sequence.codeAt(i + j);
                }
                this.addKmer(holesMask, kmer, id, i);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureBuilt() {
        if (!this.built) {
            KMapper2 kMapper2 = this;
            synchronized (kMapper2) {
                if (!this.built) {
                    int[] zero = new int[]{};
                    IntCombinations combinations = new IntCombinations(this.nValue, this.kValue);
                    for (int[] combination : CUtils.it((OutputPort)combinations)) {
                        int holeMask = KMapper2.getCombinationMask(combination);
                        for (int kMer = 0; kMer < this.base[holeMask].length; ++kMer) {
                            if (this.base[holeMask][kMer] != null) {
                                this.base[holeMask][kMer] = Arrays.copyOf(this.base[holeMask][kMer], this.lengths[holeMask][kMer]);
                                Arrays.sort(this.base[holeMask][kMer]);
                                continue;
                            }
                            this.base[holeMask][kMer] = zero;
                        }
                    }
                    this.allFilter = new BitArray(this.sequencesInBase);
                    this.allFilter.setAll();
                    this.built = true;
                }
            }
        }
    }

    public KMappingResult2 align(NucleotideSequence sequence) {
        return this.align(sequence, 0, sequence.size());
    }

    public KMappingResult2 align(NucleotideSequence sequence, int from, int to) {
        return this.align(sequence, from, to, null);
    }

    public KMappingResult2 align(NucleotideSequence sequence, int from, int to, BitArray filter) {
        this.ensureBuilt();
        if (filter == null) {
            filter = this.allFilter;
        }
        ThreadLocalCache cache = this.memoryCache.get();
        cache.reset();
        ArrList<KMappingHit2> result = new ArrList<KMappingHit2>();
        if (to - from <= this.nValue) {
            KMappingResult2 kMappingResult2 = new KMappingResult2(null, result);
            if (this.stat != null) {
                this.stat.kMappingResults(kMappingResult2);
            }
            return kMappingResult2;
        }
        IntArrayList seedPositions = cache.seedPositions;
        int seedPosition = from;
        seedPositions.add(seedPosition);
        Well19937c random = RandomUtil.getThreadLocalRandom();
        while ((seedPosition += random.nextInt(this.maxDistance + 1 - this.minDistance) + this.minDistance) < to - this.nValue) {
            seedPositions.add(seedPosition);
        }
        seedPositions.add(to - this.nValue);
        IntArrayList[] candidates = cache.candidates;
        IntArrayList allRecords = cache.cachedIntArray1;
        int allPositionsMask = -1 >>> 32 - this.nValue;
        int nValue2 = this.nValue / 2;
        for (int i = 0; i < seedPositions.size(); ++i) {
            allRecords.clear();
            int notForbidden = allPositionsMask;
            for (int holesMaskIter = 0; holesMaskIter < this.kMersPerPosition; ++holesMaskIter) {
                int holesMask;
                if (nValue2 <= Integer.bitCount(notForbidden)) {
                    holesMask = 0;
                    while (Integer.bitCount(holesMask) != this.kValue) {
                        holesMask |= 1 << random.nextInt(this.nValue);
                        holesMask &= notForbidden;
                    }
                } else {
                    holesMask = notForbidden;
                    while (Integer.bitCount(holesMask) != this.kValue) {
                        holesMask &= ~(1 << random.nextInt(this.nValue));
                    }
                }
                notForbidden &= ~holesMask;
                int kmer = 0;
                for (int j = 0; j < this.nValue; ++j) {
                    if ((holesMask >> j & 1) != 0) continue;
                    kmer = kmer << 2 | sequence.codeAt(seedPositions.get(i) + j);
                }
                allRecords.addAll(this.base[holesMask][kmer]);
            }
            allRecords.sort();
            for (int i1 = 0; i1 < allRecords.size(); ++i1) {
                int id;
                int record = allRecords.get(i1);
                if (i1 > 0 && record == allRecords.get(i1 - 1) || !filter.get(id = KMapper2.index(record))) continue;
                int positionInTarget = KMapper2.offset(record);
                assert (candidates[id].isEmpty() || KMapper2.index(candidates[id].last()) != i || KMapper2.offset(candidates[id].last()) < positionInTarget - seedPositions.get(i));
                candidates[id].add(KMapper2.record(positionInTarget - seedPositions.get(i), i));
            }
        }
        if (this.stat != null) {
            this.stat.afterCandidatesArrayDone(candidates);
        }
        int possibleMinKmers = (int)Math.ceil(this.absoluteMinClusterScore / this.matchScore);
        for (int i = 0; i < candidates.length; ++i) {
            KMappingHit2 e;
            if (candidates[i] == null || candidates[i].size() - 1 < possibleMinKmers || (e = this.calculateHit(i, candidates[i], seedPositions)) == null) continue;
            result.add(e);
        }
        Collections.sort(result, SCORE_COMPARATOR);
        if (!result.isEmpty()) {
            int i;
            int threshold = Math.max((int)((float)((KMappingHit2)result.get((int)0)).score * this.relativeMinScore), this.absoluteMinScore);
            for (i = 0; i < result.size() && ((KMappingHit2)result.get((int)i)).score > threshold; ++i) {
            }
            result.removeRange(i, result.size());
        }
        KMappingResult2 kMappingResult2 = new KMappingResult2(seedPositions, result);
        if (this.stat != null) {
            this.stat.kMappingResults(kMappingResult2);
        }
        return kMappingResult2;
    }

    public KMappingHit2 calculateHit(int id, IntArrayList data, IntArrayList seedPositions) {
        return this.calculateHit(id, IntArrayList.getArrayReference(data), 0, data.size(), seedPositions);
    }

    private boolean truncateClusterFromRight(boolean byIndex, IntArrayList seedPositions, IntArrayList results, int[] data, int dataTo, int clusterPointer, int truncationPoint) {
        if (this.stat != null) {
            this.stat.trimmingEvent(byIndex ? KAligner2Statistics.ClusterTrimmingType.TrimRightQuery : KAligner2Statistics.ClusterTrimmingType.TrimRightTarget);
        }
        int recordId = results.get(clusterPointer + 0);
        int lastRecordId = results.get(clusterPointer + 1);
        int record = data[recordId];
        int prevOffset = KMapper2.offset(record);
        int prevIndex = KMapper2.index(record);
        int score = this.matchScore;
        assert (lastRecordId < dataTo);
        int i = recordId;
        while (++i <= lastRecordId && prevIndex == KMapper2.index(data[i])) {
        }
        while (!(i > lastRecordId || byIndex && KMapper2.index(data[i]) >= truncationPoint)) {
            int index = KMapper2.index(data[i]);
            int offset = KMapper2.offset(data[i]);
            if (KMapper2.inDelta(prevOffset, offset, this.maxClusterIndels) && (i >= lastRecordId || index != KMapper2.index(data[i + 1]) || Math.abs(prevOffset - offset) <= Math.abs(prevOffset - KMapper2.offset(data[i + 1])))) {
                assert (index - prevIndex - 1 >= 0);
                if (!byIndex && KMapper2.positionInTarget(seedPositions, data[i]) >= truncationPoint) break;
                int scoreDelta = this.matchScore + (index - prevIndex - 1) * this.mismatchScore + Math.abs(prevOffset - offset) * this.offsetShiftScore;
                if (scoreDelta > 0) {
                    score += scoreDelta;
                    prevOffset = offset;
                    prevIndex = index;
                    recordId = i;
                }
                while (++i <= lastRecordId && prevIndex == KMapper2.index(data[i])) {
                }
            }
            ++i;
        }
        results.set(clusterPointer + 1, recordId);
        results.set(clusterPointer + 2, score);
        if (score < this.absoluteMinClusterScore) {
            results.set(clusterPointer + 0, -274653);
            return false;
        }
        return true;
    }

    private boolean truncateClusterFromLeft(boolean byIndex, IntArrayList seedPositions, IntArrayList results, int[] data, int dataFrom, int clusterPointer, int truncationPoint) {
        if (this.stat != null) {
            this.stat.trimmingEvent(byIndex ? KAligner2Statistics.ClusterTrimmingType.TrimLeftQuery : KAligner2Statistics.ClusterTrimmingType.TrimLeftTarget);
        }
        int firstRecordId = results.get(clusterPointer + 0);
        int recordId = results.get(clusterPointer + 1);
        int record = data[recordId];
        int prevOffset = KMapper2.offset(record);
        int prevIndex = KMapper2.index(record);
        int score = this.matchScore;
        assert (firstRecordId >= dataFrom);
        int i = recordId;
        while (--i >= firstRecordId && prevIndex == KMapper2.index(data[i])) {
        }
        while (!(i < firstRecordId || byIndex && KMapper2.index(data[i]) <= truncationPoint)) {
            int index = KMapper2.index(data[i]);
            int offset = KMapper2.offset(data[i]);
            if (KMapper2.inDelta(prevOffset, offset, this.maxClusterIndels) && (i <= firstRecordId || index != KMapper2.index(data[i - 1]) || Math.abs(prevOffset - offset) <= Math.abs(prevOffset - KMapper2.offset(data[i - 1])))) {
                assert (prevIndex - index - 1 >= 0);
                if (!byIndex && KMapper2.positionInTarget(seedPositions, data[i]) <= truncationPoint) break;
                int scoreDelta = this.matchScore + (prevIndex - index - 1) * this.mismatchScore + Math.abs(prevOffset - offset) * this.offsetShiftScore;
                if (scoreDelta > 0) {
                    score += scoreDelta;
                    prevOffset = offset;
                    prevIndex = index;
                    recordId = i;
                }
                while (--i >= firstRecordId && prevIndex == KMapper2.index(data[i])) {
                }
            }
            --i;
        }
        results.set(clusterPointer + 0, recordId);
        results.set(clusterPointer + 2, score);
        if (score < this.absoluteMinClusterScore) {
            results.set(clusterPointer + 0, -274653);
            return false;
        }
        return true;
    }

    private KMappingHit2 calculateHit(int id, int[] data, int dataFrom, int dataTo, IntArrayList seedPositions) {
        int pointer;
        int i;
        ThreadLocalCache cache = this.memoryCache.get();
        OffsetPacksAccumulator accumulator = cache.offsetPacksAccumulator;
        accumulator.calculateInitialPartitioning(data, dataFrom, dataTo);
        IntArrayList results = accumulator.results;
        if (accumulator.results.size() == 0 || accumulator.totalScore < this.absoluteMinScore) {
            return null;
        }
        if (this.stat != null) {
            this.stat.initialClusters(id, results);
        }
        for (int i2 = 0; i2 < results.size(); i2 += 3) {
            if (results.get(i2 + 0) == -274653) continue;
            for (int j = i2 + 3; j < results.size() && results.get(i2 + 0) != -274653; j += 3) {
                if (results.get(j + 0) == -274653) continue;
                int a = i2;
                int b = j;
                int aStartIndex = KMapper2.index(data[results.get(a + 0)]);
                int aEndIndex = KMapper2.index(data[results.get(a + 1)]);
                int bStartIndex = KMapper2.index(data[results.get(b + 0)]);
                int bEndIndex = KMapper2.index(data[results.get(b + 1)]);
                if (aStartIndex > bStartIndex) {
                    aStartIndex ^= bStartIndex;
                    bStartIndex ^= aStartIndex;
                    aStartIndex ^= bStartIndex;
                    aEndIndex ^= bEndIndex;
                    bEndIndex ^= aEndIndex;
                    aEndIndex ^= bEndIndex;
                    a ^= b;
                    b ^= a;
                    a ^= b;
                }
                if (aEndIndex >= bStartIndex) {
                    if (bEndIndex <= aEndIndex) {
                        if (results.get(a + 2) < results.get(b + 2)) {
                            results.set(a + 0, -274653);
                            continue;
                        }
                        results.set(b + 0, -274653);
                        continue;
                    }
                    if (results.get(a + 2) < results.get(b + 2) ? !this.truncateClusterFromRight(true, null, results, data, dataTo, a, bStartIndex) : !this.truncateClusterFromLeft(true, null, results, data, dataFrom, b, aEndIndex)) continue;
                }
                a = i2;
                b = j;
                int aStart = KMapper2.positionInTarget(seedPositions, data[results.get(a + 0)]);
                int aEnd = KMapper2.positionInTarget(seedPositions, data[results.get(a + 1)]);
                int bStart = KMapper2.positionInTarget(seedPositions, data[results.get(b + 0)]);
                int bEnd = KMapper2.positionInTarget(seedPositions, data[results.get(b + 1)]);
                if (aStart > bStart) {
                    aStart ^= bStart;
                    bStart ^= aStart;
                    aStart ^= bStart;
                    aEnd ^= bEnd;
                    bEnd ^= aEnd;
                    aEnd ^= bEnd;
                    a ^= b;
                    b ^= a;
                    a ^= b;
                }
                if (aEnd < bStart) continue;
                if (bEnd <= aEnd) {
                    if (results.get(a + 2) < results.get(b + 2)) {
                        results.set(a + 0, -274653);
                        continue;
                    }
                    results.set(b + 0, -274653);
                    continue;
                }
                if (results.get(a + 2) < results.get(b + 2)) {
                    this.truncateClusterFromRight(false, seedPositions, results, data, dataTo, a, bStart);
                    continue;
                }
                this.truncateClusterFromLeft(false, seedPositions, results, data, dataFrom, b, aEnd);
            }
        }
        if (this.stat != null) {
            this.stat.afterTrimming(id, results);
        }
        int bestScore = 0;
        int numberOfClusters = results.size() / 3;
        for (int i3 = 0; i3 < results.size(); i3 += 3) {
            if (results.get(i3 + 0) != -274653 && !KMapper2.crosses(seedPositions, data, results.get(i3 + 0), results.get(i3 + 1))) continue;
            --numberOfClusters;
            results.set(i3 + 0, -274653);
            results.set(i3 + 2, Integer.MIN_VALUE);
        }
        if (numberOfClusters == 0) {
            return null;
        }
        long[] forPreFiltering = new long[numberOfClusters];
        int j = 0;
        for (int i4 = 0; i4 < results.size(); i4 += 3) {
            if (results.get(i4 + 0) == -274653) continue;
            forPreFiltering[j++] = (long)i4 | (long)(-results.get(i4 + 2)) << 33;
        }
        assert (j == numberOfClusters);
        Arrays.sort(forPreFiltering);
        numberOfClusters = Math.min(numberOfClusters, this.maxClusters);
        IntArrayList untangled = cache.cachedIntArray1;
        IntArrayList current = cache.cachedIntArray2;
        untangled.clear();
        current.clear();
        long size = 1L << numberOfClusters;
        block4: for (long it = 0L; it < size; ++it) {
            current.clear();
            int currentScore = 0;
            for (int ai = numberOfClusters - 1; ai >= 0; --ai) {
                int a = (int)forPreFiltering[ai];
                if ((it >> ai & 1L) != 1L) continue;
                if (results.get(a + 0) == -274653) {
                    it += (long)((1 << ai) - 1);
                    continue block4;
                }
                for (int i5 = 0; i5 < current.size(); ++i5) {
                    int b = current.get(i5);
                    if (results.get(b + 0) == -274653 || !KMapper2.crosses(seedPositions, data, results.get(a + 0), results.get(b + 0)) && !KMapper2.crosses(seedPositions, data, results.get(a + 1), results.get(b + 1))) continue;
                    assert (KMapper2.crosses(seedPositions, data, results.get(a + 0), results.get(b + 1)) || KMapper2.crosses(seedPositions, data, results.get(a + 1), results.get(b + 0)));
                    continue block4;
                }
                current.add(a);
                currentScore += results.get(a + 2);
            }
            if (bestScore >= currentScore) continue;
            untangled.copyFrom(current);
            bestScore = currentScore;
        }
        current.clear();
        IntArrayList seedRecords = current;
        IntArrayList packBoundaries = cache.cachedIntArray3;
        packBoundaries.clear();
        int score = 0;
        if (this.stat != null) {
            this.stat.afterUntangling(untangled);
        }
        long[] untangledForSort = new long[untangled.size()];
        for (i = 0; i < untangled.size(); ++i) {
            pointer = untangled.get(i);
            untangledForSort[i] = (long)pointer | (long)KMapper2.index(data[results.get(pointer + 0)]) << 32;
        }
        Arrays.sort(untangledForSort);
        for (i = 0; i < untangledForSort.length; ++i) {
            int index;
            pointer = (int)untangledForSort[i];
            if (i != 0) {
                packBoundaries.add(seedRecords.size());
                score += this.extraClusterScore;
            }
            int recordId = results.get(pointer + 0);
            assert (recordId >= dataFrom);
            int lastRecordId = results.get(pointer + 1);
            assert (lastRecordId < dataTo);
            int clusterScore = this.matchScore;
            int record = data[recordId];
            int previousIndex = index = KMapper2.index(record);
            seedRecords.add(record);
            int previousOffset = KMapper2.offset(record);
            while (++recordId < dataTo && KMapper2.index(data[recordId]) == index) {
            }
            --recordId;
            while (++recordId <= lastRecordId) {
                record = data[recordId];
                index = KMapper2.index(record);
                int offset = KMapper2.offset(record);
                int minRecord = record;
                int minDelta = Math.abs(offset - previousOffset);
                if (minDelta > this.maxClusterIndels) continue;
                boolean $ = false;
                while (recordId < lastRecordId && KMapper2.index(record = data[recordId + 1]) == index) {
                    ++recordId;
                    int delta = Math.abs(KMapper2.offset(record) - previousOffset);
                    if (delta >= minDelta) continue;
                    minDelta = delta;
                    minRecord = record;
                    $ = true;
                }
                if ($) {
                    offset = KMapper2.offset(minRecord);
                }
                if (KMapper2.positionInTarget(seedPositions, minRecord) <= KMapper2.positionInTarget(seedPositions, seedRecords.last())) {
                    int minRecordId = recordId + 1;
                    while (data[--minRecordId] != minRecord) {
                    }
                    System.arraycopy(data, minRecordId + 1, data, minRecordId, dataTo - minRecordId - 1);
                    if (this.stat != null) {
                        this.stat.reRunBecauseOfMicroTangling();
                    }
                    return this.calculateHit(id, data, dataFrom, dataTo - 1, seedPositions);
                }
                int scoreDelta = this.matchScore + (index - previousIndex - 1) * this.mismatchScore + minDelta * this.offsetShiftScore;
                if (scoreDelta <= 0) continue;
                clusterScore += scoreDelta;
                seedRecords.add(minRecord);
                previousIndex = index;
                previousOffset = offset;
            }
            clusterScore = Math.max(clusterScore, results.get(pointer + 2));
            score += clusterScore;
        }
        if (this.floatingLeftBound) {
            score -= KMapper2.index(seedRecords.get(0)) * this.mismatchScore;
        }
        if (this.floatingRightBound) {
            score -= (seedPositions.size() - 1 - KMapper2.index(seedRecords.last())) * this.mismatchScore;
        }
        if (score < this.absoluteMinScore) {
            return null;
        }
        return new KMappingHit2(id, seedRecords.toArray(), packBoundaries.toArray(), score);
    }

    private static boolean crosses(IntArrayList seedPositions, int[] data, int a, int b) {
        return KMapper2.index(data[a]) < KMapper2.index(data[b]) ^ KMapper2.positionInTarget(seedPositions, data[a]) < KMapper2.positionInTarget(seedPositions, data[b]);
    }

    public static int positionInTarget(IntArrayList seedPositions, int record) {
        return seedPositions.get(KMapper2.index(record)) + KMapper2.offset(record);
    }

    public int getNValue() {
        return this.nValue;
    }

    public int getKValue() {
        return this.kValue;
    }

    public int getAbsoluteMinClusterScore() {
        return this.absoluteMinClusterScore;
    }

    public int getExtraClusterScore() {
        return this.extraClusterScore;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public float getRelativeMinScore() {
        return this.relativeMinScore;
    }

    static int index(int record) {
        return record & 0x1FFF;
    }

    static int offset(int record) {
        return record >> 13;
    }

    static int record(int offset, int index) {
        return offset << 13 | index;
    }

    static String recordToString(int record, IntArrayList seedPositions) {
        return "O=" + KMapper2.offset(record) + " Q" + seedPositions.get(KMapper2.index(record)) + "->T" + KMapper2.positionInTarget(seedPositions, record);
    }

    static boolean inDelta(int a, int b, int maxAllowedDelta) {
        int diff = a - b;
        return -maxAllowedDelta <= diff && diff <= maxAllowedDelta;
    }

    private static int getCombinationMask(int[] combination) {
        int c = 0;
        for (int a : combination) {
            c |= 1 << a;
        }
        return c;
    }

    public SummaryStatistics getRecordSizeSummaryStatistics() {
        SummaryStatistics ss = new SummaryStatistics();
        int[][] arr$ = this.lengths;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] length;
            for (int len : length = arr$[i$]) {
                ss.addValue((double)len);
            }
        }
        return ss;
    }

    public String toString() {
        SummaryStatistics ss = this.getRecordSizeSummaryStatistics();
        return "K=" + this.nValue + "; Avr=" + ss.getMean() + "; SD=" + ss.getStandardDeviation();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private static final class ThreadLocalCache {
        final IntArrayList seedPositions = new IntArrayList();
        final IntArrayList cachedIntArray1 = new IntArrayList();
        final IntArrayList cachedIntArray2 = new IntArrayList();
        final IntArrayList cachedIntArray3 = new IntArrayList();
        final IntArrayList[] candidates;
        final OffsetPacksAccumulator offsetPacksAccumulator;

        public ThreadLocalCache(int sequencesInBase, int slotCount, int maxClusterIndels, int matchScore, int mismatchScore, int offsetShiftScore, int absoluteMinClusterScore) {
            this.candidates = new IntArrayList[sequencesInBase];
            for (int i = 0; i < sequencesInBase; ++i) {
                this.candidates[i] = new IntArrayList();
            }
            this.offsetPacksAccumulator = new OffsetPacksAccumulator(slotCount, maxClusterIndels, matchScore, mismatchScore, offsetShiftScore, absoluteMinClusterScore);
        }

        public void reset() {
            this.seedPositions.clear();
            this.cachedIntArray1.clear();
            this.cachedIntArray2.clear();
            this.cachedIntArray3.clear();
            for (IntArrayList candidate : this.candidates) {
                candidate.clear();
            }
        }
    }

    static final class ArrList<T>
    extends ArrayList<T> {
        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

