/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment.kaligner2;

import com.milaboratory.core.alignment.kaligner2.KMapper2;
import com.milaboratory.util.IntArrayList;
import java.util.Arrays;

public final class OffsetPacksAccumulator {
    public static final int DROPPED_CLUSTER = -274653;
    public static final int FIRST_RECORD_ID = 0;
    public static final int LAST_RECORD_ID = 1;
    public static final int SCORE = 2;
    public static final int MIN_VALUE = 3;
    public static final int MAX_VALUE = 4;
    public static final int LAST_VALUE = 5;
    public static final int LAST_INDEX = 6;
    public static final int STRETCH_INDEX_MARK = -1610612736;
    public static final int STRETCH_INDEX_MASK = -536870912;
    public static final int RECORD_SIZE = 7;
    public static final int OUTPUT_RECORD_SIZE = 3;
    final int[] slidingArray;
    final int slotCount;
    final int maxAllowedDelta;
    final int matchScore;
    final int mismatchScore;
    final int shiftScore;
    final int absoluteMinClusterScore;
    final IntArrayList results = new IntArrayList(6);
    int totalScore;

    public OffsetPacksAccumulator(int slotCount, int maxAllowedDelta, int matchScore, int mismatchScore, int shiftScore, int absoluteMinClusterScore) {
        this.slotCount = slotCount;
        this.maxAllowedDelta = maxAllowedDelta;
        this.slidingArray = new int[7 * slotCount];
        this.matchScore = matchScore;
        this.mismatchScore = mismatchScore;
        this.shiftScore = shiftScore;
        this.absoluteMinClusterScore = absoluteMinClusterScore;
    }

    private void reset() {
        this.results.clear();
        this.totalScore = 0;
        Arrays.fill(this.slidingArray, Integer.MIN_VALUE);
    }

    public void calculateInitialPartitioning(IntArrayList list) {
        this.calculateInitialPartitioning(IntArrayList.getArrayReference(list), 0, list.size());
    }

    public void calculateInitialPartitioning(int[] data) {
        this.calculateInitialPartitioning(data, 0, data.length);
    }

    public void calculateInitialPartitioning(int[] data, int dataFrom, int dataTo) {
        this.reset();
        block0: for (int recordId = dataFrom; recordId < dataTo; ++recordId) {
            int record = data[recordId];
            int offset = KMapper2.offset(record);
            int index = KMapper2.index(record);
            for (int i = 0; i < this.slidingArray.length; i += 7) {
                if ((this.slidingArray[i + 2] & 0xE0000000) == -1610612736 && this.slidingArray[i + 3] - this.maxAllowedDelta <= offset && offset <= this.slidingArray[i + 4] + this.maxAllowedDelta) {
                    int pRecordId = this.slidingArray[i + 2] ^ 0xA0000000;
                    int pOffset = KMapper2.offset(data[pRecordId]);
                    int pIndex = KMapper2.index(data[pRecordId]);
                    int minDelta = Integer.MAX_VALUE;
                    int minDeltaId = -1;
                    int temp = Math.abs(offset - KMapper2.offset(data[pRecordId]));
                    if (minDelta > temp) {
                        minDeltaId = pRecordId;
                        minDelta = temp;
                    }
                    while (pRecordId < dataTo - 1 && pIndex == KMapper2.index(data[pRecordId + 1]) && Math.abs(pOffset - KMapper2.offset(data[pRecordId + 1])) <= this.maxAllowedDelta) {
                        if (minDelta <= (temp = Math.abs(offset - KMapper2.offset(data[++pRecordId])))) continue;
                        minDeltaId = pRecordId;
                        minDelta = temp;
                    }
                    pOffset = KMapper2.offset(data[minDeltaId]);
                    this.slidingArray[i + 0] = minDeltaId;
                    this.slidingArray[i + 1] = recordId;
                    this.slidingArray[i + 5] = pOffset;
                    this.slidingArray[i + 3] = pOffset;
                    this.slidingArray[i + 4] = pOffset;
                    this.slidingArray[i + 2] = this.matchScore;
                }
                if (!KMapper2.inDelta(this.slidingArray[i + 5], offset, this.maxAllowedDelta)) continue;
                if (recordId < dataTo - 1 && index == KMapper2.index(data[recordId + 1]) && Math.abs(this.slidingArray[i + 5] - offset) > Math.abs(this.slidingArray[i + 5] - KMapper2.offset(data[recordId + 1])) || recordId > dataFrom && index == KMapper2.index(data[recordId - 1]) && Math.abs(this.slidingArray[i + 5] - offset) > Math.abs(this.slidingArray[i + 5] - KMapper2.offset(data[recordId - 1]))) continue block0;
                assert (index > this.slidingArray[i + 6]);
                int scoreDelta = this.matchScore + (index - this.slidingArray[i + 6] - 1) * this.mismatchScore + Math.abs(this.slidingArray[i + 5] - offset) * this.shiftScore;
                if (scoreDelta <= 0) continue;
                this.slidingArray[i + 6] = index;
                this.slidingArray[i + 1] = recordId;
                this.slidingArray[i + 3] = Math.min(this.slidingArray[i + 3], offset);
                this.slidingArray[i + 4] = Math.max(this.slidingArray[i + 4], offset);
                this.slidingArray[i + 5] = offset;
                int n = i + 2;
                this.slidingArray[n] = this.slidingArray[n] + scoreDelta;
                continue block0;
            }
            int minimalIndex = -1;
            int minimalValue = Integer.MAX_VALUE;
            for (int i = 6; i < this.slidingArray.length; i += 7) {
                if (this.slidingArray[i] == Integer.MIN_VALUE) {
                    minimalIndex = i;
                    break;
                }
                if (this.slidingArray[i] >= minimalValue) continue;
                minimalIndex = i;
                minimalValue = this.slidingArray[i];
            }
            assert ((minimalIndex -= 6) >= 0);
            this.finished(minimalIndex);
            this.slidingArray[minimalIndex + 0] = recordId;
            this.slidingArray[minimalIndex + 1] = recordId;
            this.slidingArray[minimalIndex + 2] = this.matchScore;
            this.slidingArray[minimalIndex + 3] = offset;
            this.slidingArray[minimalIndex + 4] = offset;
            this.slidingArray[minimalIndex + 5] = offset;
            this.slidingArray[minimalIndex + 6] = index;
            while (recordId < dataTo - 1 && index == KMapper2.index(data[recordId + 1]) && KMapper2.inDelta(offset, KMapper2.offset(data[recordId + 1]), this.maxAllowedDelta)) {
                if ((this.slidingArray[minimalIndex + 2] & 0xA0000000) != -1610612736) {
                    this.slidingArray[minimalIndex + 2] = 0xA0000000 | recordId;
                    this.slidingArray[minimalIndex + 5] = Integer.MIN_VALUE;
                }
                assert (this.slidingArray[minimalIndex + 4] < KMapper2.offset(data[recordId + 1]));
                this.slidingArray[minimalIndex + 4] = offset = KMapper2.offset(data[++recordId]);
            }
        }
        for (int i = 0; i < this.slidingArray.length; i += 7) {
            this.finished(i);
        }
        this.recalculateScores(data, dataFrom, dataTo);
    }

    private void recalculateScores(int[] data, int dataFrom, int dataTo) {
        int size = this.results.size();
        for (int i = 0; i < size; i += 3) {
            int index;
            int recordId = this.results.get(i + 0);
            assert (recordId >= dataFrom);
            int lastRecordId = this.results.get(i + 1);
            assert (lastRecordId < dataTo);
            int clusterScore = this.matchScore;
            int record = data[recordId];
            int previousIndex = index = KMapper2.index(record);
            int previousOffset = KMapper2.offset(record);
            while (++recordId < dataTo && KMapper2.index(data[recordId]) == index) {
            }
            --recordId;
            while (++recordId <= lastRecordId) {
                int scoreDelta;
                record = data[recordId];
                index = KMapper2.index(record);
                int offset = KMapper2.offset(record);
                int minRecord = record;
                int minDelta = Math.abs(offset - previousOffset);
                if (minDelta > this.maxAllowedDelta) continue;
                boolean $ = false;
                while (recordId < lastRecordId && KMapper2.index(record = data[recordId + 1]) == index) {
                    ++recordId;
                    int delta = Math.abs(KMapper2.offset(record) - previousOffset);
                    if (delta >= minDelta) continue;
                    minDelta = delta;
                    minRecord = record;
                    $ = true;
                }
                if ($) {
                    offset = KMapper2.offset(minRecord);
                }
                if ((scoreDelta = this.matchScore + (index - previousIndex - 1) * this.mismatchScore + minDelta * this.shiftScore) <= 0) continue;
                clusterScore += scoreDelta;
                previousIndex = index;
                previousOffset = offset;
            }
            this.results.set(i + 2, Math.max(clusterScore, this.results.get(i + 2)));
        }
    }

    private void finished(int indexOfFinished) {
        if (this.slidingArray[indexOfFinished + 2] < this.absoluteMinClusterScore) {
            return;
        }
        this.totalScore += this.slidingArray[indexOfFinished + 2];
        this.results.add(this.slidingArray, indexOfFinished, 3);
    }

    public int numberOfClusters() {
        return this.results.size() / 3;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Number of clusters: ").append(this.numberOfClusters()).append("\n\n");
        int k = 0;
        for (int i = 0; i < this.results.size(); i += 3) {
            sb.append(k++ + "th cloud:\n").append("  first record id:").append(this.results.get(i + 0)).append("\n").append("  last record id:").append(this.results.get(i + 1)).append("\n").append("  score:").append(this.results.get(i + 2)).append("\n\n");
        }
        return sb.toString();
    }

    public static String toString(IntArrayList results, IntArrayList seedPositions, int[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("Number of clusters: ").append(results.size() / 3).append("\n\n");
        int k = 0;
        for (int i = 0; i < results.size(); i += 3) {
            int firstRID = results.get(i + 0);
            int lastRID = results.get(i + 1);
            sb.append(k++ + "th cloud:\n").append("  first record id:").append(firstRID).append(" (").append(KMapper2.recordToString(data[firstRID], seedPositions)).append(")\n").append("  last record id:").append(lastRID).append(" (").append(KMapper2.recordToString(data[lastRID], seedPositions)).append(")\n").append("  score:").append(results.get(i + 2)).append("\n\n");
        }
        return sb.toString();
    }
}

