/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.clustering;

import gnu.trove.procedure.TObjectProcedure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public final class Cluster<T>
implements Serializable {
    final T head;
    final Cluster<T> parent;
    ArrayList<Cluster<T>> children = null;

    public Cluster(T head) {
        this.head = head;
        this.parent = null;
    }

    public Cluster(T head, Cluster<T> parent) {
        this.head = head;
        this.parent = parent;
    }

    public T getHead() {
        return this.head;
    }

    public Cluster<T> getRoot() {
        Cluster<T> current = this.parent;
        while (current.parent != null) {
            current = current.parent;
        }
        return current;
    }

    public void add(Cluster<T> t) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        assert (t.parent == this);
        this.children.add(t);
    }

    public int totalCount() {
        int r = 1;
        if (this.children != null) {
            for (Cluster<T> child : this.children) {
                r += child.totalCount();
            }
        }
        return r;
    }

    public void processAllChildren(TObjectProcedure<Cluster<T>> procedure) {
        if (this.children == null) {
            return;
        }
        for (Cluster<T> child : this.children) {
            procedure.execute(child);
            child.processAllChildren(procedure);
        }
    }

    void sort(Comparator<Cluster<T>> comparator) {
        if (this.children != null) {
            Collections.sort(this.children, comparator);
            for (Cluster<T> cl : this.children) {
                cl.sort(comparator);
            }
        }
    }

    int size() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    static <T> ArrayList<T> getAll(Cluster<T> ... clusters) {
        ArrayList r = new ArrayList();
        for (Cluster<T> cluster : clusters) {
            Cluster.addToList(cluster, r);
        }
        return r;
    }

    static <T> void addToList(Cluster<T> cluster, ArrayList<T> list) {
        list.ensureCapacity(list.size() + 1 + cluster.size());
        list.add(cluster.head);
        if (cluster.children != null) {
            for (Cluster<T> child : cluster.children) {
                Cluster.addToList(child, list);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        assert (this.children == null || this.children.size() > 0);
        if (!this.head.equals(cluster.head)) {
            return false;
        }
        return !(this.children != null ? !this.children.equals(cluster.children) : cluster.children != null);
    }

    public int hashCode() {
        int result = this.head.hashCode();
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0);
        return sb.toString();
    }

    private void toString(StringBuilder sb, int level) {
        sb.append(Cluster.spaces(2 * level) + this.head + "\n");
        if (this.children == null) {
            return;
        }
        for (Cluster<T> child : this.children) {
            super.toString(sb, level + 1);
        }
    }

    private static String spaces(int n) {
        char[] charArray = new char[n];
        Arrays.fill(charArray, ' ');
        return new String(charArray);
    }
}

