/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.clustering;

import com.milaboratory.core.clustering.Cluster;
import com.milaboratory.core.clustering.ClusteringStrategy;
import com.milaboratory.core.clustering.SequenceExtractor;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.tree.NeighborhoodIterator;
import com.milaboratory.core.tree.SequenceTreeMap;
import com.milaboratory.core.tree.TreeSearchParameters;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.Factory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public final class Clustering<T, S extends Sequence<S>>
implements CanReportProgress {
    final Collection<T> inputObjects;
    final SequenceExtractor<T, S> sequenceExtractor;
    final ClusteringStrategy<T, S> strategy;
    final List<Cluster<T>> clusters = new ArrayList<Cluster<T>>();
    volatile int progress;

    public Clustering(Collection<T> inputObjects, SequenceExtractor<T, S> sequenceExtractor, ClusteringStrategy<T, S> strategy) {
        this.inputObjects = inputObjects;
        this.sequenceExtractor = sequenceExtractor;
        this.strategy = strategy;
    }

    @Override
    public double getProgress() {
        return 1.0 * (double)this.progress / (double)this.inputObjects.size();
    }

    @Override
    public boolean isFinished() {
        return this.progress == this.inputObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cluster<T>> performClustering() {
        try {
            if (this.inputObjects.isEmpty()) {
                List<Cluster<T>> list = this.clusters;
                return list;
            }
            Comparator<Cluster<T>> clusterComparator = Clustering.getComparatorOfClusters(this.strategy, this.sequenceExtractor);
            TreeSearchParameters params = this.strategy.getSearchParameters();
            int maxDepth = this.strategy.getMaxClusterDepth();
            ArrayList<T> objects = new ArrayList<T>(this.inputObjects);
            Collections.sort(objects, Clustering.getComparatorOfObjectsRegardingSequences(this.strategy, this.sequenceExtractor));
            Alphabet alphabet = ((Sequence)this.sequenceExtractor.getSequence(objects.get(0))).getAlphabet();
            Factory<T[]> arrayFactory = new Factory<T[]>(){

                @Override
                public T[] create() {
                    return new Object[1];
                }
            };
            SequenceTreeMap<S, T[]> tree = new SequenceTreeMap<S, T[]>(alphabet);
            for (Object object : objects) {
                T[] array = tree.createIfAbsent(this.sequenceExtractor.getSequence(object), arrayFactory);
                if (array[0] == null) {
                    array[0] = object;
                    continue;
                }
                array = Arrays.copyOf(array, array.length + 1);
                array[array.length - 1] = object;
                tree.put(this.sequenceExtractor.getSequence(object), array);
            }
            HashSet processedNodes = new HashSet();
            ArrayList previousLayer = new ArrayList();
            ArrayList<Cluster<Object>> nextLayer = new ArrayList<Cluster<Object>>();
            for (int i = 0; i < objects.size(); ++i) {
                this.progress = i;
                Object object = objects.get(i);
                Object[] temp = (Object[])tree.get(this.sequenceExtractor.getSequence(object));
                if (temp == null) continue;
                boolean inTree = false;
                for (Object object2 : temp) {
                    if (object2 != object) continue;
                    inTree = true;
                    break;
                }
                if (!inTree) continue;
                Cluster<Object> tempCluster = new Cluster(object);
                this.clusters.add(tempCluster);
                previousLayer.clear();
                previousLayer.add(tempCluster);
                for (int depth = 0; depth < maxDepth; ++depth) {
                    nextLayer.clear();
                    for (Cluster cluster : previousLayer) {
                        SequenceTreeMap.Node current;
                        NeighborhoodIterator iterator = tree.getNeighborhoodIterator(this.sequenceExtractor.getSequence(cluster.head), params, null);
                        processedNodes.clear();
                        while ((current = iterator.nextNode()) != null) {
                            if (!processedNodes.add(current)) continue;
                            Object[] currentObjects = (Object[])current.getObject();
                            Object matchedObject = null;
                            boolean allNulls = true;
                            for (int j = 0; j < currentObjects.length; ++j) {
                                if (currentObjects[j] == null) continue;
                                matchedObject = currentObjects[j];
                                if (this.strategy.compare(cluster.head, matchedObject) <= 0 || !this.strategy.canAddToCluster(cluster, matchedObject, iterator)) {
                                    allNulls = false;
                                    continue;
                                }
                                tempCluster = new Cluster<Object>(matchedObject, cluster);
                                nextLayer.add(tempCluster);
                                cluster.add(tempCluster);
                                currentObjects[j] = null;
                            }
                            assert (matchedObject != null);
                            if (!allNulls) continue;
                            tree.remove(this.sequenceExtractor.getSequence(matchedObject));
                        }
                        if (cluster.children == null) continue;
                        Collections.sort(cluster.children, clusterComparator);
                    }
                    Collections.sort(nextLayer, clusterComparator);
                    ArrayList<Cluster<Object>> tmp = nextLayer;
                    nextLayer = previousLayer;
                    previousLayer = tmp;
                }
            }
            List<Cluster<T>> list = this.clusters;
            return list;
        }
        finally {
            this.progress = this.inputObjects.size();
        }
    }

    public List<Cluster<T>> getClusters() {
        if (this.progress != this.inputObjects.size()) {
            throw new IllegalStateException("Not yet clustered.");
        }
        return this.clusters;
    }

    static <T, S extends Sequence> Comparator<Cluster<T>> getComparatorOfClusters(final Comparator<T> objectComparator, final SequenceExtractor<T, S> extractor) {
        return new Comparator<Cluster<T>>(){

            @Override
            public int compare(Cluster<T> o1, Cluster<T> o2) {
                int i = objectComparator.compare(o2.head, o1.head);
                return i == 0 ? ((Sequence)extractor.getSequence(o2.head)).compareTo(extractor.getSequence(o1.head)) : i;
            }
        };
    }

    static <T, S extends Sequence> Comparator<T> getComparatorOfObjectsRegardingSequences(final Comparator<T> objectComparator, final SequenceExtractor<T, S> extractor) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int i = objectComparator.compare(o2, o1);
                return i == 0 ? ((Sequence)extractor.getSequence(o2)).compareTo(extractor.getSequence(o1)) : i;
            }
        };
    }

    public static <T, S extends Sequence<S>> List<Cluster<T>> performClustering(Collection<T> inputObjects, SequenceExtractor<T, S> sequenceExtractor, ClusteringStrategy<T, S> strategy) {
        return new Clustering<T, S>(inputObjects, sequenceExtractor, strategy).performClustering();
    }
}

