/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public enum CompressionType {
    None,
    GZIP,
    BZIP2;


    public static CompressionType detectCompressionType(File file) {
        return CompressionType.detectCompressionType(file.getName());
    }

    public static CompressionType detectCompressionType(String fileName) {
        if ((fileName = fileName.trim().toLowerCase()).endsWith(".gz")) {
            return GZIP;
        }
        if (fileName.endsWith(".bz2")) {
            return BZIP2;
        }
        return None;
    }

    public InputStream createInputStream(InputStream is) throws IOException {
        return CompressionType.createInputStream(this, is, 2048);
    }

    public InputStream createInputStream(InputStream is, int buffer) throws IOException {
        return CompressionType.createInputStream(this, is, buffer);
    }

    public OutputStream createOutputStream(OutputStream os) throws IOException {
        return CompressionType.createOutputStream(this, os, 2048);
    }

    public OutputStream createOutputStream(OutputStream os, int buffer) throws IOException {
        return CompressionType.createOutputStream(this, os, buffer);
    }

    private static InputStream createInputStream(CompressionType ct, InputStream is, int buffer) throws IOException {
        switch (ct) {
            case None: {
                return is;
            }
            case GZIP: {
                return new GZIPInputStream(is, buffer);
            }
            case BZIP2: {
                CompressorStreamFactory factory = new CompressorStreamFactory();
                try {
                    return factory.createCompressorInputStream("bzip2", (InputStream)new BufferedInputStream(is));
                }
                catch (CompressorException e) {
                    throw new IOException(e);
                }
            }
        }
        throw new NullPointerException();
    }

    private static OutputStream createOutputStream(CompressionType ct, OutputStream os, int buffer) throws IOException {
        switch (ct) {
            case None: {
                return os;
            }
            case GZIP: {
                return new GZIPOutputStream(os, buffer);
            }
            case BZIP2: {
                CompressorStreamFactory factory = new CompressorStreamFactory();
                try {
                    return factory.createCompressorOutputStream("bzip2", (OutputStream)new BufferedOutputStream(os));
                }
                catch (CompressorException e) {
                    throw new IOException(e);
                }
            }
        }
        throw new NullPointerException();
    }
}

