/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence;

import com.milaboratory.core.io.sequence.AbstractSequenceReader;
import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SequenceReader;
import com.milaboratory.core.io.sequence.SequenceReaderCloseable;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReader;
import com.milaboratory.util.CanReportProgress;

public abstract class AbstractMultiReader<R extends SequenceRead>
extends AbstractSequenceReader<R>
implements CanReportProgress,
SequenceReader<R>,
SequenceReaderCloseable<R> {
    private final SingleReader[] readers;
    private final CanReportProgress[] progressReporters;

    public AbstractMultiReader(SingleReader ... readers) {
        for (SingleReader reader : readers) {
            if (reader != null) continue;
            throw new NullPointerException();
        }
        this.readers = readers;
        boolean crp = true;
        for (SingleReader reader : readers) {
            crp &= reader instanceof CanReportProgress;
        }
        if (crp) {
            this.progressReporters = new CanReportProgress[readers.length];
            for (int i = 0; i < readers.length; ++i) {
                this.progressReporters[i] = (CanReportProgress)((Object)readers[i]);
            }
        } else {
            this.progressReporters = null;
        }
    }

    protected synchronized SingleRead[] takeReads() {
        SingleRead[] reads = new SingleRead[this.readers.length];
        boolean hasNulls = false;
        boolean allNulls = true;
        for (int i = 0; i < reads.length; ++i) {
            reads[i] = (SingleRead)this.readers[i].take();
            hasNulls |= reads[i] == null;
            allNulls &= reads[i] == null;
        }
        if (allNulls) {
            return null;
        }
        if (hasNulls) {
            throw new RuntimeException("Different number of reads in single-readers.");
        }
        this.addOneRead();
        return reads;
    }

    public void close() {
        RuntimeException exception = null;
        for (SingleReader reader : this.readers) {
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (RuntimeException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public double getProgress() {
        if (this.progressReporters == null) {
            return Double.NaN;
        }
        double sum = 0.0;
        for (CanReportProgress reporter : this.progressReporters) {
            double progress = reporter.getProgress();
            if (Double.isNaN(progress)) {
                return Double.NaN;
            }
            sum += progress;
        }
        return sum / (double)this.progressReporters.length;
    }

    @Override
    public boolean isFinished() {
        if (this.progressReporters == null) {
            return true;
        }
        boolean allFinished = true;
        for (CanReportProgress reporter : this.progressReporters) {
            allFinished &= reporter.isFinished();
        }
        return allFinished;
    }
}

