/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence;

import com.milaboratory.core.io.sequence.MultiRead;
import com.milaboratory.core.io.sequence.PairedRead;
import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReadImpl;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.primitivio.PrimitivO;
import com.milaboratory.primitivio.Serializer;

class IO {
    IO() {
    }

    public static class SequenceReadSerializer
    implements Serializer<SequenceRead> {
        @Override
        public void write(PrimitivO output, SequenceRead object) {
            output.writeVarLong(object.getId());
            if (object instanceof SingleRead) {
                output.writeByte(1);
                SingleRead read = (SingleRead)object;
                output.writeObject(read.getData());
                output.writeObject(read.getDescription());
            } else {
                output.writeByte(object.numberOfReads());
                for (int i = 0; i < object.numberOfReads(); ++i) {
                    SingleRead read = object.getRead(i);
                    output.writeObject(read.getData());
                    output.writeObject(read.getDescription());
                }
            }
        }

        @Override
        public SequenceRead read(PrimitivI input) {
            long id = input.readVarLong();
            int readsCount = input.readByte();
            if (readsCount == 1) {
                NSequenceWithQuality seq = input.readObject(NSequenceWithQuality.class);
                String description = input.readObject(String.class);
                return new SingleReadImpl(id, seq, description);
            }
            SingleRead[] reads = new SingleRead[readsCount];
            for (int i = 0; i < readsCount; ++i) {
                NSequenceWithQuality seq = input.readObject(NSequenceWithQuality.class);
                String description = input.readObject(String.class);
                reads[i] = new SingleReadImpl(id, seq, description);
            }
            if (reads.length == 2) {
                return new PairedRead(reads);
            }
            return new MultiRead(reads);
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }
}

