/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence;

import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.util.ArrayIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

public class MultiRead
implements SequenceRead,
Serializable {
    final SingleRead[] data;

    public MultiRead(SingleRead[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        long id = data[0].getId();
        for (int i = 1; i < data.length; ++i) {
            if (data[i].getId() == id) continue;
            throw new IllegalArgumentException("Incompatible read ids.");
        }
        this.data = data;
    }

    @Override
    public int numberOfReads() {
        return this.data.length;
    }

    @Override
    public SingleRead getRead(int i) {
        return this.data[i];
    }

    @Override
    public long getId() {
        return this.data[0].getId();
    }

    @Override
    public Iterator<SingleRead> iterator() {
        return new ArrayIterator<SingleRead>(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiRead that = (MultiRead)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

