/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence;

import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.util.SingleIterator;
import java.util.Iterator;

public final class SingleReadImpl
implements SingleRead {
    final long id;
    final NSequenceWithQuality sequenceWithQuality;
    final String description;

    public SingleReadImpl(long id, NSequenceWithQuality sequenceWithQuality, String description) {
        this.id = id;
        this.sequenceWithQuality = sequenceWithQuality;
        this.description = description;
    }

    @Override
    public int numberOfReads() {
        return 1;
    }

    @Override
    public SingleRead getRead(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public NSequenceWithQuality getData() {
        return this.sequenceWithQuality;
    }

    @Override
    public Iterator<SingleRead> iterator() {
        return new SingleIterator<SingleRead>(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SingleRead)) {
            return false;
        }
        SingleRead oth = (SingleRead)o;
        return this.id == oth.getId() && this.sequenceWithQuality.equals(oth.getData()) && this.description.equals(oth.getDescription());
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.sequenceWithQuality.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "@" + this.description + "\n" + this.sequenceWithQuality.getSequence() + "\n+\n" + this.sequenceWithQuality.getQuality();
    }
}

