/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence;

import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.fastq.QualityFormat;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.core.sequence.UnsafeFactory;
import com.milaboratory.util.SingleIterator;
import java.nio.charset.Charset;
import java.util.Iterator;

public abstract class SingleReadLazy
implements SingleRead {
    final long id;
    final byte[] buffer;
    final int descriptionFrom;
    final short sequenceOffset;
    final short qualityOffset;
    final short dataLength;
    final short descriptionLength;
    final boolean replaceWildcards;
    NSequenceWithQuality sequenceWithQuality;
    String description;

    private SingleReadLazy(long id, byte[] buffer, int descriptionFrom, short sequenceOffset, short qualityOffset, short dataLength, short descriptionLength, boolean replaceWildcards) {
        this.id = id;
        this.buffer = buffer;
        this.descriptionFrom = descriptionFrom;
        this.sequenceOffset = sequenceOffset;
        this.qualityOffset = qualityOffset;
        this.dataLength = dataLength;
        this.descriptionLength = descriptionLength;
        this.replaceWildcards = replaceWildcards;
    }

    abstract byte getQualityOffset();

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.createDescription();
        }
        return this.description;
    }

    @Override
    public NSequenceWithQuality getData() {
        if (this.sequenceWithQuality == null) {
            this.sequenceWithQuality = this.createNSequenceWithQuality();
        }
        return this.sequenceWithQuality;
    }

    private String createDescription() {
        return new String(this.buffer, this.descriptionFrom, (int)this.descriptionLength, Charset.defaultCharset());
    }

    private NSequenceWithQuality createNSequenceWithQuality() {
        try {
            return UnsafeFactory.fastqParse(this.buffer, this.descriptionFrom + this.sequenceOffset, this.descriptionFrom + this.qualityOffset, this.dataLength, this.getQualityOffset(), this.id, this.replaceWildcards);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing read:\n" + new String(this.buffer, this.descriptionFrom - 1, this.qualityOffset + this.dataLength), e);
        }
    }

    @Override
    public int numberOfReads() {
        return 1;
    }

    @Override
    public SingleRead getRead(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Iterator<SingleRead> iterator() {
        return new SingleIterator<SingleRead>(this);
    }

    public static SingleReadLazy create(QualityFormat format, long id, byte[] buffer, int descriptionFrom, short dataOffset, short qualityOffset, short dataLength, short descriptionLength, boolean replaceWildcards) {
        if (format == QualityFormat.Phred33) {
            return new SingleReadLazy(id, buffer, descriptionFrom, dataOffset, qualityOffset, dataLength, descriptionLength, replaceWildcards){

                @Override
                byte getQualityOffset() {
                    return 33;
                }
            };
        }
        if (format == QualityFormat.Phred64) {
            return new SingleReadLazy(id, buffer, descriptionFrom, dataOffset, qualityOffset, dataLength, descriptionLength, replaceWildcards){

                @Override
                byte getQualityOffset() {
                    return 64;
                }
            };
        }
        throw new IllegalArgumentException("Unknown quality format.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SingleRead)) {
            return false;
        }
        SingleRead oth = (SingleRead)o;
        return this.getId() == oth.getId() && this.getData().equals(oth.getData()) && this.getDescription().equals(oth.getDescription());
    }
}

