/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fasta;

import cc.redberry.pipe.OutputPortCloseable;
import com.milaboratory.core.io.sequence.IllegalFileFormatException;
import com.milaboratory.core.io.sequence.fasta.FastaRecord;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.CountingInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;

public class FastaReader<S extends Sequence<S>>
implements CanReportProgress,
OutputPortCloseable<FastaRecord<S>>,
AutoCloseable {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final BufferedReader reader;
    private String bufferedLine;
    private long id;
    private final long size;
    private final CountingInputStream countingInputStream;
    private final Alphabet<S> alphabet;
    private volatile boolean isFinished = false;

    public FastaReader(InputStream inputStream, Alphabet<S> alphabet, long size) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.size = size;
        this.alphabet = alphabet;
        this.countingInputStream = new CountingInputStream(inputStream);
        this.reader = new BufferedReader(new InputStreamReader(this.countingInputStream));
    }

    public FastaReader(InputStream inputStream, Alphabet<S> alphabet) {
        this(inputStream, alphabet, 0L);
    }

    public FastaReader(String file, Alphabet<S> alphabet) throws FileNotFoundException {
        this(new File(file), alphabet);
    }

    public FastaReader(File file, Alphabet<S> alphabet) throws FileNotFoundException {
        this(new FileInputStream(file), alphabet, file.length());
    }

    @Override
    public synchronized double getProgress() {
        if (this.size == 0L) {
            return Double.NaN;
        }
        return (double)this.countingInputStream.getBytesRead() * 1.0 / (double)this.size;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.isFinished;
    }

    public FastaRecord<S> take() {
        RawFastaRecord rawRecord = this.takeRawRecord();
        if (rawRecord == null) {
            return null;
        }
        return new FastaRecord<S>(this.id++, rawRecord.description, this.alphabet.parse(rawRecord.sequence));
    }

    public synchronized RawFastaRecord takeRawRecord() {
        RawFastaRecord rawFastaRecord;
        try {
            rawFastaRecord = this.nextRawRecord();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (rawFastaRecord == null) {
            this.isFinished = true;
        }
        return rawFastaRecord;
    }

    public OutputPortCloseable<RawFastaRecord> asRawRecordsPort() {
        return new OutputPortCloseable<RawFastaRecord>(){

            public void close() {
                FastaReader.this.close();
            }

            public RawFastaRecord take() {
                return FastaReader.this.takeRawRecord();
            }
        };
    }

    private RawFastaRecord nextRawRecord() throws IOException {
        String line;
        String description;
        if (this.bufferedLine != null) {
            description = this.bufferedLine;
        } else {
            description = this.reader.readLine();
            if (description == null) {
                return null;
            }
            if (description.charAt(0) != '>') {
                throw new IllegalFileFormatException("Wrong FASTA format.");
            }
        }
        StringBuilder sequence = new StringBuilder();
        while ((line = this.reader.readLine()) != null && ((line = line.trim()).isEmpty() || line.charAt(0) != '>')) {
            sequence.append(line);
        }
        this.bufferedLine = line;
        return new RawFastaRecord(description.substring(1), sequence.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            BufferedReader bufferedReader = this.reader;
            synchronized (bufferedReader) {
                this.reader.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized long getNumberOfReads() {
        return this.id;
    }

    public static final class RawFastaRecord {
        public final String description;
        public final String sequence;

        private RawFastaRecord(String description, String sequence) {
            this.description = description;
            this.sequence = sequence;
        }
    }
}

