/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fasta;

import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReadImpl;
import com.milaboratory.core.io.sequence.SingleReader;
import com.milaboratory.core.io.sequence.fasta.FastaReader;
import com.milaboratory.core.io.sequence.fasta.FastaRecord;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.core.sequence.SequencesUtils;
import com.milaboratory.util.CanReportProgress;

public class FastaSequenceReaderWrapper
implements SingleReader,
CanReportProgress {
    private final FastaReader<NucleotideSequence> internalReader;
    private final boolean replaceWildcards;

    public FastaSequenceReaderWrapper(FastaReader<NucleotideSequence> internalReader) {
        this(internalReader, false);
    }

    public FastaSequenceReaderWrapper(FastaReader<NucleotideSequence> internalReader, boolean replaceWildcards) {
        this.internalReader = internalReader;
        this.replaceWildcards = replaceWildcards;
    }

    @Override
    public double getProgress() {
        return this.internalReader.getProgress();
    }

    @Override
    public boolean isFinished() {
        return this.internalReader.isFinished();
    }

    public void close() {
        this.internalReader.close();
    }

    @Override
    public long getNumberOfReads() {
        return this.internalReader.getNumberOfReads();
    }

    public SingleRead take() {
        NSequenceWithQuality seq;
        Object record = this.internalReader.take();
        if (record == null) {
            return null;
        }
        NucleotideSequence sequence = (NucleotideSequence)((FastaRecord)record).getSequence();
        if (this.replaceWildcards) {
            byte[] quality = new byte[sequence.size()];
            for (int i = 0; i < quality.length; ++i) {
                quality[i] = NucleotideSequence.ALPHABET.isWildcard(sequence.codeAt(i)) ? 0 : 34;
            }
            seq = new NSequenceWithQuality(SequencesUtils.wildcardsToRandomBasic(sequence, ((FastaRecord)record).getId()), new SequenceQuality(quality));
        } else {
            seq = new NSequenceWithQuality(sequence, SequenceQuality.getUniformQuality((byte)34, sequence.size()));
        }
        return new SingleReadImpl(((FastaRecord)record).getId(), seq, ((FastaRecord)record).getDescription());
    }
}

