/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fasta;

import com.milaboratory.core.io.sequence.fasta.FastaRecord;
import com.milaboratory.core.sequence.Sequence;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FastaWriter<S extends Sequence<S>>
implements AutoCloseable {
    public static final int DEFAULT_MAX_LENGTH = 75;
    final int maxLength;
    final OutputStream outputStream;

    public FastaWriter(String fileName) throws FileNotFoundException {
        this(new File(fileName), 75);
    }

    public FastaWriter(File file) throws FileNotFoundException {
        this(file, 75);
    }

    public FastaWriter(File file, int maxLength) throws FileNotFoundException {
        this.outputStream = new BufferedOutputStream(new FileOutputStream(file));
        this.maxLength = maxLength;
    }

    public FastaWriter(OutputStream outputStream) {
        this(outputStream, 75);
    }

    public FastaWriter(OutputStream outputStream, int maxLength) {
        this.outputStream = outputStream;
        this.maxLength = maxLength;
    }

    public void write(FastaRecord<S> record) {
        this.write(record.getDescription(), record.getSequence());
    }

    public synchronized void write(String description, S sequence) {
        try {
            this.outputStream.write(62);
            if (description != null) {
                this.outputStream.write(description.getBytes());
            }
            this.outputStream.write(10);
            byte[] seq = ((Sequence)sequence).toString().getBytes();
            int pointer = 0;
            do {
                if (seq.length - pointer <= this.maxLength) {
                    this.outputStream.write(seq, pointer, seq.length - pointer);
                } else {
                    this.outputStream.write(seq, pointer, this.maxLength);
                }
                this.outputStream.write(10);
            } while (seq.length > (pointer += this.maxLength));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

