/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fasta;

import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.primitivio.PrimitivO;
import com.milaboratory.util.LongProcessReporter;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class RandomAccessFastaIndex {
    public static final String INDEX_SUFFIX = ".mifdx";
    public static int MAGIC = -557371195;
    public static final int DEFAULT_INDEX_STEP = 4096;
    public static final long SKIP_MASK = 1048575L;
    public static final int FILE_POSITION_OFFSET = 20;
    private final int indexStep;
    private final long[] indexArray;
    private final IndexRecord[] records;
    private final IndexRecord MULTI_HITS_RECORD = new IndexRecord(-1, "", 0L, 0);
    private final Map<String, IndexRecord> idIndex = new TreeMap<String, IndexRecord>();
    private static final Pattern[] specialIds = new Pattern[]{Pattern.compile("(lcl|bbs|gi|gb|emb|dbj|sp|pdb|pat|gnl|ref)\\|[^\\|]+"), Pattern.compile("(gb|emb|dbj|sp|pdb|pat|gnl|ref)\\|[^\\|]+\\|[^\\|]+"), Pattern.compile("(pir|prf)\\|\\|[^\\|]+"), Pattern.compile("^\\S+")};

    RandomAccessFastaIndex(InputStream is) {
        try {
            int i;
            PrimitivI pi = new PrimitivI(is);
            int magic = pi.readInt();
            if (magic != MAGIC) {
                throw new IllegalArgumentException("Wrong stream format.");
            }
            this.indexStep = pi.readVarInt();
            this.indexArray = new long[pi.readVarInt()];
            if (this.indexArray.length == 0) {
                this.records = new IndexRecord[0];
                return;
            }
            GZIPInputStream input = new GZIPInputStream(is);
            pi = new PrimitivI(input);
            this.indexArray[0] = pi.readVarLong();
            for (i = 1; i < this.indexArray.length; ++i) {
                this.indexArray[i] = this.indexArray[i - 1] + pi.readVarLong();
            }
            this.records = new IndexRecord[pi.readVarInt()];
            for (i = 0; i < this.records.length; ++i) {
                int indexStart = pi.readVarInt();
                long length = pi.readVarLong();
                String description = pi.readUTF();
                this.records[i] = new IndexRecord(i, description, length, indexStart);
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        this.fillIdIndex();
    }

    RandomAccessFastaIndex(IndexBuilder builder) {
        if (builder.lengths.size() != builder.descriptions.size()) {
            throw new IllegalStateException();
        }
        this.indexStep = builder.indexStep;
        this.indexArray = builder.index.toArray();
        this.records = new IndexRecord[builder.indexIndex.size()];
        for (int i = 0; i < this.records.length; ++i) {
            this.records[i] = new IndexRecord(i, (String)builder.descriptions.get(i), builder.lengths.get(i), builder.indexIndex.get(i));
        }
        this.fillIdIndex();
    }

    public int getIndexStep() {
        return this.indexStep;
    }

    public int size() {
        return this.records.length;
    }

    public IndexRecord getRecordByIndex(int i) {
        return this.records[i];
    }

    public IndexRecord getRecordById(String id) {
        IndexRecord rec = this.idIndex.get(id = id.trim());
        if (rec == this.MULTI_HITS_RECORD) {
            throw new MultipleMatchingRecordsException("Multiple matching records for \"" + id + "\".");
        }
        return rec;
    }

    public IndexRecord getRecordByIdCheck(String id) {
        IndexRecord rec = this.idIndex.get(id = id.trim());
        if (rec == this.MULTI_HITS_RECORD) {
            throw new MultipleMatchingRecordsException("Multiple matching records for \"" + id + "\".");
        }
        if (rec == null) {
            throw new NoSuchRecordException("No records with id: " + id);
        }
        return rec;
    }

    public void write(OutputStream stream) {
        try {
            PrimitivO po = new PrimitivO(stream);
            po.writeInt(MAGIC);
            po.writeVarInt(this.indexStep);
            po.writeVarInt(this.indexArray.length);
            if (this.indexArray.length == 0) {
                return;
            }
            GZIPOutputStream gzipped = new GZIPOutputStream(stream);
            po = new PrimitivO(gzipped);
            po.writeVarLong(this.indexArray[0]);
            for (int i = 1; i < this.indexArray.length; ++i) {
                po.writeVarLong(this.indexArray[i] - this.indexArray[i - 1]);
            }
            po.writeVarInt(this.records.length);
            for (IndexRecord record : this.records) {
                po.writeVarInt(record.indexStart);
                po.writeVarLong(record.length);
                po.writeUTF(record.description);
            }
            gzipped.finish();
            gzipped.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void fillIdIndex() {
        HashSet<String> ids = new HashSet<String>();
        for (IndexRecord record : this.records) {
            ids.clear();
            RandomAccessFastaIndex.extractIds(record.description, ids);
            record.ids.addAll(ids);
            for (String id : ids) {
                if (this.idIndex.containsKey(id)) {
                    this.idIndex.put(id, this.MULTI_HITS_RECORD);
                    continue;
                }
                this.idIndex.put(id, record);
            }
        }
    }

    private static void extractIds(String descriptionLine, Set<String> ids) {
        ids.add(descriptionLine.trim());
        for (String s : descriptionLine.split("\\|")) {
            ids.add(s.trim());
        }
        for (Pattern pattern : specialIds) {
            Matcher matcher = pattern.matcher(descriptionLine);
            while (matcher.find()) {
                ids.add(matcher.group().trim());
            }
        }
    }

    public static RandomAccessFastaIndex read(InputStream stream) {
        return new RandomAccessFastaIndex(stream);
    }

    public static long extractFilePosition(long p) {
        return p >>> 20;
    }

    public static int extractSkipLetters(long p) {
        return (int)(p & 0xFFFFFL);
    }

    public static RandomAccessFastaIndex index(Path file) {
        return RandomAccessFastaIndex.index(file, false);
    }

    public static RandomAccessFastaIndex index(Path file, boolean save) {
        return RandomAccessFastaIndex.index(file, save, LongProcessReporter.DefaultLongProcessReporter.INSTANCE);
    }

    public static RandomAccessFastaIndex index(Path file, boolean save, LongProcessReporter reporter) {
        try {
            long size = Files.size(file);
            long step = size / 131072L;
            if (step < 128L) {
                step = 128L;
            }
            int iStep = 1 << 64 - Long.numberOfLeadingZeros(step) + (Long.bitCount(step) > 1 ? 1 : 0);
            return RandomAccessFastaIndex.index(file, iStep, save, reporter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RandomAccessFastaIndex index(Path file, int indexStep, boolean save) {
        return RandomAccessFastaIndex.index(file, indexStep, save, LongProcessReporter.DefaultLongProcessReporter.INSTANCE);
    }

    /*
     * Exception decompiling
     */
    public static RandomAccessFastaIndex index(Path file, int indexStep, boolean save, LongProcessReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RandomAccessFastaIndex)) {
            return false;
        }
        RandomAccessFastaIndex that = (RandomAccessFastaIndex)o;
        if (this.indexStep != that.indexStep) {
            return false;
        }
        if (!Arrays.equals(this.indexArray, that.indexArray)) {
            return false;
        }
        return Arrays.equals(this.records, that.records);
    }

    public int hashCode() {
        int result = this.indexStep;
        result = 31 * result + Arrays.hashCode(this.indexArray);
        result = 31 * result + Arrays.hashCode(this.records);
        return result;
    }

    public static final class NoSuchRecordException
    extends RuntimeException {
        public NoSuchRecordException(String message) {
            super(message);
        }
    }

    public static final class MultipleMatchingRecordsException
    extends RuntimeException {
        public MultipleMatchingRecordsException(String message) {
            super(message);
        }
    }

    public static final class IndexBuilder {
        private final int indexStep;
        private final List<String> descriptions = new ArrayList<String>();
        private final TLongArrayList lengths = new TLongArrayList();
        private final TIntArrayList indexIndex = new TIntArrayList();
        private final TLongArrayList index = new TLongArrayList();

        public IndexBuilder() {
            this(4096);
        }

        public IndexBuilder(int indexStep) {
            if (indexStep <= 0) {
                throw new IllegalArgumentException();
            }
            this.indexStep = indexStep;
        }

        public boolean isOnRecord() {
            return this.lengths.size() + 1 == this.descriptions.size();
        }

        public void addRecord(String description, long position) {
            if (this.lengths.size() != this.descriptions.size()) {
                throw new IllegalStateException();
            }
            if (!this.index.isEmpty() && this.index.get(this.index.size() - 1) >= position) {
                throw new IllegalArgumentException();
            }
            this.descriptions.add(description);
            this.indexIndex.add(this.index.size());
            this.index.add(position);
        }

        public void addIndexPoint(long position) {
            this.index.add(position);
        }

        public void setLastRecordLength(long length) {
            if (this.lengths.size() + 1 != this.descriptions.size()) {
                throw new IllegalStateException();
            }
            if ((long)((this.index.size() - this.indexIndex.get(this.indexIndex.size() - 1) - 1) * this.indexStep) > length) {
                throw new IllegalArgumentException();
            }
            this.lengths.add(length);
        }

        public RandomAccessFastaIndex build() {
            return new RandomAccessFastaIndex(this);
        }
    }

    public static final class StreamIndexBuilder {
        final IndexBuilder builder;
        long currentStreamPosition = 0L;
        long lastNonLineBreakPosition = -1L;
        long currentSequencePosition = -1L;
        boolean onLineStart = true;
        int headerBufferPointer = -1;
        byte[] headerBuffer = new byte[32768];

        public StreamIndexBuilder() {
            this(4096);
        }

        public StreamIndexBuilder(int indexStep) {
            this(new IndexBuilder(indexStep), 0L);
        }

        public StreamIndexBuilder(int indexStep, long streamPosition) {
            this(new IndexBuilder(indexStep), streamPosition);
        }

        public StreamIndexBuilder(IndexBuilder builder, long streamPosition) {
            this.currentStreamPosition = streamPosition;
            this.builder = builder;
        }

        public void processBuffer(String str) {
            this.processBuffer(str.getBytes());
        }

        public void processBuffer(byte[] buffer) {
            this.processBuffer(buffer, 0, buffer.length);
        }

        public void processBuffer(byte[] buffer, int offset, int length) {
            if (this.currentStreamPosition == -1L) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < length; ++i) {
                long streamPosition;
                ++this.currentStreamPosition;
                byte b = buffer[offset + i];
                if (b == 10 || b == 13) {
                    if (!this.onLineStart) {
                        this.lastNonLineBreakPosition = streamPosition - 1L;
                    }
                    this.onLineStart = true;
                    continue;
                }
                if (this.onLineStart && b == 62) {
                    this.endOfRecord();
                    this.headerBufferPointer = 0;
                    this.onLineStart = false;
                    continue;
                }
                if (this.onLineStart && this.headerBufferPointer >= 0) {
                    this.builder.addRecord(new String(this.headerBuffer, 0, this.headerBufferPointer), streamPosition);
                    this.headerBufferPointer = -1;
                    this.currentSequencePosition = 0L;
                }
                if (this.headerBufferPointer == -1) {
                    long sequencePosition;
                    ++this.currentSequencePosition;
                    if (sequencePosition == 0L || sequencePosition % (long)this.builder.indexStep != 0L) continue;
                    this.builder.addIndexPoint(streamPosition);
                    continue;
                }
                this.headerBuffer[this.headerBufferPointer++] = b;
            }
        }

        private void endOfRecord() {
            if (this.builder.isOnRecord()) {
                this.builder.setLastRecordLength(this.currentSequencePosition);
            }
        }

        public RandomAccessFastaIndex build() {
            this.endOfRecord();
            this.currentStreamPosition = -1L;
            return this.builder.build();
        }
    }

    public final class IndexRecord {
        private final int index;
        private final String description;
        private final long length;
        private final int indexStart;
        private final List<String> ids = new ArrayList<String>();

        public IndexRecord(int index, String description, long length, int indexStart) {
            this.index = index;
            this.description = description;
            this.length = length;
            this.indexStart = indexStart;
        }

        public List<String> getIds() {
            return Collections.unmodifiableList(this.ids);
        }

        public String getDescription() {
            return this.description;
        }

        public long getLength() {
            return this.length;
        }

        public long queryPosition(long offset) {
            if (offset < 0L || offset >= this.length) {
                throw new IndexOutOfBoundsException();
            }
            int indexOffset = (int)(offset / (long)RandomAccessFastaIndex.this.indexStep);
            return RandomAccessFastaIndex.this.indexArray[this.indexStart + indexOffset] << 20 | offset - (long)indexOffset * (long)RandomAccessFastaIndex.this.indexStep;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexRecord)) {
                return false;
            }
            IndexRecord that = (IndexRecord)o;
            if (this.length != that.length) {
                return false;
            }
            if (this.indexStart != that.indexStart) {
                return false;
            }
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        public int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + this.indexStart;
            return result;
        }
    }
}

