/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fasta;

import com.milaboratory.core.Range;
import com.milaboratory.core.io.sequence.fasta.RandomAccessFastaIndex;
import com.milaboratory.core.sequence.AbstractSeq;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.core.sequence.provider.SequenceProvider;
import com.milaboratory.core.sequence.provider.SequenceProviderIndexOutOfBoundsException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public final class RandomAccessFastaReader<S extends Sequence<S>>
implements AutoCloseable {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final ByteBuffer buffer;
    private final SeekableByteChannel channel;
    final RandomAccessFastaIndex index;
    final Alphabet<S> alphabet;

    public RandomAccessFastaReader(String file, Alphabet<S> alphabet) {
        this(Paths.get(file, new String[0]), alphabet);
    }

    public RandomAccessFastaReader(Path file, Alphabet<S> alphabet) {
        this(file, RandomAccessFastaIndex.index(file), alphabet);
    }

    public RandomAccessFastaReader(String file, Alphabet<S> alphabet, boolean saveIndexFile) {
        this(Paths.get(file, new String[0]), alphabet, saveIndexFile);
    }

    public RandomAccessFastaReader(Path file, Alphabet<S> alphabet, boolean saveIndexFile) {
        this(file, RandomAccessFastaIndex.index(file, saveIndexFile), alphabet);
    }

    public RandomAccessFastaReader(Path file, RandomAccessFastaIndex index, Alphabet<S> alphabet) {
        this(RandomAccessFastaReader.openChannel(file), index, alphabet, 4096);
    }

    public RandomAccessFastaReader(SeekableByteChannel channel, RandomAccessFastaIndex index, Alphabet<S> alphabet, int bufferSize) {
        this.channel = channel;
        this.index = index;
        this.alphabet = alphabet;
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    public Alphabet<S> getAlphabet() {
        return this.alphabet;
    }

    public RandomAccessFastaIndex getIndex() {
        return this.index;
    }

    public SequenceProvider<S> getSequenceProvider(int id) {
        return this.getSequenceProvider(this.index.getRecordByIndex(id));
    }

    public SequenceProvider<S> getSequenceProvider(String id) {
        return this.getSequenceProvider(this.index.getRecordByIdCheck(id));
    }

    public S getSequence(int id, Range range) {
        return this.read(this.index.getRecordByIndex(id), range);
    }

    public S getSequence(String id, Range range) {
        return this.read(this.index.getRecordByIdCheck(id), range);
    }

    private SequenceProvider<S> getSequenceProvider(final RandomAccessFastaIndex.IndexRecord record) {
        return new SequenceProvider<S>(){

            @Override
            public int size() {
                return (int)record.getLength();
            }

            @Override
            public S getRegion(Range range) {
                return RandomAccessFastaReader.this.read(record, range);
            }
        };
    }

    private synchronized S read(RandomAccessFastaIndex.IndexRecord record, Range range) {
        if ((long)range.getUpper() > record.getLength()) {
            throw new SequenceProviderIndexOutOfBoundsException(range.intersection(new Range(0, (int)record.getLength())));
        }
        try {
            long qResult = record.queryPosition(range.getLower());
            this.channel.position(RandomAccessFastaIndex.extractFilePosition(qResult));
            SequenceBuilder<byte> builder = this.alphabet.createBuilder().ensureCapacity(range.length());
            int toSkip = RandomAccessFastaIndex.extractSkipLetters(qResult);
            int toRead = range.length();
            while (toSkip > 0 || toRead > 0) {
                this.buffer.clear();
                this.channel.read(this.buffer);
                this.buffer.flip();
                while (this.buffer.hasRemaining() && (toSkip > 0 || toRead > 0)) {
                    byte b = this.buffer.get();
                    if (b == 10 || b == 13) continue;
                    if (toSkip > 0) {
                        --toSkip;
                        continue;
                    }
                    builder.append(this.alphabet.symbolToCode((char)b));
                    --toRead;
                }
            }
            assert (builder.size() == range.length());
            S seq = builder.createAndDestroy();
            return (S)((Sequence)((AbstractSeq)seq).getRange(range.move(-range.getLower())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.channel.close();
    }

    private static SeekableByteChannel openChannel(Path file) {
        try {
            return FileChannel.open(file, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

