/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fastq;

import com.milaboratory.core.io.sequence.IllegalFileFormatException;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReadImpl;
import com.milaboratory.core.io.sequence.SingleReadLazy;
import com.milaboratory.core.io.sequence.fastq.QualityFormat;
import com.milaboratory.core.sequence.UnsafeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FastqRecordsReader
implements AutoCloseable {
    private static final byte DELIMITER = 10;
    final boolean lazyReads;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final InputDataWrapper inputStream;
    final int bufferSize;
    byte[] buffer;
    int currentBufferSize;
    int pointer;
    int descriptionBegin;
    int sequenceBegin;
    int sequenceEnd;
    int qualityBegin;
    int qualityEnd;
    final boolean autoClose;
    final boolean replaceWildcards;

    public FastqRecordsReader(boolean lazyReads, RandomAccessFile inputStream, int bufferSize, boolean replaceWildcards, boolean autoClose) {
        this(lazyReads, FastqRecordsReader.create(inputStream), bufferSize, replaceWildcards, autoClose);
    }

    public FastqRecordsReader(boolean lazyReads, InputStream inputStream, int bufferSize, boolean replaceWildcards, boolean autoClose) {
        this(lazyReads, FastqRecordsReader.create(inputStream), bufferSize, replaceWildcards, autoClose);
    }

    private FastqRecordsReader(boolean lazyReads, InputDataWrapper inputStream, int bufferSize, boolean replaceWildcards, boolean autoClose) {
        this.lazyReads = lazyReads;
        this.inputStream = inputStream;
        this.bufferSize = bufferSize;
        this.replaceWildcards = replaceWildcards;
        this.autoClose = autoClose;
    }

    public SingleRead createRead(long id, QualityFormat format) {
        if (this.lazyReads) {
            return SingleReadLazy.create(format, id, this.buffer, this.descriptionBegin, (short)(this.sequenceBegin - this.descriptionBegin), (short)(this.qualityBegin - this.descriptionBegin), (short)(this.sequenceEnd - this.sequenceBegin), (short)(this.sequenceBegin - this.descriptionBegin - 1), this.replaceWildcards);
        }
        return new SingleReadImpl(id, UnsafeFactory.fastqParse(this.buffer, this.sequenceBegin, this.qualityBegin, this.sequenceEnd - this.sequenceBegin, format.getOffset(), id, this.replaceWildcards), new String(this.buffer, this.descriptionBegin, this.sequenceBegin - this.descriptionBegin - 1));
    }

    void fillBuffer(int size) throws IOException {
        int readBytes;
        byte[] newBuffer;
        if (this.closed.get()) {
            return;
        }
        if (this.lazyReads) {
            newBuffer = new byte[size];
        } else {
            if (this.buffer == null) {
                this.buffer = new byte[size];
            }
            newBuffer = this.buffer.length != size ? new byte[size] : this.buffer;
        }
        if (this.buffer != null) {
            System.arraycopy(this.buffer, this.pointer, newBuffer, 0, this.currentBufferSize - this.pointer);
        }
        this.currentBufferSize = ((readBytes = this.inputStream.readFully(newBuffer, this.currentBufferSize - this.pointer, newBuffer.length - this.currentBufferSize + this.pointer)) == -1 ? 0 : readBytes) + this.currentBufferSize - this.pointer;
        this.pointer = 0;
        this.buffer = newBuffer;
        if (readBytes == -1 && this.autoClose) {
            this.close();
        }
    }

    public boolean nextRecord(boolean refillBuffer) throws IOException {
        int pointer;
        block23: {
            int pass = -1;
            while (true) {
                if (++pass == 2) {
                    if (this.closed.get()) {
                        throw new IllegalFileFormatException("Unexpected end of file.");
                    }
                    throw new IllegalFileFormatException("Too small buffer.");
                }
                if (this.buffer == null) {
                    if (!refillBuffer) {
                        throw new RuntimeException();
                    }
                    this.fillBuffer(this.bufferSize);
                    continue;
                }
                if (this.currentBufferSize == 0) {
                    return false;
                }
                if (this.currentBufferSize == this.pointer) {
                    if (refillBuffer) {
                        this.fillBuffer(this.bufferSize);
                        continue;
                    }
                    return false;
                }
                if (this.buffer[this.pointer] != 64) {
                    throw new IllegalFileFormatException();
                }
                pointer = this.pointer;
                this.descriptionBegin = ++pointer;
                while (pointer < this.currentBufferSize && this.buffer[pointer] != 10) {
                    ++pointer;
                }
                if (pointer == this.buffer.length) {
                    if (refillBuffer) {
                        this.fillBuffer(this.bufferSize);
                        continue;
                    }
                    return false;
                }
                this.sequenceBegin = ++pointer;
                while (pointer < this.currentBufferSize && this.buffer[pointer] != 10) {
                    ++pointer;
                }
                if (pointer == this.buffer.length) {
                    if (refillBuffer) {
                        this.fillBuffer(this.bufferSize);
                        continue;
                    }
                    return false;
                }
                this.sequenceEnd = pointer++;
                if (pointer == this.buffer.length) {
                    if (refillBuffer) {
                        this.fillBuffer(this.bufferSize);
                        continue;
                    }
                    return false;
                }
                if (this.buffer[pointer] != 43) {
                    throw new IllegalFileFormatException();
                }
                while (pointer < this.currentBufferSize && this.buffer[pointer] != 10) {
                    ++pointer;
                }
                if (pointer == this.buffer.length) {
                    if (refillBuffer) {
                        this.fillBuffer(this.bufferSize);
                        continue;
                    }
                    return false;
                }
                this.qualityBegin = ++pointer;
                while (pointer < this.currentBufferSize && this.buffer[pointer] != 10) {
                    ++pointer;
                }
                if (pointer != this.buffer.length) break block23;
                if (!refillBuffer) break;
                this.fillBuffer(this.bufferSize);
            }
            return false;
        }
        this.qualityEnd = pointer;
        if (this.qualityEnd - this.qualityBegin != this.sequenceEnd - this.sequenceBegin) {
            throw new IllegalFileFormatException("Quality and sequence have different sizes.");
        }
        this.pointer = pointer + 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            InputDataWrapper inputDataWrapper = this.inputStream;
            synchronized (inputDataWrapper) {
                this.inputStream.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    void resetBuffer() throws IOException {
        this.currentBufferSize = 0;
        this.pointer = 0;
        this.fillBuffer(this.bufferSize);
    }

    private static final InputDataWrapper create(final InputStream stream) {
        return new InputDataWrapper(){

            @Override
            public int read(byte[] buffer, int off, int len) throws IOException {
                return stream.read(buffer, off, len);
            }

            @Override
            public void close() throws IOException {
                stream.close();
            }
        };
    }

    private static final InputDataWrapper create(final RandomAccessFile stream) {
        return new InputDataWrapper(){

            @Override
            public int read(byte[] buffer, int off, int len) throws IOException {
                return stream.read(buffer, off, len);
            }

            @Override
            public void close() throws IOException {
                stream.close();
            }
        };
    }

    private static abstract class InputDataWrapper {
        private InputDataWrapper() {
        }

        abstract int read(byte[] var1, int var2, int var3) throws IOException;

        abstract void close() throws IOException;

        int readFully(byte[] buffer, int off, int len) throws IOException {
            int read;
            int total = 0;
            while ((read = this.read(buffer, off, len)) != -1) {
                total += read;
                off += read;
                if ((len -= read) != 0) continue;
            }
            return total;
        }
    }
}

